/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.SDMSDesktop;

import de.independit.scheduler.server.output.SDMSLineRenderer;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputError;
import de.independit.scheduler.server.output.SDMSOutputRenderer;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;

public class SDMSServerConnection {
    public static final String __version = "@(#) $Id: SDMSServerConnection.java,v 2.1.18.1 2013/03/14 10:24:04 ronald Exp $";
    String host;
    int port;
    String user;
    String passwd;
    Socket svrConnection = null;
    ObjectInputStream in = null;
    PrintStream out = null;
    boolean isJob = false;

    public SDMSServerConnection(String string, int n, String string2, String string3) {
        this.host = string;
        this.port = n;
        this.user = string2;
        try {
            Long.parseLong(string2);
            this.isJob = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.passwd = string3;
    }

    public SDMSOutput connect() throws IOException {
        this.svrConnection = new Socket();
        this.svrConnection.setPerformancePreferences(0, 1, 0);
        this.svrConnection.setTcpNoDelay(true);
        this.svrConnection.connect(new InetSocketAddress(InetAddress.getByName(this.host), this.port));
        DataInputStream dataInputStream = new DataInputStream(this.svrConnection.getInputStream());
        if (((InputStream)dataInputStream).available() > 0) {
            byte[] byArray = new byte[5000];
            ((InputStream)dataInputStream).read(byArray);
        }
        this.out = new PrintStream(this.svrConnection.getOutputStream());
        return this.execute("connect " + (this.isJob ? "job " : "") + this.user + " identified by '" + this.passwd + "' with protocol = SERIAL;");
    }

    public SDMSOutput execute(String string) {
        Object object;
        SDMSOutput sDMSOutput = null;
        String string2 = string.trim();
        System.out.println(string2);
        try {
            this.out.print(string2);
            if (!string2.endsWith(";")) {
                this.out.print(";");
            }
            this.out.println("");
            this.in = new ObjectInputStream(this.svrConnection.getInputStream());
            sDMSOutput = (SDMSOutput)this.in.readObject();
            object = new DataInputStream(this.svrConnection.getInputStream());
            if (((InputStream)object).available() > 0) {
                byte[] byArray = new byte[5000];
                int n = ((InputStream)object).read(byArray);
                System.err.println("got " + n + " additional bytes!");
            }
        }
        catch (EOFException eOFException) {
            sDMSOutput = new SDMSOutput();
            sDMSOutput.setError(new SDMSOutputError("Desktop-0002", "Connection closed by Server"));
        }
        catch (SocketException socketException) {
            sDMSOutput = new SDMSOutput();
            sDMSOutput.setError(new SDMSOutputError("Desktop-0003", "Connection closed by Server"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.toString());
            sDMSOutput = new SDMSOutput();
            sDMSOutput.setError(new SDMSOutputError("Desktop-0001", "Server Error executing command"));
        }
        try {
            object = new SDMSLineRenderer();
            ((SDMSOutputRenderer)object).render(System.out, sDMSOutput);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(1);
        }
        return sDMSOutput;
    }

    public void finish() throws IOException {
        this.out.println("disconnect;");
        this.closeall();
    }

    public void stopServer() {
        try {
            this.out.println("stop server;");
            this.closeall();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeall() throws IOException {
        this.in.close();
        this.out.close();
        this.svrConnection.close();
    }
}

