/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.client;

import de.independit.scheduler.client.CommandInterface;
import de.independit.scheduler.client.MainScreen_AboutBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class MainScreen
extends JFrame {
    public static final String __version = "@(#) $Id: MainScreen.java,v 2.0.20.1 2013/03/14 10:24:04 ronald Exp $";
    JPanel contentPane;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JToolBar jToolBar = new JToolBar();
    JButton jbConnect = new JButton();
    JButton jbStopServer = new JButton();
    JButton jbCleanLog = new JButton();
    JButton jbExit = new JButton();
    JButton jbHelp = new JButton();
    ImageIcon image1c;
    ImageIcon image1d;
    ImageIcon image2;
    ImageIcon image3;
    ImageIcon image4;
    ImageIcon image5;
    public boolean connected = false;
    JLabel statusBar = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JTextPane jTextPane1 = new JTextPane(){

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }
    };
    Document log;
    JScrollPane jScrollPane1 = new JScrollPane(this.jTextPane1);
    JTextField jTextField1 = new JTextField();
    CommandInterface ci;

    public MainScreen() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.image1c = new ImageIcon(MainScreen.class.getResource("connect.gif"));
        this.image1d = new ImageIcon(MainScreen.class.getResource("disconnect.gif"));
        this.image2 = new ImageIcon(MainScreen.class.getResource("kill.gif"));
        this.image3 = new ImageIcon(MainScreen.class.getResource("cleanlog.gif"));
        this.image4 = new ImageIcon(MainScreen.class.getResource("exit.gif"));
        this.image5 = new ImageIcon(MainScreen.class.getResource("help.gif"));
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(470, 350));
        this.setTitle("Frame Title");
        this.statusBar.setText(" ");
        this.jMenuFile.setText("File");
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainScreen.this.jMenuFileExit_actionPerformed(actionEvent);
            }
        });
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainScreen.this.jMenuHelpAbout_actionPerformed(actionEvent);
            }
        });
        this.jbConnect.setIcon(this.image1c);
        this.jbConnect.setToolTipText("Connect/Disconnect");
        this.jbConnect.setBounds(this.jbConnect.getX(), this.jbConnect.getY(), 34, 34);
        this.jbConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MainScreen.this.connected) {
                    if (MainScreen.this.do_connect()) {
                        MainScreen.this.jbConnect.setIcon(MainScreen.this.image1d);
                        MainScreen.this.connected = true;
                    } else {
                        try {
                            MainScreen.this.log.insertString(MainScreen.this.log.getLength(), "Error Connecting...\n> ", MainScreen.this.jTextPane1.getStyle("italic"));
                        }
                        catch (BadLocationException badLocationException) {
                            System.exit(1);
                        }
                    }
                } else {
                    MainScreen.this.do_disconnect();
                    MainScreen.this.jbConnect.setIcon(MainScreen.this.image1c);
                    MainScreen.this.connected = false;
                }
            }
        });
        this.jbStopServer.setIcon(this.image2);
        this.jbStopServer.setToolTipText("Stop Server");
        this.jbStopServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainScreen.this.do_stopserver()) {
                    MainScreen.this.connected = false;
                    MainScreen.this.jbConnect.setIcon(MainScreen.this.image1c);
                } else {
                    try {
                        MainScreen.this.log.insertString(MainScreen.this.log.getLength(), "Failed to stop Server ...\n> ", MainScreen.this.jTextPane1.getStyle("italic"));
                    }
                    catch (BadLocationException badLocationException) {
                        System.exit(1);
                    }
                }
            }
        });
        this.jbCleanLog.setIcon(this.image3);
        this.jbCleanLog.setToolTipText("ClearScreen");
        this.jbCleanLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MainScreen.this.log.remove(0, MainScreen.this.log.getLength());
                    MainScreen.this.log.insertString(MainScreen.this.log.getLength(), "SDMS> ", MainScreen.this.jTextPane1.getStyle("italic"));
                }
                catch (BadLocationException badLocationException) {
                    System.exit(1);
                }
            }
        });
        this.jbExit.setIcon(this.image4);
        this.jbExit.setToolTipText("Exit Program");
        this.jbExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainScreen.this.jMenuFileExit_actionPerformed(actionEvent);
            }
        });
        this.jbHelp.setIcon(this.image5);
        this.jbHelp.setToolTipText("About");
        this.jbHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainScreen.this.jMenuHelpAbout_actionPerformed(actionEvent);
            }
        });
        this.jPanel1.setLayout(this.borderLayout2);
        this.jScrollPane1.setPreferredSize(new Dimension(450, 220));
        this.jScrollPane1.setBackground(Color.white);
        this.jScrollPane1.getViewport().setBackground(Color.white);
        this.jScrollPane1.setHorizontalScrollBarPolicy(30);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jTextPane1.setEditable(false);
        this.initStyles(this.jTextPane1);
        this.log = this.jTextPane1.getDocument();
        this.log.insertString(0, "> ", this.jTextPane1.getStyle("italic"));
        this.jTextField1.setMinimumSize(new Dimension(450, 20));
        this.jTextField1.setPreferredSize(new Dimension(450, 20));
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainScreen.this.jTextFieldEntry(actionEvent);
            }
        });
        this.jTextField1.setRequestFocusEnabled(true);
        this.jTextField1.requestFocus();
        this.jToolBar.add(this.jbConnect);
        this.jToolBar.add(this.jbStopServer);
        this.jToolBar.add(this.jbCleanLog);
        this.jToolBar.add(this.jbExit);
        this.jToolBar.add(this.jbHelp);
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.contentPane.add((Component)this.jToolBar, "North");
        this.contentPane.add((Component)this.statusBar, "South");
        this.contentPane.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.add((Component)this.jTextField1, "South");
    }

    public void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        MainScreen_AboutBox mainScreen_AboutBox = new MainScreen_AboutBox(this);
        Dimension dimension = mainScreen_AboutBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        mainScreen_AboutBox.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        mainScreen_AboutBox.setModal(true);
        mainScreen_AboutBox.show();
    }

    private void process_file(String string) throws BadLocationException {
        Object object;
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(new FileInputStream(string)));
            System.out.println("---- START ----");
            while ((object = lineNumberReader.readLine()) != null) {
                this.ci.tell((String)object);
            }
            lineNumberReader.close();
            System.out.println("---- READY ----");
        }
        catch (IOException iOException) {
            this.log.insertString(this.log.getLength(), iOException.toString(), this.jTextPane1.getStyle("regular"));
        }
        this.jScrollPane1.validate();
        object = this.jScrollPane1.getVerticalScrollBar();
        ((JScrollBar)object).setValue(((JScrollBar)object).getMaximum());
    }

    public void jTextFieldEntry(ActionEvent actionEvent) {
        Object object;
        String string = this.jTextField1.getText();
        try {
            this.log.insertString(this.log.getLength(), string + "\n", this.jTextPane1.getStyle("italic"));
            if (string.substring(0, 1).equals("@")) {
                final String string2 = string.substring(1);
                object = new Thread(){

                    @Override
                    public void run() {
                        try {
                            MainScreen.this.process_file(string2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                ((Thread)object).start();
            } else {
                this.log.insertString(this.log.getLength(), this.ci.tell(string), this.jTextPane1.getStyle("regular"));
            }
        }
        catch (BadLocationException badLocationException) {
            System.exit(1);
        }
        catch (IOException iOException) {
            System.exit(1);
        }
        this.jScrollPane1.validate();
        object = this.jScrollPane1.getVerticalScrollBar();
        ((JScrollBar)object).setValue(((JScrollBar)object).getMaximum());
        this.jTextField1.selectAll();
    }

    public boolean do_connect() {
        if (this.ci != null) {
            return false;
        }
        try {
            this.ci = new CommandInterface("localhost", 2506, "donald", "duck");
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean do_stopserver() {
        if (this.ci == null && !this.do_connect()) {
            return false;
        }
        this.ci.stopServer();
        this.ci = null;
        return true;
    }

    public void do_disconnect() {
        if (this.ci == null) {
            return;
        }
        try {
            this.ci.finish();
            this.ci = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    private void initStyles(JTextPane jTextPane) {
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = jTextPane.addStyle("regular", style);
        StyleConstants.setFontFamily(style, "Courier");
        Style style3 = jTextPane.addStyle("italic", style2);
        StyleConstants.setItalic(style3, true);
    }
}

