/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.UserConnection;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSJsonRenderer;
import de.independit.scheduler.server.output.SDMSLineRenderer;
import de.independit.scheduler.server.output.SDMSOutputRenderer;
import de.independit.scheduler.server.output.SDMSPerlRenderer;
import de.independit.scheduler.server.output.SDMSPythonRenderer;
import de.independit.scheduler.server.output.SDMSSerialRenderer;
import de.independit.scheduler.server.output.SDMSTimeRenderer;
import de.independit.scheduler.server.output.SDMSXmlRenderer;
import de.independit.scheduler.server.repository.SDMSMember;
import de.independit.scheduler.server.repository.SDMSTransaction;
import de.independit.scheduler.server.util.SDMSThread;
import de.independit.scheduler.server.util.SyncFifo;
import de.independit.scheduler.server.util.ThreadLock;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;

public class ConnectionEnvironment {
    public static final String __version = "@(#) $Id: ConnectionEnvironment.java,v 2.12.2.1 2013/03/14 10:24:08 ronald Exp $";
    public static final int IDLE = 0;
    public static final int QUEUED = 1;
    public static final int ACTIVE = 2;
    public static final int COMMITTING = 3;
    public static final int CONNECTED = 4;
    public static final int PARSING = 5;
    public static final int RENDERING = 6;
    public static final String[] stateNames = new String[]{"IDLE", "QUEUED", "ACTIVE", "COMMITTING", "CONNECTED", "PARSING", "RENDERING"};
    protected final int id;
    protected final String name;
    protected long start;
    protected long last;
    protected Date dStart;
    protected PrintStream ostream;
    protected Long uid;
    protected HashSet gid;
    protected SyncFifo cmdQueue;
    protected SyncFifo roCmdQueue;
    protected SDMSThread me;
    protected ThreadLock lock;
    protected boolean jobServer;
    protected boolean job;
    protected boolean user;
    public SDMSTransaction tx;
    protected SDMSOutputRenderer renderer;
    protected boolean trace;
    protected int tracelevel;
    protected final int port;
    protected int state;
    public String actstmt;
    public String firstToken;
    protected InetAddress userNode;
    protected String info;
    private Stack groupStack;
    public SDMSThread worker;
    public HashMap SSOInfo;
    private boolean isSSLConnection;
    private boolean isClientAuthenticated;
    protected Long prev_uid;
    protected HashSet prev_gid;
    protected boolean prev_trace;
    protected int prev_tracelevel;

    public ConnectionEnvironment(int n, String string, boolean bl, PrintStream printStream, SyncFifo syncFifo, SyncFifo syncFifo2, int n2, InetAddress inetAddress, boolean bl2, boolean bl3) {
        this.id = n;
        this.name = string;
        this.ostream = printStream;
        this.last = this.start = System.currentTimeMillis();
        this.dStart = new Date(this.start);
        this.cmdQueue = syncFifo;
        this.roCmdQueue = syncFifo2;
        this.lock = new ThreadLock();
        this.renderer = new SDMSLineRenderer();
        this.trace = bl;
        this.port = n2;
        this.actstmt = null;
        this.firstToken = null;
        this.info = null;
        this.state = 4;
        this.groupStack = new Stack();
        this.userNode = inetAddress;
        this.tracelevel = 0;
        this.worker = null;
        this.prev_uid = null;
        this.isSSLConnection = bl2;
        this.isClientAuthenticated = bl3;
    }

    public ConnectionEnvironment(int n, boolean bl, PrintStream printStream, SyncFifo syncFifo, SyncFifo syncFifo2, int n2, InetAddress inetAddress, boolean bl2, boolean bl3) {
        this(n, null, bl, printStream, syncFifo, syncFifo2, n2, inetAddress, bl2, bl3);
    }

    public ConnectionEnvironment(int n, String string, boolean bl, PrintStream printStream, SyncFifo syncFifo, SyncFifo syncFifo2, InetAddress inetAddress) {
        this(n, string, bl, printStream, syncFifo, syncFifo2, 0, inetAddress, false, false);
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name != null ? this.name : new Integer(this.id).toString();
    }

    public long start() {
        return this.start;
    }

    public long last() {
        return this.last;
    }

    public long idle() {
        return (System.currentTimeMillis() - this.last + 500L) / 1000L;
    }

    public Date dStart() {
        return this.dStart;
    }

    public PrintStream ostream() {
        return this.ostream;
    }

    public Long uid() {
        return this.uid;
    }

    public HashSet gid() {
        return this.gid;
    }

    public void setUid(Long l) {
        this.uid = l;
    }

    public int timeout() {
        return ((UserConnection)this.me).getTimeout();
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public boolean getIsSSLConnection() {
        return this.isSSLConnection;
    }

    public boolean getIsClientAuthenticated() {
        return this.isClientAuthenticated;
    }

    public String ip() {
        if (this.userNode != null) {
            return this.userNode.getHostAddress();
        }
        return null;
    }

    public InetAddress getAddress() {
        return this.userNode;
    }

    public void setGid(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        if (vector.size() == 0) {
            this.gid = new HashSet();
            return;
        }
        this.gid = new HashSet(vector.size() * 2);
        for (int i = 0; i < vector.size(); ++i) {
            this.gid.add(((SDMSMember)vector.get(i)).getGId(systemEnvironment));
        }
    }

    public void addGid(Long l) {
        if (this.gid == null) {
            this.gid = new HashSet();
        }
        this.gid.add(l);
    }

    public void delGid(Long l) {
        if (this.gid == null) {
            return;
        }
        this.gid.remove(l);
    }

    public void pushGid(SystemEnvironment systemEnvironment, HashSet hashSet) throws SDMSException {
        this.groupStack.push(this.gid);
        this.gid = hashSet;
    }

    public void popGid(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.groupStack.isEmpty()) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03401301115", "Groupstack is empty. Unbalanced change group"));
        }
        this.gid = (HashSet)this.groupStack.pop();
    }

    public void emptyGid(SystemEnvironment systemEnvironment) throws SDMSException {
        while (!this.groupStack.isEmpty()) {
            SDMSThread.doTrace(this, "Unbalanced push(gid) : \n\t" + this.toString(), 1);
            this.gid = (HashSet)this.groupStack.pop();
        }
    }

    public int port() {
        return this.port;
    }

    public SyncFifo cmdQueue() {
        return this.cmdQueue;
    }

    public SyncFifo roCmdQueue() {
        return this.roCmdQueue;
    }

    public void setMe(SDMSThread sDMSThread) {
        this.me = sDMSThread;
    }

    public SDMSThread getMe() {
        return this.me;
    }

    public ThreadLock lock() {
        return this.lock;
    }

    public boolean isJobServer() {
        return this.jobServer;
    }

    public boolean isJob() {
        return this.job;
    }

    public boolean isUser() {
        return this.user;
    }

    public void setJobServer() {
        this.jobServer = true;
        this.job = false;
        this.user = false;
    }

    public void setJob() {
        this.job = true;
        this.jobServer = false;
        this.user = false;
    }

    public void setUser() {
        this.user = true;
        this.jobServer = false;
        this.job = false;
    }

    public void trace_on() {
        this.trace = true;
    }

    public void trace_off() {
        this.trace = false;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public boolean trace() {
        return this.trace;
    }

    public void setTraceLevel(int n) {
        this.tracelevel = n;
    }

    public int getTraceLevel() {
        return this.tracelevel;
    }

    public void setLast() {
        this.last = System.currentTimeMillis();
    }

    public SDMSOutputRenderer renderer() {
        return this.renderer;
    }

    public void setRenderer(SDMSOutputRenderer sDMSOutputRenderer) {
        this.renderer = sDMSOutputRenderer;
    }

    public void setRenderer(int n) {
        this.renderer = null;
        switch (n) {
            case 632: {
                this.renderer = new SDMSXmlRenderer();
                break;
            }
            case 436: {
                this.renderer = new SDMSLineRenderer();
                break;
            }
            case 508: {
                this.renderer = new SDMSPerlRenderer();
                break;
            }
            case 516: {
                this.renderer = new SDMSPythonRenderer();
                break;
            }
            case 425: {
                this.renderer = new SDMSJsonRenderer();
                break;
            }
            case 562: {
                this.renderer = new SDMSSerialRenderer();
                break;
            }
            case 599: {
                this.renderer = new SDMSTimeRenderer();
            }
        }
    }

    public long versionId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.tx.versionId(systemEnvironment);
    }

    public long txId() {
        return this.tx.txId;
    }

    public void proto_input(String string) {
        ((UserConnection)this.me).scanner.proto_input(string);
    }

    public void setState(int n) {
        if (n == 0 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 6) {
            this.state = n;
        }
    }

    public String getState() {
        return stateNames[this.state];
    }

    public String toString() {
        String string = "Id : " + this.id + ", Name : " + this.name + ", Start : " + this.start + ", Last : " + this.last + ", Uid : " + this.uid + ", Type : " + (this.user ? "User" : (this.job ? "Job" : "Jobserver")) + ", Trace : " + this.trace + ", Port : " + this.port + ", State : " + stateNames[this.state];
        return string;
    }

    public boolean setConnectedUser(SystemEnvironment systemEnvironment, Long l, Vector vector) throws SDMSException {
        this.prev_uid = this.uid;
        this.prev_gid = this.gid;
        this.prev_trace = this.trace;
        this.prev_tracelevel = this.tracelevel;
        this.setUid(l);
        this.setGid(systemEnvironment, vector);
        return true;
    }

    public boolean resetConnectedUser() {
        if (this.prev_uid != null) {
            this.uid = this.prev_uid;
            this.gid = this.prev_gid;
            this.trace = this.prev_trace;
            this.tracelevel = this.prev_tracelevel;
            this.prev_uid = null;
            this.prev_gid = null;
            this.prev_trace = false;
            this.prev_tracelevel = 0;
            return true;
        }
        return false;
    }
}

