/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.InternalSession;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.TimeSchedule;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SerializationException;
import de.independit.scheduler.server.locking.LockingSystem;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventParameter;
import de.independit.scheduler.server.repository.SDMSEventParameterTable;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcher;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcherTable;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchy;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSPersistentValue;
import de.independit.scheduler.server.repository.SDMSPersistentValueTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.timer.TimerDate;
import de.independit.scheduler.server.util.DateTime;
import de.independit.scheduler.server.util.SDMSThread;
import de.independit.scheduler.server.util.SyncFifo;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class TimerThread
extends InternalSession {
    public static final String __version = "@(#) $Id: TimerThread.java,v 2.29.2.2 2013/03/20 11:27:15 ronald Exp $";
    public static final String name = "TimerThread";
    public static final int CREATE = 1;
    public static final int ALTER = 2;
    public static final int DROP = 3;
    private static final GregorianCalendar gc = SystemEnvironment.newGregorianCalendar();
    private static final String LAST_SCHEDULE_RUN = "LAST_SCHEDULE_RUN";
    private final TimerDate now = new TimerDate();
    private final TimerDate lastRun = new TimerDate();
    private static final long warnLimitInMilis = 1000L;
    private boolean aliveSinceLong = false;
    private Long nowLong;
    private final TimerDate suspendNow = new TimerDate();
    private int current = 0;
    private int total = 0;
    private final HashSet ivalIds = new HashSet();

    public TimerThread(SystemEnvironment systemEnvironment, SyncFifo syncFifo) {
        super(name);
        this.NR = 19630127;
        this.initThread(systemEnvironment, syncFifo, this.NR, name, SystemEnvironment.timerWakeupInterval);
    }

    @Override
    protected Node getNode(int n) {
        if (n == 1) {
            return new TimeSchedule(1);
        }
        return new TimeSchedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadNow() {
        GregorianCalendar gregorianCalendar = gc;
        synchronized (gregorianCalendar) {
            gc.setTimeInMillis(System.currentTimeMillis());
            gc.set(13, 0);
            gc.set(14, 0);
            this.now.set(TimerDate.fromMillis(gc.getTimeInMillis()));
        }
    }

    public static final Long dateToDateTimeLong(TimerDate timerDate) {
        return timerDate.isNaD() ? null : new DateTime(timerDate).toLong();
    }

    private final void loadLastRun(SystemEnvironment systemEnvironment) throws SDMSException {
        try {
            SDMSPersistentValue sDMSPersistentValue = SDMSPersistentValueTable.idx_name_getUnique(systemEnvironment, LAST_SCHEDULE_RUN);
            Integer n = sDMSPersistentValue.getIntValue(systemEnvironment);
            this.lastRun.set(n);
            this.aliveSinceLong = (long)n.intValue() > SystemEnvironment.startTime / 60000L;
        }
        catch (NotFoundException notFoundException) {
            SDMSPersistentValueTable.table.create(systemEnvironment, LAST_SCHEDULE_RUN, new Integer(this.now.toMinutes()));
            this.lastRun.set(this.now);
            this.aliveSinceLong = false;
        }
    }

    private final void setLastRunToNow(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSPersistentValue sDMSPersistentValue = SDMSPersistentValueTable.idx_name_getUniqueForUpdate(systemEnvironment, LAST_SCHEDULE_RUN);
        sDMSPersistentValue.setIntValue(systemEnvironment, new Integer(this.now.toMinutes()));
        this.lastRun.set(this.now);
    }

    private final String toString(Exception exception) {
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        String string = exception.toString();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            string = string + "\n" + stackTraceElementArray[i];
        }
        return string;
    }

    private final void doSubmit(SystemEnvironment systemEnvironment, SDMSEvent sDMSEvent, Long l, TimerDate timerDate, TimerDate timerDate2, String string) throws SDMSException {
        Comparable comparable;
        Object object;
        Object object2;
        int n;
        Long l2 = sDMSEvent.getId(systemEnvironment);
        Long l3 = sDMSEvent.getSeId(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3);
        Vector<WithItem> vector = new Vector<WithItem>();
        Vector vector2 = SDMSEventParameterTable.idx_evtId.getVector(systemEnvironment, l2);
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            SDMSEventParameter sDMSEventParameter = (SDMSEventParameter)vector2.get(n);
            object2 = sDMSEventParameter.getKey(systemEnvironment);
            object = sDMSEventParameter.getValue(systemEnvironment).substring(1);
            comparable = new WithItem((Comparable)object2, object);
            vector.add((WithItem)comparable);
        }
        n = timerDate.lt(timerDate2) ? 1 : 0;
        boolean bl = sDMSSchedulingEntity.getSubmitSuspended(systemEnvironment);
        object2 = n != 0 || bl ? Boolean.TRUE : Boolean.FALSE;
        object = sDMSSchedulingEntity.submitMaster(systemEnvironment, vector, new Integer(((Boolean)object2).booleanValue() ? 1 : 0), null, l, null, "Event " + sDMSEvent.getName(systemEnvironment), string);
        if (n != 0) {
            comparable = ((SDMSProxy)object).getId(systemEnvironment);
            SDMSAuditTrailTable.table.create(systemEnvironment, systemEnvironment.cEnv.uid(), new Long(new Date().getTime()), new Integer(21), new Integer(17), (Long)comparable, (Long)comparable, Boolean.FALSE, "trigger=" + timerDate + ", limit=" + timerDate2, null);
        }
    }

    private final void doSchedule(SystemEnvironment systemEnvironment, SDMSScheduledEvent sDMSScheduledEvent) throws SDMSException {
        this.doSchedule(systemEnvironment, sDMSScheduledEvent, true);
    }

    private final void doSchedule(SystemEnvironment systemEnvironment, SDMSScheduledEvent sDMSScheduledEvent, boolean bl) throws SDMSException {
        TimerDate timerDate;
        TimerDate timerDate2;
        long l = new Date().getTime();
        Long l2 = sDMSScheduledEvent.getSceId(systemEnvironment);
        SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, l2);
        Long l3 = sDMSScheduledEvent.getEvtId(systemEnvironment);
        SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, l3);
        Long l4 = sDMSScheduledEvent.getOwnerId(systemEnvironment);
        boolean bl2 = sDMSScheduledEvent.isReallyActive(systemEnvironment);
        int n = sDMSScheduledEvent.getBacklogHandling(systemEnvironment);
        TimerDate timerDate3 = null;
        Long l5 = sDMSScheduledEvent.getNextActivityTime(systemEnvironment);
        TimerDate timerDate4 = timerDate2 = l5 == null ? null : new TimerDate(new DateTime(l5).toDate());
        if (!bl2) {
            if (timerDate2 != null && timerDate2.gt(this.now)) {
                return;
            }
            timerDate = new TimerDate(this.now.plus(1));
            timerDate3 = sDMSSchedule.getNextTriggerDate(systemEnvironment, timerDate);
        } else {
            if (timerDate2 == null) {
                timerDate = n != 0 && bl ? new TimerDate(this.lastRun.plus(1)) : new TimerDate(this.now.plus(1));
            } else {
                if (timerDate2.gt(this.now)) {
                    return;
                }
                if (sDMSScheduledEvent.getNextActivityIsTrigger(systemEnvironment).booleanValue()) {
                    if (n == 0 && timerDate2.lt(this.now) && !this.aliveSinceLong) {
                        timerDate = new TimerDate(this.now);
                    } else {
                        timerDate = timerDate2;
                        timerDate3 = timerDate2;
                    }
                } else {
                    timerDate = n != 0 ? timerDate2 : this.now;
                }
            }
            if (timerDate3 == null) {
                timerDate3 = sDMSSchedule.getNextTriggerDate(systemEnvironment, timerDate);
            }
            if (bl) {
                TimerDate timerDate5 = null;
                while (!timerDate3.isNaD() && timerDate3.lt(this.now)) {
                    if (n == 2) {
                        this.submit_and_set(systemEnvironment, sDMSScheduledEvent, sDMSEvent, l4, timerDate3, this.suspendNow);
                    }
                    timerDate5 = timerDate3;
                    timerDate.set(timerDate3.plus(1));
                    timerDate3 = sDMSSchedule.getNextTriggerDate(systemEnvironment, timerDate);
                }
                if (n == 1 && timerDate5 != null) {
                    this.submit_and_set(systemEnvironment, sDMSScheduledEvent, sDMSEvent, l4, timerDate5, this.suspendNow);
                }
                if (n == 0 && this.aliveSinceLong && timerDate5 != null && !timerDate3.isNaD() && !timerDate3.eq(this.now)) {
                    this.submit_and_set(systemEnvironment, sDMSScheduledEvent, sDMSEvent, l4, timerDate5, this.suspendNow);
                }
                if (!timerDate3.isNaD() && timerDate3.eq(this.now)) {
                    this.submit_and_set(systemEnvironment, sDMSScheduledEvent, sDMSEvent, l4, timerDate3, this.suspendNow);
                    timerDate.set(timerDate3.plus(1));
                    timerDate3 = sDMSSchedule.getNextTriggerDate(systemEnvironment, timerDate);
                }
            }
        }
        if (timerDate3.isNaD()) {
            sDMSScheduledEvent.setNextActivityTime(systemEnvironment, TimerThread.dateToDateTimeLong(new TimerDate(timerDate.plus(SystemEnvironment.timerRecalc))));
            sDMSScheduledEvent.setNextActivityIsTrigger(systemEnvironment, Boolean.FALSE);
            sDMSScheduledEvent.clearCalendar(systemEnvironment);
        } else {
            sDMSScheduledEvent.setNextActivityTime(systemEnvironment, TimerThread.dateToDateTimeLong(timerDate3));
            sDMSScheduledEvent.setNextActivityIsTrigger(systemEnvironment, Boolean.TRUE);
            sDMSScheduledEvent.updateCalendar(systemEnvironment, new TimerDate(timerDate3.plus(-1)), sDMSSchedule);
        }
        long l6 = new Date().getTime();
        if (l6 - l > 1000L) {
            TimerThread.doTrace(this.cEnv, "doSchedule on scheduled event  " + sDMSScheduledEvent.getId(systemEnvironment).toString() + " took " + (l6 - l) + " milliseconds", 1);
        }
    }

    private final void submit_and_set(SystemEnvironment systemEnvironment, SDMSScheduledEvent sDMSScheduledEvent, SDMSEvent sDMSEvent, Long l, TimerDate timerDate, TimerDate timerDate2) throws SDMSException {
        boolean bl = true;
        try {
            SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, sDMSScheduledEvent.getSceId(systemEnvironment));
            this.doSubmit(systemEnvironment, sDMSEvent, l, timerDate, timerDate2, sDMSSchedule.getTimeZone(systemEnvironment));
        }
        catch (SerializationException serializationException) {
            bl = false;
            throw serializationException;
        }
        finally {
            if (bl) {
                sDMSScheduledEvent.setLastStartTime(systemEnvironment, this.nowLong);
            }
        }
    }

    private final void retire(SystemEnvironment systemEnvironment, SDMSScheduledEvent sDMSScheduledEvent, SDMSException sDMSException) throws SDMSException {
        String string = sDMSException.toString();
        TimerThread.doTrace(this.cEnv, "Retire scheduled event " + sDMSScheduledEvent.getId(systemEnvironment) + ": " + string, 0);
        sDMSScheduledEvent.setIsActive(systemEnvironment, Boolean.FALSE);
        sDMSScheduledEvent.setIsBroken(systemEnvironment, Boolean.TRUE);
        sDMSScheduledEvent.setErrorCode(systemEnvironment, sDMSException.errNumber());
        sDMSScheduledEvent.setErrorMsg(systemEnvironment, string);
        sDMSScheduledEvent.setNextActivityTime(systemEnvironment, null);
        sDMSScheduledEvent.setNextActivityIsTrigger(systemEnvironment, null);
        sDMSScheduledEvent.clearCalendar(systemEnvironment);
    }

    public final String getInfo() {
        return "TimeScheduling (" + this.current + "/" + this.total + ")";
    }

    private final void scheduleAll(SystemEnvironment systemEnvironment) throws SDMSException {
        this.current = 0;
        this.total = SDMSScheduledEventTable.table.rawSize();
        if (this.lastRun.lt(this.now)) {
            this.nowLong = TimerThread.dateToDateTimeLong(this.now);
            Iterator iterator = SDMSScheduledEventTable.table.iterator(systemEnvironment, false);
            while (iterator.hasNext()) {
                ++this.current;
                SDMSScheduledEvent sDMSScheduledEvent = (SDMSScheduledEvent)iterator.next();
                if (sDMSScheduledEvent.getIsBroken(systemEnvironment).booleanValue()) continue;
                this.suspendNow.set(this.now.plus(-1, sDMSScheduledEvent.getEffectiveSuspendLimit(systemEnvironment)));
                try {
                    systemEnvironment.tx.beginSubTransaction(systemEnvironment);
                    this.doSchedule(systemEnvironment, sDMSScheduledEvent);
                    systemEnvironment.tx.commitSubTransaction(systemEnvironment);
                }
                catch (SerializationException serializationException) {
                    systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
                    throw serializationException;
                }
                catch (SDMSException sDMSException) {
                    systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
                    this.createError(systemEnvironment, sDMSScheduledEvent, sDMSException.toString());
                    this.retire(systemEnvironment, sDMSScheduledEvent, sDMSException);
                }
                catch (Exception exception) {
                    systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
                    this.createError(systemEnvironment, sDMSScheduledEvent, exception.toString());
                    this.retire(systemEnvironment, sDMSScheduledEvent, new CommonErrorException(new SDMSMessage(systemEnvironment, "04311102118", this.toString(exception))));
                }
            }
            this.setLastRunToNow(systemEnvironment);
        }
    }

    private final void createError(SystemEnvironment systemEnvironment, SDMSScheduledEvent sDMSScheduledEvent, String string) throws SDMSException {
        Long l = sDMSScheduledEvent.getEvtId(systemEnvironment);
        SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, l);
        Long l2 = sDMSEvent.getSeId(systemEnvironment);
        Long l3 = sDMSScheduledEvent.getOwnerId(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l2);
        sDMSSchedulingEntity.createErrorMaster(systemEnvironment, l3, "Event " + sDMSEvent.getName(systemEnvironment), string);
    }

    final void initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        this.loadNow();
        this.loadLastRun(systemEnvironment);
    }

    public void schedule(SystemEnvironment systemEnvironment) throws SDMSException {
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this, 1);
        }
        this.loadNow();
        TimerThread.doTrace(this.cEnv, "-----------> Start Time Scheduling <------------", 2);
        this.scheduleAll(systemEnvironment);
        TimerThread.doTrace(this.cEnv, "-----------> End Time Scheduling   <------------", 2);
    }

    public void notifyChange(SystemEnvironment systemEnvironment, SDMSEvent sDMSEvent, int n) throws SDMSException {
        if (n != 2) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "04207262214", "Unexpected action code $1 for Event $2", (Object)new Integer(n), (Object)sDMSEvent.getId(systemEnvironment)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyChange(SystemEnvironment systemEnvironment, SDMSInterval sDMSInterval, int n) throws SDMSException {
        if (n != 2) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "04207262215", "Unexpected action code $1 for Interval $2", (Object)new Integer(n), (Object)sDMSInterval.getId(systemEnvironment)));
        }
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this, 1);
        }
        try {
            this.collectIvals(systemEnvironment, sDMSInterval.getId(systemEnvironment));
            for (Long l : this.ivalIds) {
                Vector vector = SDMSScheduleTable.idx_intId.getVector(systemEnvironment, l);
                int n2 = vector.size();
                for (int i = 0; i < n2; ++i) {
                    SDMSSchedule sDMSSchedule = (SDMSSchedule)vector.get(i);
                    this.notifyChange(systemEnvironment, sDMSSchedule, 2);
                }
            }
        }
        finally {
            this.ivalIds.clear();
        }
    }

    private final void collectIvals(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.ivalIds.add(l);
        Vector vector = SDMSIntervalTable.idx_embeddedIntervalId.getVector(systemEnvironment, l);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSInterval sDMSInterval = (SDMSInterval)vector.get(i);
            Long l2 = sDMSInterval.getId(systemEnvironment);
            if (this.ivalIds.contains(l2)) continue;
            this.collectIvals(systemEnvironment, l2);
        }
        Vector vector2 = SDMSIntervalHierarchyTable.idx_childId.getVector(systemEnvironment, l);
        int n2 = vector2.size();
        for (int i = 0; i < n2; ++i) {
            SDMSIntervalHierarchy sDMSIntervalHierarchy = (SDMSIntervalHierarchy)vector2.get(i);
            Long l3 = sDMSIntervalHierarchy.getParentId(systemEnvironment);
            if (this.ivalIds.contains(l3)) continue;
            this.collectIvals(systemEnvironment, l3);
        }
        Vector vector3 = SDMSIntervalDispatcherTable.idx_selectIntId.getVector(systemEnvironment, l);
        int n3 = vector3.size();
        for (int i = 0; i < n3; ++i) {
            SDMSIntervalDispatcher sDMSIntervalDispatcher = (SDMSIntervalDispatcher)vector3.get(i);
            Long l4 = sDMSIntervalDispatcher.getIntId(systemEnvironment);
            if (this.ivalIds.contains(l4)) continue;
            this.collectIvals(systemEnvironment, l4);
        }
        Vector vector4 = SDMSIntervalDispatcherTable.idx_filterIntId.getVector(systemEnvironment, l);
        int n4 = vector4.size();
        for (int i = 0; i < n4; ++i) {
            SDMSIntervalDispatcher sDMSIntervalDispatcher = (SDMSIntervalDispatcher)vector4.get(i);
            Long l5 = sDMSIntervalDispatcher.getIntId(systemEnvironment);
            if (this.ivalIds.contains(l5)) continue;
            this.collectIvals(systemEnvironment, l5);
        }
    }

    public final void notifyChange(SystemEnvironment systemEnvironment, SDMSSchedule sDMSSchedule, int n) throws SDMSException {
        Long l = sDMSSchedule.getId(systemEnvironment);
        if (n != 2) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "04207262216", "Unexpected action code $1 for Schedule $2", (Object)new Integer(n), (Object)l));
        }
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this, 1);
        }
        Vector vector = SDMSScheduledEventTable.idx_sceId.getVector(systemEnvironment, l);
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            SDMSScheduledEvent sDMSScheduledEvent = (SDMSScheduledEvent)vector.get(i);
            this.notifyChange(systemEnvironment, sDMSScheduledEvent, 2);
        }
    }

    public final void notifyChange(SystemEnvironment systemEnvironment, SDMSScheduledEvent sDMSScheduledEvent, int n) throws SDMSException {
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this, 1);
        }
        switch (n) {
            case 1: {
                if (sDMSScheduledEvent.getIsBroken(systemEnvironment).booleanValue()) break;
                try {
                    this.loadNow();
                    this.doSchedule(systemEnvironment, sDMSScheduledEvent, false);
                    break;
                }
                catch (SDMSException sDMSException) {
                    throw sDMSException;
                }
                catch (Exception exception) {
                    SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, "02205080754", "Unexpected Exception ($1)", (Object)this.toString(exception));
                    SDMSThread.doTrace(systemEnvironment.cEnv, sDMSMessage.toString(), -1);
                    throw new CommonErrorException(sDMSMessage);
                }
            }
            case 2: {
                sDMSScheduledEvent.setNextActivityTime(systemEnvironment, null);
                sDMSScheduledEvent.setNextActivityIsTrigger(systemEnvironment, null);
                sDMSScheduledEvent.clearCalendar(systemEnvironment);
                if (sDMSScheduledEvent.getIsBroken(systemEnvironment).booleanValue()) break;
                try {
                    this.loadNow();
                    this.doSchedule(systemEnvironment, sDMSScheduledEvent, false);
                    break;
                }
                catch (SDMSException sDMSException) {
                    throw sDMSException;
                }
                catch (Exception exception) {
                    SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, "02205080755", "Unexpected Exception ($1)", (Object)this.toString(exception));
                    SDMSThread.doTrace(systemEnvironment.cEnv, sDMSMessage.toString(), -1);
                    throw new CommonErrorException(sDMSMessage);
                }
            }
            case 3: {
                break;
            }
            default: {
                throw new FatalException(new SDMSMessage(systemEnvironment, "04207262159", "Unexpected action code $1 for Scheduled Event $2", (Object)new Integer(n), (Object)sDMSScheduledEvent.getId(systemEnvironment)));
            }
        }
    }
}

