/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.DumpExitStateDefinition;
import de.independit.scheduler.server.dump.DumpExitStateMappingProfileGeneric;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSExitStateMapping;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSExitStateMappingTable;
import java.util.Collections;
import java.util.Vector;

class DumpExitStateMappingProfile
extends DumpExitStateMappingProfileGeneric {
    public static final String __version = "@(#) $Id: DumpExitStateMappingProfile.java,v 2.3.14.1 2013/03/14 10:24:11 ronald Exp $";
    private Vector mappingDefs;

    DumpExitStateMappingProfile(SystemEnvironment systemEnvironment, SDMSExitStateMappingProfile sDMSExitStateMappingProfile) throws SDMSException {
        super(systemEnvironment, sDMSExitStateMappingProfile);
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSExitStateMappingTable.idx_esmpId.getVector(systemEnvironment, this.esmpId);
        int n = vector.size();
        this.mappingDefs = new Vector(n);
        for (int i = 0; i < n; ++i) {
            SDMSExitStateMapping sDMSExitStateMapping = (SDMSExitStateMapping)vector.get(i);
            Long l = sDMSExitStateMapping.getEsdId(systemEnvironment);
            String string = DumpExitStateDefinition.getDumpedName(systemEnvironment, l);
            Integer n2 = sDMSExitStateMapping.getEcrStart(systemEnvironment);
            if (n2 == Integer.MIN_VALUE) {
                this.mappingDefs.add(string);
                continue;
            }
            this.mappingDefs.add(n2.toString() + ", " + string);
        }
        Collections.sort(this.mappingDefs, Compare.ExitStateMappings);
    }

    @Override
    final void render(String string) {
        DumpExitStateMappingProfile.println(string + " exit_state_mapping " + this.getName());
        DumpExitStateMappingProfile.println("\twith");
        DumpExitStateMappingProfile.println("\t\tmap = (");
        DumpExitStateMappingProfile.println("\t\t\t" + DumpExitStateMappingProfile.join(",\n\t\t\t", this.mappingDefs) + ");");
    }
}

