/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.DumpExitStateDefinition;
import de.independit.scheduler.server.dump.DumpExitStateMappingProfile;
import de.independit.scheduler.server.dump.DumpExitStateProfileGeneric;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import java.util.Collections;
import java.util.Vector;

class DumpExitStateProfile
extends DumpExitStateProfileGeneric {
    public static final String __version = "@(#) $Id: DumpExitStateProfile.java,v 2.5.14.1 2013/03/14 10:24:12 ronald Exp $";
    private Vector stateDefs;
    private String defaultMapping;

    DumpExitStateProfile(SystemEnvironment systemEnvironment, SDMSExitStateProfile sDMSExitStateProfile) throws SDMSException {
        super(systemEnvironment, sDMSExitStateProfile);
    }

    private final String getEsType(SystemEnvironment systemEnvironment, SDMSExitState sDMSExitState) throws SDMSException {
        if (sDMSExitState.getIsFinal(systemEnvironment).booleanValue()) {
            return "final";
        }
        if (sDMSExitState.getIsRestartable(systemEnvironment).booleanValue()) {
            return "restartable";
        }
        return "pending";
    }

    private final String getIsUnreachable(SystemEnvironment systemEnvironment, SDMSExitState sDMSExitState) throws SDMSException {
        return sDMSExitState.getIsUnreachable(systemEnvironment) != false ? "unreachable" : null;
    }

    private final String getIsBroken(SystemEnvironment systemEnvironment, SDMSExitState sDMSExitState) throws SDMSException {
        return sDMSExitState.getIsBroken(systemEnvironment) != false ? "broken" : null;
    }

    private final void loadStates(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, this.espId);
        Collections.sort(vector, new Compare.ExitStates(systemEnvironment));
        int n = vector.size();
        this.stateDefs = new Vector(n);
        for (int i = 0; i < n; ++i) {
            SDMSExitState sDMSExitState = (SDMSExitState)vector.get(i);
            Long l = sDMSExitState.getEsdId(systemEnvironment);
            String string = DumpExitStateDefinition.getDumpedName(systemEnvironment, l);
            String string2 = this.getEsType(systemEnvironment, sDMSExitState);
            String string3 = this.getIsUnreachable(systemEnvironment, sDMSExitState);
            String string4 = this.getIsBroken(systemEnvironment, sDMSExitState);
            String string5 = string + ' ' + string2;
            if (string3 != null) {
                string5 = string5 + ' ' + string3;
            }
            if (string4 != null) {
                string5 = string5 + ' ' + string4;
            }
            this.stateDefs.add(string5);
        }
    }

    private final void loadDefaultMapping(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.esp.getDefaultEsmpId(systemEnvironment);
        this.defaultMapping = l == null ? "none" : DumpExitStateMappingProfile.getDumpedName(systemEnvironment, l);
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        this.loadStates(systemEnvironment);
        this.loadDefaultMapping(systemEnvironment);
    }

    @Override
    final void render(String string) {
        DumpExitStateProfile.println(string + " exit_state_profile " + this.getName());
        DumpExitStateProfile.println("\twith");
        DumpExitStateProfile.println("\t\tstates = (");
        DumpExitStateProfile.println("\t\t\t" + DumpExitStateProfile.join(",\n\t\t\t", this.stateDefs) + "),");
        DumpExitStateProfile.println("\t\tdefault_mapping = " + this.defaultMapping + ';');
    }
}

