/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.DumpGrant;
import de.independit.scheduler.server.dump.DumpGroup;
import de.independit.scheduler.server.dump.DumpIntervalGeneric;
import de.independit.scheduler.server.dump.DumpIntervalStructure;
import de.independit.scheduler.server.dump.DumpSchedulingEntity;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalSelection;
import de.independit.scheduler.server.repository.SDMSIntervalSelectionTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.util.DateTime;
import java.util.Collections;
import java.util.Vector;

public class DumpInterval
extends DumpIntervalGeneric {
    public static final String __version = "@(#) $Id: DumpInterval.java,v 2.4.2.1 2013/03/14 10:24:12 ronald Exp $";
    String jobDefinition;
    private Vector withList;

    public static final DumpInterval loadDump(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSInterval sDMSInterval = SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)string), null));
        DumpInterval dumpInterval = (DumpInterval)DumpInterval.getRef(systemEnvironment, 20, sDMSInterval);
        if (dumpInterval != null) {
            return dumpInterval;
        }
        return new DumpInterval(systemEnvironment, sDMSInterval);
    }

    DumpInterval(SystemEnvironment systemEnvironment, SDMSInterval sDMSInterval) throws SDMSException {
        super(systemEnvironment, sDMSInterval);
    }

    private final void loadJobDefinition(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.i.getSeId(systemEnvironment);
        if (l != null) {
            this.jobDefinition = DumpSchedulingEntity.getDumpedName(systemEnvironment, l);
            this.comments.setJobDefinition(this.jobDefinition);
        }
    }

    private final void loadBaseInterval(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.i.getBaseIntervalAsString(systemEnvironment);
        if (string != null) {
            Integer n = this.i.getBaseIntervalMultiplier(systemEnvironment);
            this.withList.add("base = " + DumpInterval.intervalText(n, string));
        }
    }

    private final void loadDuration(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.i.getDurationAsString(systemEnvironment);
        if (string != null) {
            Integer n = this.i.getDurationMultiplier(systemEnvironment);
            this.withList.add("duration = " + DumpInterval.intervalText(n, string));
        }
    }

    private final void loadSyncTime(SystemEnvironment systemEnvironment) throws SDMSException {
        DateTime dateTime = new DateTime(this.i.getSyncTime(systemEnvironment), false);
        this.withList.add("synctime = " + DumpInterval.quotedString(dateTime.toString()));
    }

    private final void loadStartTime(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.i.getStartTime(systemEnvironment);
        if (l != null) {
            DateTime dateTime = new DateTime(l, false);
            this.withList.add("starttime = " + DumpInterval.quotedString(dateTime.toString()));
        }
    }

    private final void loadEndTime(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.i.getEndTime(systemEnvironment);
        if (l != null) {
            DateTime dateTime = new DateTime(l, false);
            this.withList.add("endtime = " + DumpInterval.quotedString(dateTime.toString()));
        }
    }

    private final void loadSelection(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSIntervalSelectionTable.idx_intId.getVector(systemEnvironment, this.iId);
        if (vector == null) {
            this.withList.add("selection = none");
        } else {
            int n = vector.size();
            Vector<String> vector2 = new Vector<String>(n);
            for (int i = 0; i < n; ++i) {
                SDMSIntervalSelection sDMSIntervalSelection = (SDMSIntervalSelection)vector.get(i);
                Integer n2 = sDMSIntervalSelection.getValue(systemEnvironment);
                if (n2 != null) {
                    vector2.add(n2.toString());
                    continue;
                }
                Long l = sDMSIntervalSelection.getPeriodFrom(systemEnvironment);
                DateTime dateTime = new DateTime(l, false);
                Long l2 = sDMSIntervalSelection.getPeriodTo(systemEnvironment);
                if (l2 == null) {
                    vector2.add(DumpInterval.quotedString(dateTime.toString()));
                    continue;
                }
                DateTime dateTime2 = new DateTime(l2, false);
                vector2.add(DumpInterval.quotedString(dateTime.toString()) + " - " + DumpInterval.quotedString(dateTime2.toString()));
            }
            Collections.sort(vector2, Compare.IntervalSelection);
            this.withList.add("selection = " + DumpInterval.renderList(vector2));
        }
    }

    private final void loadDelay(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.i.getDelay(systemEnvironment);
        if (l != null) {
            DateTime dateTime = new DateTime(l, false);
            this.withList.add("delay = " + DumpInterval.quotedString(dateTime.toString()));
        } else {
            this.withList.add("delay = none");
        }
    }

    private final void loadInverse(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.i.getIsInverse(systemEnvironment);
        if (bl.booleanValue()) {
            this.withList.add("inverse");
        }
    }

    private final void loadMerge(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.i.getIsMerge(systemEnvironment);
        if (bl.booleanValue()) {
            this.withList.add("merge");
        } else {
            this.withList.add("nomerge");
        }
    }

    private final void loadStructure(SystemEnvironment systemEnvironment) throws SDMSException {
        this.withList.addAll(DumpIntervalStructure.getDumpedList(systemEnvironment, this.iId, this));
    }

    private final void loadGroup(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.i.getOwnerId(systemEnvironment);
        this.withList.add("group = " + DumpGroup.getDumpedName(systemEnvironment, l));
        DumpGrant.getDumpedList(systemEnvironment, this.iId);
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        this.loadJobDefinition(systemEnvironment);
        this.withList = new Vector();
        this.loadBaseInterval(systemEnvironment);
        this.loadDuration(systemEnvironment);
        this.loadSyncTime(systemEnvironment);
        this.loadStartTime(systemEnvironment);
        this.loadEndTime(systemEnvironment);
        this.loadSelection(systemEnvironment);
        this.loadDelay(systemEnvironment);
        this.loadInverse(systemEnvironment);
        this.loadMerge(systemEnvironment);
        this.loadStructure(systemEnvironment);
        this.loadGroup(systemEnvironment);
    }

    @Override
    final void render(String string) {
        DumpInterval.print(string + " interval " + this.getName());
        if (this.jobDefinition != null) {
            DumpInterval.print("\n\t\t(" + this.jobDefinition + ')');
        }
        if (!this.withList.isEmpty()) {
            DumpInterval.println("\n\twith");
            DumpInterval.print("\t\t" + DumpInterval.join(",\n\t\t", this.withList));
        }
        DumpInterval.println(';');
    }
}

