/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.output;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.output.SDMSOutputError;
import de.independit.scheduler.server.output.SDMSOutputLabel;
import de.independit.scheduler.server.output.SDMSOutputRenderer;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;

public class SDMSXmlRenderer
extends SDMSOutputRenderer {
    public static final String __version = "@(#) $Id: SDMSXmlRenderer.java,v 2.1.20.1 2013/03/14 10:24:19 ronald Exp $";

    @Override
    public void render(SystemEnvironment systemEnvironment, SDMSOutput sDMSOutput) throws FatalException {
        this.render(systemEnvironment.cEnv.ostream(), sDMSOutput);
    }

    @Override
    public void render(PrintStream printStream, SDMSOutput sDMSOutput) throws FatalException {
        this.writeln(printStream, "<OUTPUT>");
        if (sDMSOutput.container != null) {
            this.writeln(printStream, "<DATA>");
            this.renderContainer(printStream, sDMSOutput.container);
            this.writeln(printStream, "</DATA>");
        }
        if (sDMSOutput.feedback != null) {
            this.renderFeedback(printStream, sDMSOutput.feedback);
        }
        if (sDMSOutput.error != null) {
            this.renderError(printStream, sDMSOutput.error);
        }
        this.writeln(printStream, "</OUTPUT>");
        this.renderPrompt(printStream);
    }

    private void renderContainer(PrintStream printStream, SDMSOutputContainer sDMSOutputContainer) {
        if (sDMSOutputContainer.title != null) {
            this.writeln(printStream, "<TITLE>" + sDMSOutputContainer.title.toString() + "</TITLE>");
        }
        if (sDMSOutputContainer.columns == 0) {
            this.renderRecord(printStream, sDMSOutputContainer);
        } else {
            this.renderTable(printStream, sDMSOutputContainer);
        }
    }

    private void renderRecord(PrintStream printStream, SDMSOutputContainer sDMSOutputContainer) {
        int n = sDMSOutputContainer.desc.size();
        Vector vector = (Vector)sDMSOutputContainer.dataset.elementAt(0);
        this.writeln(printStream, "<RECORD>");
        for (int i = 0; i < n; ++i) {
            String string = ((SDMSOutputLabel)sDMSOutputContainer.desc.elementAt((int)i)).name.toUpperCase();
            if (vector.elementAt(i) == null) {
                this.write(printStream, "<" + string + " null=true>");
            } else {
                this.write(printStream, "<" + string + ">");
                if (!(vector.elementAt(i) instanceof SDMSOutputContainer)) {
                    this.write(printStream, vector.elementAt(i).toString());
                } else {
                    this.writeln(printStream, "");
                    this.renderTable(printStream, (SDMSOutputContainer)vector.elementAt(i));
                }
            }
            this.write(printStream, "</" + string + ">");
        }
        this.writeln(printStream, "</RECORD>");
    }

    private void renderTable(PrintStream printStream, SDMSOutputContainer sDMSOutputContainer) {
        int n = sDMSOutputContainer.desc.size();
        this.writeln(printStream, "<TABLE>");
        Iterator iterator = sDMSOutputContainer.dataset.iterator();
        while (iterator.hasNext()) {
            this.writeln(printStream, "<RECORD>");
            Vector vector = (Vector)iterator.next();
            for (int i = 0; i < n; ++i) {
                String string = ((SDMSOutputLabel)sDMSOutputContainer.desc.elementAt((int)i)).name.toUpperCase();
                this.write(printStream, "<" + string);
                if (vector.elementAt(i) == null) {
                    this.write(printStream, " null=true");
                }
                this.write(printStream, ">");
                if (vector.elementAt(i) != null) {
                    this.write(printStream, vector.elementAt(i).toString());
                }
                this.writeln(printStream, "</" + string + ">");
            }
            this.writeln(printStream, "</RECORD>");
        }
        this.writeln(printStream, "</TABLE>");
    }

    private void renderFeedback(PrintStream printStream, Object object) {
        this.writeln(printStream, "<FEEDBACK>" + object.toString() + "</FEEDBACK>");
    }

    private void renderError(PrintStream printStream, SDMSOutputError sDMSOutputError) {
        this.writeln(printStream, "<ERROR>");
        this.writeln(printStream, "<ERRORCODE>" + sDMSOutputError.code + "</ERRORCODE>");
        this.writeln(printStream, "<ERRORMESSAGE>" + sDMSOutputError.message + "</ERRORMESSAGE>");
        this.writeln(printStream, "</ERROR>");
    }

    private void renderPrompt(PrintStream printStream) {
    }
}

