/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ManipGroup;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMember;
import de.independit.scheduler.server.repository.SDMSMemberProxyGeneric;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Vector;

public class AlterGroup
extends ManipGroup {
    public static final String __version = "@(#) $Id: AlterGroup.java,v 2.2.6.1 2013/03/14 10:24:20 ronald Exp $";
    private boolean noerr;

    public AlterGroup(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        super(objectURL, withHash);
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l;
        int n;
        Object object;
        SDMSGroup sDMSGroup;
        Long l2 = systemEnvironment.cEnv.uid();
        this.evaluate_with(systemEnvironment);
        try {
            sDMSGroup = (SDMSGroup)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03312130027", "No group altered"));
                return;
            }
            throw notFoundException;
        }
        Long l3 = sDMSGroup.getId(systemEnvironment);
        if (sDMSGroup.getName(systemEnvironment).equals("PUBLIC")) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03401271652", "you cannot remove a user from public"));
        }
        if (this.with.containsKey("USERLIST")) {
            Comparable comparable;
            object = SDMSMemberTable.idx_gId.getVector(systemEnvironment, l3);
            if (!systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId) && !this.userlist.contains(l2)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03104151448", "You cannot remove yourself from a group"));
            }
            for (n = 0; n < ((Vector)object).size(); ++n) {
                comparable = (SDMSMember)((Vector)object).get(n);
                l = ((SDMSMemberProxyGeneric)comparable).getUId(systemEnvironment);
                SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, l);
                if (l3.equals(sDMSUser.getDefaultGId(systemEnvironment)) && !this.userlist.contains(sDMSUser.getId(systemEnvironment))) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03312130039", "you cannot remove a user from his default group"));
                }
                if (this.userlist.contains(l)) {
                    this.userlist.remove(l);
                    continue;
                }
                ((SDMSMemberProxyGeneric)comparable).delete(systemEnvironment);
            }
            for (n = 0; n < this.userlist.size(); ++n) {
                comparable = (Long)this.userlist.get(n);
                SDMSMemberTable.table.create(systemEnvironment, l3, (Long)comparable);
            }
        }
        if (this.with.containsKey("ADDUSER")) {
            for (n = 0; n < this.addlist.size(); ++n) {
                object = (Long)this.addlist.get(n);
                try {
                    SDMSMemberTable.table.create(systemEnvironment, l3, (Long)object);
                    continue;
                }
                catch (DuplicateKeyException duplicateKeyException) {
                    // empty catch block
                }
            }
        }
        if (this.with.containsKey("DELUSER")) {
            if (!systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId) && this.dellist.contains(l2)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03104151447", "You cannot remove yourself from a group"));
            }
            for (int i = 0; i < this.dellist.size(); ++i) {
                Long l4 = (Long)this.dellist.get(i);
                l = SDMSUserTable.getObject(systemEnvironment, l4).getDefaultGId(systemEnvironment);
                if (!l3.equals(l)) {
                    try {
                        object = SDMSMemberTable.idx_gId_uId_getUnique(systemEnvironment, new SDMSKey(l3, l4));
                        ((SDMSMemberProxyGeneric)object).delete(systemEnvironment);
                    }
                    catch (NotFoundException notFoundException) {}
                    continue;
                }
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03312102202", "You cannot remove the default group"));
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03312091431", "Group altered"));
    }
}

