/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.SubmitJob;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSAuditTrail;
import de.independit.scheduler.server.repository.SDMSAuditTrailProxyGeneric;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSDependencyInstance;
import de.independit.scheduler.server.repository.SDMSDependencyInstanceTable;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSKillJob;
import de.independit.scheduler.server.repository.SDMSKillJobTable;
import de.independit.scheduler.server.repository.SDMSNamedResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceAllocation;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSRunnableQueue;
import de.independit.scheduler.server.repository.SDMSRunnableQueueTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class AlterJob
extends Node {
    public static final String __version = "@(#) $Id: AlterJob.java,v 2.35.2.4 2013/07/19 06:45:20 dieter Exp $";
    public static final int LOCALSUSPEND = 100;
    public static final int LOCALADMINSUSPEND = 200;
    private Long jobId = null;
    private WithHash with = null;
    private Boolean clone = null;
    private String execPid = null;
    private String extPid = null;
    private Integer status = null;
    private String exitState = null;
    private Boolean exitStateForce = null;
    private String ts = null;
    private Integer exitCode = null;
    private String errText = null;
    private Boolean suspend = null;
    private Boolean adminSuspend = null;
    private Boolean localSuspend = null;
    private Object resumeObj = null;
    private String runProgram = null;
    private String rerunProgram = null;
    private Boolean rerun = null;
    private Integer rerunSeq = null;
    private Boolean kill = null;
    private Boolean cancel = null;
    private Boolean disable = null;
    private Long tsLong = null;
    private Vector depsToIgnore = null;
    private Integer priority = null;
    private Integer nicevalue = null;
    private Integer renice = null;
    private String comment = null;
    private Vector resToIgnore = null;
    private Vector nrsToIgnore = null;
    private Boolean clearWarning = null;
    private String warning = null;
    private static final int EP = 1;
    private static final int EX = 2;
    private static final int ST = 4;
    private static final int TS = 8;
    private static final int EC = 16;
    private static final int RP = 32;
    private static final int RR = 64;
    private static final int SU = 128;
    private static final int RE = 256;
    private static final int ID = 512;
    private static final int ES = 1024;
    private static final int KI = 2048;
    private static final int CN = 4096;
    private static final int RC = 8192;
    private static final int ET = 16384;
    private static final int PR = 32768;
    private static final int NV = 65536;
    private static final int RN = 131072;
    private static final int IR = 262144;
    private static final int IN = 262144;
    private static final int RU = 524288;
    private static final int CW = 0x100000;
    private static final int SW = 0x200000;
    private static final int RS = 0x400000;
    private static final int DA = 0x800000;
    private static final int CL = 0x1000000;
    private static final int JS_ACTION = 540703;
    private static final int OP_ACTION = 16106464;
    private static final int ES_ACTION = 541696;
    private static final int KI_ACTION = 18432;
    private static final int CN_ACTION = 20480;
    private static final int DA_ACTION = 0x804000;
    private static final int RC_ACTION = 24576;
    private static final int CL_ACTION = 0x1004000;

    public AlterJob(Long l, WithHash withHash) {
        this.cmdtype |= 2;
        this.jobId = l;
        this.with = withHash;
    }

    public AlterJob(WithHash withHash) {
        this.cmdtype = 4;
        this.jobId = null;
        this.with = withHash;
    }

    private boolean checkConsistency(SystemEnvironment systemEnvironment) throws SDMSException {
        int n = 0;
        if (this.clone != null) {
            n += 0x1000000;
        }
        if (this.execPid != null) {
            ++n;
        }
        if (this.extPid != null) {
            n += 2;
        }
        if (this.status != null) {
            n += 4;
        }
        if (this.ts != null) {
            n += 8;
        }
        if (this.exitCode != null) {
            n += 16;
        }
        if (this.runProgram != null) {
            n += 32;
        }
        if (this.rerunProgram != null) {
            n += 64;
        }
        if (this.suspend != null) {
            n += 128;
        }
        if (this.resumeObj != null) {
            n += 0x400000;
        }
        if (this.rerunSeq != null) {
            n += 524288;
        }
        if (this.rerun != null) {
            n = this.rerun.booleanValue() ? (n += 8192) : (n += 256);
        }
        if (this.depsToIgnore != null) {
            n += 512;
        }
        if (this.exitState != null) {
            n += 1024;
        }
        if (this.kill != null) {
            n += 2048;
        }
        if (this.cancel != null) {
            n += 4096;
        }
        if (this.disable != null) {
            n += 0x800000;
        }
        if (this.priority != null) {
            n += 32768;
        }
        if (this.nicevalue != null) {
            n += 65536;
        }
        if (this.renice != null) {
            n += 131072;
        }
        if (this.resToIgnore != null) {
            n += 262144;
        }
        if (this.nrsToIgnore != null) {
            n += 262144;
        }
        if (this.errText != null) {
            n += 16384;
        }
        if (this.clearWarning != null) {
            n += 0x100000;
        }
        if (this.warning != null) {
            n += 0x200000;
        }
        if ((n & 0xFFF7BFE0) == 0 || (n & 0xFF0A3C1F) == 0 || (n & 0xFFF7BBFF) == 0 || (n & 0xFFFFB7FF) == 0 || (n & 0xFF7FBFFF) == 0 || (n & 0xFEFFBFFF) == 0 || (n & 0xFFFFAFFF) == 0 || (n & 0xFFFF9FFF) == 0) {
            if (this.nicevalue != null && this.renice != null) {
                return false;
            }
            return this.clearWarning == null || this.warning == null;
        }
        return false;
    }

    private void collectWith(SystemEnvironment systemEnvironment) throws SDMSException {
        ParsePosition parsePosition;
        this.clone = (Boolean)this.with.get("CLONE");
        this.execPid = (String)this.with.get("EXEC_PID");
        this.extPid = (String)this.with.get("EXT_PID");
        this.status = (Integer)this.with.get("STATUS");
        Vector vector = (Vector)this.with.get("EXIT_STATUS");
        if (vector != null) {
            this.exitState = (String)vector.get(0);
            this.exitStateForce = (Boolean)vector.get(1);
        }
        this.ts = (String)this.with.get("TIMESTAMP");
        if (this.ts != null) {
            parsePosition = new ParsePosition(0);
            Date date = systemEnvironment.jsCommDateFormat.parse(this.ts, parsePosition);
            if (parsePosition.getErrorIndex() != -1) {
                parsePosition = new ParsePosition(0);
                date = systemEnvironment.oldJsCommDateFormat.parse(this.ts, parsePosition);
                if (parsePosition.getErrorIndex() != -1) {
                    parsePosition = new ParsePosition(0);
                    date = systemEnvironment.systemDateFormat.parse(this.ts, parsePosition);
                    if (parsePosition.getErrorIndex() != -1) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03205061602", "Error in date format: $1\nPosition: $2", (Object)this.ts, (Object)parsePosition.toString()));
                    }
                }
            }
            GregorianCalendar gregorianCalendar = SystemEnvironment.newGregorianCalendar();
            gregorianCalendar.setTime(date);
            this.tsLong = new Long(gregorianCalendar.getTimeInMillis());
        }
        this.exitCode = (Integer)this.with.get("EXIT_CODE");
        this.errText = (String)this.with.get("ERROR_TEXT");
        this.runProgram = (String)this.with.get("RUN_PROGRAM");
        this.rerunProgram = (String)this.with.get("RERUN_PROGRAM");
        parsePosition = this.with.get("SUSPEND");
        if (parsePosition != null) {
            this.adminSuspend = Boolean.FALSE;
            this.localSuspend = Boolean.FALSE;
            if (parsePosition instanceof Boolean) {
                this.suspend = (Boolean)((Object)parsePosition);
            } else {
                this.suspend = Boolean.TRUE;
                int n = (Integer)((Object)parsePosition);
                if (n == 200) {
                    this.adminSuspend = Boolean.TRUE;
                    this.localSuspend = Boolean.TRUE;
                } else if (n == 100) {
                    this.localSuspend = Boolean.TRUE;
                } else {
                    this.adminSuspend = Boolean.TRUE;
                }
            }
        }
        this.resumeObj = this.with.get("RESUME");
        if (this.suspend == null && this.resumeObj != null && this.resumeObj instanceof Boolean) {
            this.suspend = (Boolean)this.resumeObj;
            this.resumeObj = null;
        }
        if (this.suspend != null && systemEnvironment.cEnv.isUser()) {
            if (systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
                if (!this.suspend.booleanValue()) {
                    this.adminSuspend = Boolean.TRUE;
                }
            } else if (this.adminSuspend != null && this.adminSuspend.booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03408071555", "Insufficient privileges for admin suspend"));
            }
            if (this.adminSuspend == null) {
                this.adminSuspend = Boolean.FALSE;
            }
        }
        this.rerun = (Boolean)this.with.get("RERUN");
        this.rerunSeq = (Integer)this.with.get("RUN");
        this.kill = (Boolean)this.with.get("KILL");
        this.cancel = (Boolean)this.with.get("CANCEL");
        this.disable = (Boolean)this.with.get("DISABLE");
        this.depsToIgnore = (Vector)this.with.get("IGNORE_DEPENDENCY");
        this.priority = (Integer)this.with.get("PRIORITY");
        this.nicevalue = (Integer)this.with.get("NICEVALUE");
        this.renice = (Integer)this.with.get("RENICE");
        this.resToIgnore = (Vector)this.with.get("IGNORE_RESOURCE");
        this.nrsToIgnore = (Vector)this.with.get("IGNORE_NAMED_RESOURCE");
        this.clearWarning = (Boolean)this.with.get("CLEAR_WARN");
        this.warning = (String)this.with.get("WARNING");
        if (!this.checkConsistency(systemEnvironment)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207091715", "Illegal combination of With Options"));
        }
        this.comment = (String)this.with.get("COMMENT");
    }

    private void setSomeFields(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Integer n) throws SDMSException {
        sDMSSubmittedEntity.setState(systemEnvironment, n);
        if (this.with.containsKey("ERROR_TEXT")) {
            sDMSSubmittedEntity.setErrorMsg(systemEnvironment, this.errText);
        }
        if (this.with.containsKey("EXEC_PID")) {
            sDMSSubmittedEntity.setPid(systemEnvironment, this.execPid);
        }
        if (this.with.containsKey("EXT_PID")) {
            sDMSSubmittedEntity.setExtPid(systemEnvironment, this.extPid);
        }
    }

    private void changeState(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, boolean bl) throws SDMSException {
        switch (this.status) {
            case 6: {
                this.setSomeFields(systemEnvironment, sDMSSubmittedEntity, this.status);
                if (this.tsLong != null) {
                    sDMSSubmittedEntity.setStartTs(systemEnvironment, this.tsLong);
                }
                this.delFromQueue(systemEnvironment, sDMSSubmittedEntity);
                break;
            }
            case 7: {
                int n = sDMSSubmittedEntity.getState(systemEnvironment);
                this.setSomeFields(systemEnvironment, sDMSSubmittedEntity, this.status);
                if (n != 6 && this.tsLong != null) {
                    sDMSSubmittedEntity.setStartTs(systemEnvironment, this.tsLong);
                }
                this.delFromQueue(systemEnvironment, sDMSSubmittedEntity);
                break;
            }
            case 11: {
                if (this.exitCode == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03212102041", "you cannot finish a job without an exit code"));
                }
                sDMSSubmittedEntity.finishJob(systemEnvironment, this.exitCode, this.errText, this.tsLong);
                int n = sDMSSubmittedEntity.getState(systemEnvironment);
                if (n != 11 && n != 12) break;
                this.delFromQueue(systemEnvironment, sDMSSubmittedEntity);
                break;
            }
            case 13: {
                this.setSomeFields(systemEnvironment, sDMSSubmittedEntity, this.status);
                break;
            }
            case 14: {
                sDMSSubmittedEntity.releaseResources(systemEnvironment, this.status);
                this.setSomeFields(systemEnvironment, sDMSSubmittedEntity, this.status);
                break;
            }
            case 15: {
                sDMSSubmittedEntity.releaseResources(systemEnvironment, this.status);
                sDMSSubmittedEntity.setToError(systemEnvironment, this.errText);
                break;
            }
            default: {
                if (!bl) break;
                sDMSSubmittedEntity.setState(systemEnvironment, this.status);
            }
        }
    }

    private void setExitState(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, long l) throws SDMSException {
        String string;
        SDMSExitState sDMSExitState;
        Long l2;
        boolean bl;
        Long l3 = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, this.exitState, l).getId(systemEnvironment);
        Long l4 = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l).getEspId(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l);
        int n = sDMSSubmittedEntity.getState(systemEnvironment);
        if (sDMSSchedulingEntity.getType(systemEnvironment) != 1) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03403091701", "You can only change the exit state of a job, $1 is a $2", (Object)sDMSSchedulingEntity.pathString(systemEnvironment), (Object)sDMSSchedulingEntity.getTypeAsString(systemEnvironment)));
        }
        boolean bl2 = bl = sDMSSubmittedEntity.getIsSuspended(systemEnvironment) != 0;
        if (n != 11 && n != 14 && n != 15 && !bl || n == 15 && sDMSSubmittedEntity.getJobIsRestartable(systemEnvironment) == false || bl && (n == 5 || n == 6 || n == 7 || n == 8 || n == 9 || n == 13)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207082043", "you can only set a state for a (broken) finished  or a suspended not active job"));
        }
        if (n != 14 && n != 15) {
            try {
                l2 = sDMSSubmittedEntity.getJobEsdId(systemEnvironment);
                if (l2 != null) {
                    sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l4, l2), l);
                    if (sDMSSubmittedEntity.getJobIsFinal(systemEnvironment).booleanValue()) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207082044", "you can only set a state for a job in a nonfinal state"));
                    }
                    string = SDMSExitStateDefinitionTable.getObject(systemEnvironment, sDMSSubmittedEntity.getJobEsdId(systemEnvironment), l).getName(systemEnvironment);
                }
                string = "N/A";
            }
            catch (NotFoundException notFoundException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03207082059", "Actual exit state is not part of the profile"));
            }
        } else {
            string = "N/A";
        }
        try {
            sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l4, l3), l);
        }
        catch (NotFoundException notFoundException) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207051918", "Exit State $1 is not part of the profile", (Object)this.exitState));
        }
        if (!this.exitStateForce.booleanValue()) {
            SDMSExitStateProfile sDMSExitStateProfile;
            l2 = sDMSSchedulingEntity.getEsmpId(systemEnvironment);
            if (l2 == null && (l2 = (sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l4, l)).getDefaultEsmpId(systemEnvironment)) == null) {
                SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, "03403090928", "Couldn't determine the exit state mapping for job definition $1", (Object)sDMSSchedulingEntity.pathString(systemEnvironment));
                SDMSThread.doTrace(systemEnvironment.cEnv, sDMSMessage.toString(), -1);
                throw new CommonErrorException(sDMSMessage);
            }
            if (!SDMSExitStateMappingTable.idx_esmpId_esdId.containsKey(systemEnvironment, new SDMSKey(l2, l3), l)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03403090958", "A mapping to exit state $1 doesn't exist, use force if you really want this", (Object)this.exitState));
            }
        }
        this.writeAudit(systemEnvironment, this.jobId, new Integer(7), "old=" + string + ", new=" + this.exitState);
        sDMSSubmittedEntity.changeState(systemEnvironment, l3, sDMSExitState, sDMSSubmittedEntity.getExitCode(systemEnvironment), this.errText, null, false);
    }

    private SDMSAuditTrail writeAudit(SystemEnvironment systemEnvironment, Long l, Integer n, String string) throws SDMSException {
        Date date = new Date();
        Long l2 = new Long(date.getTime());
        return SDMSAuditTrailTable.table.create(systemEnvironment, systemEnvironment.cEnv.uid(), l2, n, new Integer(17), l, l, Boolean.FALSE, string, this.comment);
    }

    private void alterByJob(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        Comparable<Date> comparable;
        long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        if (this.comment != null) {
            comparable = new Date();
            Long l2 = new Long(comparable.getTime());
            SDMSAuditTrailTable.table.create(systemEnvironment, this.jobId, l2, new Integer(14), new Integer(17), this.jobId, this.jobId, Boolean.FALSE, null, this.comment);
        }
        if (this.exitState != null) {
            this.setExitState(systemEnvironment, sDMSSubmittedEntity, l);
        } else if (this.with.containsKey("ERROR_TEXT")) {
            sDMSSubmittedEntity.setErrorMsg(systemEnvironment, this.errText);
        }
        if (this.warning != null) {
            comparable = new Integer(27);
            sDMSSubmittedEntity.setWarn(systemEnvironment, (Integer)comparable, this.warning, new Long(new Date().getTime()), systemEnvironment.cEnv.uid(), true);
        }
        if (this.rerun != null) {
            if (this.rerun.booleanValue()) {
                sDMSSubmittedEntity.rerunRecursive(systemEnvironment, this.jobId, this.comment, true);
            } else {
                this.writeAudit(systemEnvironment, this.jobId, new Integer(1), null);
                sDMSSubmittedEntity.rerun(systemEnvironment);
            }
        }
        if (this.cancel != null && this.cancel.booleanValue()) {
            this.writeAudit(systemEnvironment, this.jobId, new Integer(3), null);
            sDMSSubmittedEntity.cancel(systemEnvironment);
        }
        if (this.kill != null && this.kill.booleanValue()) {
            if (SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l).getKillProgram(systemEnvironment) == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "032070111144", "couldn't kill, no kill program defined"));
            }
            this.writeAudit(systemEnvironment, this.jobId, new Integer(11), null);
            sDMSSubmittedEntity.kill(systemEnvironment);
        }
    }

    private void alterByJobserver(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, long l) throws SDMSException {
        this.auditFlag = false;
        Long l2 = sDMSSubmittedEntity.getScopeId(systemEnvironment);
        int n = sDMSSubmittedEntity.getState(systemEnvironment);
        if (n != 5 && n != 6 && n != 7 && n != 8 && n != 9 && n != 13) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03205141709", "Job altered"));
            return;
        }
        if (!systemEnvironment.cEnv.uid().equals(l2)) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03205141710", "Job altered"));
            return;
        }
        if (this.status != null) {
            this.changeState(systemEnvironment, sDMSSubmittedEntity, false);
        }
        SDMSScope sDMSScope = SDMSScopeTable.getObjectForUpdate(systemEnvironment, l2);
        sDMSScope.setLastActive(systemEnvironment, new Long(systemEnvironment.cEnv.last()));
    }

    private void alterByOperator(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, long l) throws SDMSException {
        Comparable comparable;
        Object object;
        if (this.status != null) {
            object = sDMSSubmittedEntity.getStateAsString(systemEnvironment);
            comparable = this.writeAudit(systemEnvironment, this.jobId, new Integer(6), null);
            this.changeState(systemEnvironment, sDMSSubmittedEntity, true);
            if (comparable != null) {
                ((SDMSAuditTrailProxyGeneric)comparable).setActionInfo(systemEnvironment, "old=" + (String)object + ", new=" + sDMSSubmittedEntity.getStateAsString(systemEnvironment));
            }
        }
        if (this.exitState != null) {
            this.setExitState(systemEnvironment, sDMSSubmittedEntity, l);
        }
        object = null;
        if (this.resumeObj != null && ((object = SubmitJob.evalResumeObj(systemEnvironment, this.resumeObj, null, true, sDMSSubmittedEntity.getEffectiveTimeZone(systemEnvironment))) == null || (Long)object == -1L)) {
            if (sDMSSubmittedEntity.getIsSuspended(systemEnvironment) != 0) {
                this.suspend = Boolean.FALSE;
            } else {
                this.suspend = null;
                this.resumeObj = null;
            }
        }
        if (this.suspend != null) {
            if (this.suspend.booleanValue()) {
                this.writeAudit(systemEnvironment, this.jobId, new Integer(4), null);
                sDMSSubmittedEntity.suspend(systemEnvironment, this.localSuspend, this.adminSuspend);
                SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSSubmittedEntity, 6);
            } else {
                this.writeAudit(systemEnvironment, this.jobId, new Integer(5), null);
                if (sDMSSubmittedEntity.getIsSuspended(systemEnvironment) == 2 && !this.adminSuspend.booleanValue()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03408080757", "Insufficient privileges for admin resume"));
                }
                sDMSSubmittedEntity.resume(systemEnvironment, this.adminSuspend);
                SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSSubmittedEntity, 7);
            }
        }
        if (this.resumeObj != null) {
            comparable = new Date((Long)object);
            this.writeAudit(systemEnvironment, this.jobId, new Integer(5), ((Date)comparable).toString());
            sDMSSubmittedEntity.setResumeTs(systemEnvironment, (Long)object);
        }
        if (this.rerun != null) {
            if (this.rerun.booleanValue()) {
                sDMSSubmittedEntity.rerunRecursive(systemEnvironment, this.jobId, this.comment, true);
            } else {
                this.writeAudit(systemEnvironment, this.jobId, new Integer(1), null);
                sDMSSubmittedEntity.rerun(systemEnvironment);
            }
        }
        if (this.kill != null && this.kill.booleanValue()) {
            if (SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l).getKillProgram(systemEnvironment) == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "032070111144", "couldn't kill, no kill program defined"));
            }
            this.writeAudit(systemEnvironment, this.jobId, new Integer(11), null);
            sDMSSubmittedEntity.kill(systemEnvironment);
        }
        if (this.cancel != null && this.cancel.booleanValue()) {
            this.writeAudit(systemEnvironment, this.jobId, new Integer(3), null);
            sDMSSubmittedEntity.cancel(systemEnvironment);
        }
        if (this.disable != null) {
            this.writeAudit(systemEnvironment, this.jobId, new Integer(this.disable != false ? 30 : 31), null);
            sDMSSubmittedEntity.disable(systemEnvironment, this.disable);
        }
        if (this.depsToIgnore != null) {
            this.ignoreDeps(systemEnvironment, sDMSSubmittedEntity);
        }
        if (this.nrsToIgnore != null) {
            this.ignoreNamedResources(systemEnvironment, sDMSSubmittedEntity);
            SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSSubmittedEntity, 12);
        }
        if (this.resToIgnore != null) {
            this.ignoreResources(systemEnvironment, sDMSSubmittedEntity);
            SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSSubmittedEntity, 12);
        }
        if (this.priority != null) {
            if (SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l).getType(systemEnvironment) != 1) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03211211229", "Cannot change the priority of a batch or milestone"));
            }
            if (this.priority < SystemEnvironment.priorityLowerBound && !systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
                this.priority = new Integer(SystemEnvironment.priorityLowerBound);
            }
            this.writeAudit(systemEnvironment, this.jobId, new Integer(19), "old=" + sDMSSubmittedEntity.getPriority(systemEnvironment) + ", new=" + this.priority);
            sDMSSubmittedEntity.setPriority(systemEnvironment, this.priority);
        }
        if (this.nicevalue != null) {
            sDMSSubmittedEntity.renice(systemEnvironment, this.nicevalue, null, this.comment);
        }
        if (this.renice != null) {
            int n = this.renice + sDMSSubmittedEntity.getNice(systemEnvironment);
            sDMSSubmittedEntity.renice(systemEnvironment, new Integer(n), null, this.comment);
        }
        if (this.clone != null) {
            if (sDMSSubmittedEntity.getIsReplaced(systemEnvironment).booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03910311420", "Cannot clone an already replaced job or batch"));
            }
            if (sDMSSubmittedEntity.getState(systemEnvironment) != 12) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03910311421", "Cannot clone a job or batch that is stil active"));
            }
            Long l2 = sDMSSubmittedEntity.getParentId(systemEnvironment);
            if (l2 == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03910311422", "Cannot clone a master job or batch"));
            }
            SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l2);
            String string = "C_" + systemEnvironment.tx.txId;
            Long l3 = sDMSSubmittedEntity.getId(systemEnvironment);
            Long l4 = sDMSSubmittedEntity.getSeId(systemEnvironment);
            SDMSSubmittedEntity sDMSSubmittedEntity3 = sDMSSubmittedEntity2.submitChild(systemEnvironment, null, new Integer(1), null, l4, string, l3, null, true);
            if (sDMSSubmittedEntity3.getIsDisabled(systemEnvironment).booleanValue()) {
                sDMSSubmittedEntity3.disable(systemEnvironment, Boolean.FALSE);
            } else if (!this.clone.booleanValue()) {
                sDMSSubmittedEntity3.resume(systemEnvironment, true);
            }
            this.writeAudit(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment), new Integer(32), this.errText);
        }
        if (this.clearWarning != null) {
            Integer n = new Integer(26);
            if (this.comment == null) {
                this.comment = "";
            }
            sDMSSubmittedEntity.clearWarn(systemEnvironment, n, this.comment, new Long(new Date().getTime()), systemEnvironment.cEnv.uid());
        }
        if (this.warning != null) {
            Integer n = new Integer(27);
            sDMSSubmittedEntity.setWarn(systemEnvironment, n, this.warning, new Long(new Date().getTime()), systemEnvironment.cEnv.uid(), true);
        }
        if (this.with.containsKey("ERROR_TEXT")) {
            sDMSSubmittedEntity.setErrorMsg(systemEnvironment, this.errText);
        }
        if (this.execPid == null && this.extPid == null && this.status == null && this.ts == null && this.exitCode == null && this.suspend == null && this.rerun == null && this.depsToIgnore == null && this.exitState == null && this.kill == null && this.nrsToIgnore == null && this.resToIgnore == null && this.nicevalue == null && this.renice == null && this.cancel == null && this.priority == null && this.clearWarning == null && this.warning == null && this.resumeObj == null && this.disable == null && this.clone == null) {
            this.writeAudit(systemEnvironment, this.jobId, new Integer(14), null);
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity = null;
        boolean bl = false;
        this.collectWith(systemEnvironment);
        if (systemEnvironment.cEnv.isJob()) {
            this.jobId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObjectForUpdate(systemEnvironment, this.jobId);
        } else {
            try {
                sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObjectForUpdate(systemEnvironment, this.jobId);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        if (this.rerunSeq != null && sDMSSubmittedEntity != null) {
            int n;
            int n2 = this.rerunSeq;
            if (n2 < (n = sDMSSubmittedEntity.getRerunSeq(systemEnvironment).intValue())) {
                if (systemEnvironment.cEnv.isUser()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03406031444", "Run sequence number expired"));
                }
                bl = true;
            } else if (n2 > n) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03406031442", "Run sequence number out of sync"));
            }
        }
        if (!bl) {
            if (systemEnvironment.cEnv.isJob()) {
                this.alterByJob(systemEnvironment, sDMSSubmittedEntity);
            } else {
                if (sDMSSubmittedEntity == null) {
                    this.go_killjob(systemEnvironment);
                    return;
                }
                long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
                if (systemEnvironment.cEnv.isJobServer()) {
                    this.alterByJobserver(systemEnvironment, sDMSSubmittedEntity, l);
                } else {
                    this.alterByOperator(systemEnvironment, sDMSSubmittedEntity, l);
                }
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204112159", "Job altered"));
    }

    private void changeKillJobState(SystemEnvironment systemEnvironment, SDMSKillJob sDMSKillJob, boolean bl) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSKillJob.getSmeId(systemEnvironment));
        int n = sDMSSubmittedEntity.getState(systemEnvironment);
        sDMSKillJob.setState(systemEnvironment, this.status);
        this.delFromQueue(systemEnvironment, sDMSKillJob);
        if (this.with.containsKey("ERROR_TEXT")) {
            sDMSKillJob.setErrorMsg(systemEnvironment, this.errText);
        }
        if (this.with.containsKey("EXEC_PID")) {
            sDMSKillJob.setPid(systemEnvironment, this.execPid);
        }
        if (this.with.containsKey("EXT_PID")) {
            sDMSKillJob.setExtPid(systemEnvironment, this.extPid);
        }
        switch (this.status) {
            case 6: {
                if (this.tsLong == null) break;
                sDMSKillJob.setStartTs(systemEnvironment, this.tsLong);
                break;
            }
            case 7: {
                if (this.tsLong == null) break;
                sDMSKillJob.setStartTs(systemEnvironment, this.tsLong);
                break;
            }
            case 11: {
                if (this.tsLong != null) {
                    sDMSKillJob.setFinishTs(systemEnvironment, this.tsLong);
                }
                if (this.with.containsKey("EXIT_CODE")) {
                    sDMSKillJob.setExitCode(systemEnvironment, this.exitCode);
                    sDMSSubmittedEntity.setKillExitCode(systemEnvironment, this.exitCode);
                }
                if (n != 8) break;
                sDMSSubmittedEntity.setState(systemEnvironment, new Integer(9));
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                if (n != 8) break;
                sDMSSubmittedEntity.setState(systemEnvironment, new Integer(9));
                break;
            }
            case 15: {
                if (n != 8) break;
                sDMSSubmittedEntity.setState(systemEnvironment, new Integer(7));
                break;
            }
            default: {
                if (!bl) break;
                sDMSKillJob.setState(systemEnvironment, this.status);
            }
        }
    }

    private void go_killjob(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKillJob sDMSKillJob = null;
        sDMSKillJob = SDMSKillJobTable.getObject(systemEnvironment, this.jobId);
        if (systemEnvironment.cEnv.isJobServer()) {
            if (!systemEnvironment.cEnv.uid().equals(sDMSKillJob.getScopeId(systemEnvironment))) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03207091826", "Job altered"));
                return;
            }
            if (this.status != null) {
                this.changeKillJobState(systemEnvironment, sDMSKillJob, false);
            }
        } else if (this.status != null) {
            this.changeKillJobState(systemEnvironment, sDMSKillJob, true);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03207091825", "Job altered"));
    }

    private void ignoreDeps(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        for (int i = 0; i < this.depsToIgnore.size(); ++i) {
            Vector vector = (Vector)this.depsToIgnore.get(i);
            Long l = (Long)vector.get(0);
            Boolean bl = (Boolean)vector.get(1);
            SDMSDependencyInstance sDMSDependencyInstance = SDMSDependencyInstanceTable.getObject(systemEnvironment, l);
            sDMSDependencyInstance.setIgnore(systemEnvironment, bl != false ? 2 : 1, this.jobId, this.comment);
        }
    }

    private void ignoreNamedResources(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
    }

    private void ignoreResources(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        SDMSResourceAllocation sDMSResourceAllocation = null;
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), sDMSSubmittedEntity.getSeVersion(systemEnvironment));
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        boolean bl = false;
        for (int i = 0; i < this.resToIgnore.size(); ++i) {
            SDMSProxy sDMSProxy;
            Long l2 = (Long)this.resToIgnore.get(i);
            try {
                sDMSProxy = SDMSResourceTable.getObject(systemEnvironment, l2);
                Vector vector = SDMSResourceAllocationTable.idx_smeId_nrId.getVector(systemEnvironment, new SDMSKey(l, ((SDMSResourceProxyGeneric)sDMSProxy).getNrId(systemEnvironment)));
                for (int j = 0; j < vector.size(); ++j) {
                    sDMSResourceAllocation = (SDMSResourceAllocation)vector.get(j);
                    if (!sDMSResourceAllocation.getRId(systemEnvironment).equals(l2)) continue;
                    bl = true;
                    break;
                }
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            if (!bl) continue;
            if (sDMSSchedulingEntity.checkParameterRI(systemEnvironment, sDMSResourceAllocation.getNrId(systemEnvironment))) {
                sDMSProxy = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResourceAllocation.getNrId(systemEnvironment));
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409291444", "You cannot ignore resource $1, parameter references exist", (Object)((SDMSNamedResourceProxyGeneric)sDMSProxy).pathString(systemEnvironment)));
            }
            this.writeAudit(systemEnvironment, this.jobId, new Integer(10), l2.toString());
            sDMSResourceAllocation.ignore(systemEnvironment);
        }
    }

    private void delFromQueue(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        try {
            SDMSRunnableQueue sDMSRunnableQueue = SDMSRunnableQueueTable.idx_smeId_scopeId_getUniqueForUpdate(systemEnvironment, new SDMSKey(sDMSSubmittedEntity.getId(systemEnvironment), systemEnvironment.cEnv.uid()));
            sDMSRunnableQueue.delete(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void delFromQueue(SystemEnvironment systemEnvironment, SDMSKillJob sDMSKillJob) throws SDMSException {
        try {
            SDMSRunnableQueue sDMSRunnableQueue = SDMSRunnableQueueTable.idx_smeId_scopeId_getUnique(systemEnvironment, new SDMSKey(sDMSKillJob.getId(systemEnvironment), systemEnvironment.cEnv.uid()));
            sDMSRunnableQueue.delete(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

