/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.ListenThread;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;

public class AlterServer
extends Node {
    public static final String __version = "@(#) $Id: AlterServer.java,v 2.3.6.1 2013/03/14 10:24:23 ronald Exp $";
    int traceLevel;
    boolean doSchedule;
    Boolean suspend;
    int threadId;

    public AlterServer(Boolean bl, Integer n) {
        this.threadId = -n.intValue();
        this.doSchedule = false;
        this.suspend = bl;
        this.txMode = 1;
    }

    public AlterServer(Integer n) {
        this.traceLevel = n;
        this.doSchedule = false;
        this.suspend = null;
        this.txMode = 1;
    }

    public AlterServer() {
        this.doSchedule = true;
        this.suspend = null;
        this.txMode = 2;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Thread[] threadArray;
        Object object;
        if (!systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
            object = systemEnvironment.cEnv.gid().iterator();
            threadArray = new SDMSPrivilege();
            while (object.hasNext()) {
                Long l = (Long)object.next();
                try {
                    SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(SDMSProxy.ZERO, l));
                    threadArray.addPriv(systemEnvironment, sDMSGrant.getPrivs(systemEnvironment));
                }
                catch (NotFoundException notFoundException) {}
            }
            if (!threadArray.can(0x200000000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03202081832", "Insufficient Privileges"));
            }
        }
        if (this.doSchedule) {
            SystemEnvironment.sched.requestReschedule();
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03805141212", "Resource reschedule requested"));
        } else if (this.suspend != null) {
            if (this.suspend.booleanValue()) {
                if (SystemEnvironment.sched.id() == this.threadId) {
                    SystemEnvironment.sched.SDMSsuspend();
                    this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203191018", "Scheduling Thread suspended"));
                }
                if (SystemEnvironment.tt.id() == this.threadId) {
                    SystemEnvironment.tt.SDMSsuspend();
                    this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203191018", "Trigger Thread suspended"));
                }
                if (SystemEnvironment.timer.id() == this.threadId) {
                    SystemEnvironment.timer.SDMSsuspend();
                    this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203191018", "Timer Thread suspended"));
                }
            } else {
                if (SystemEnvironment.sched.id() == this.threadId) {
                    SystemEnvironment.sched.SDMSresume();
                    this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203191018", "Scheduling Thread resumed"));
                }
                if (SystemEnvironment.tt.id() == this.threadId) {
                    SystemEnvironment.tt.SDMSresume();
                    this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203191018", "Trigger Thread resumed"));
                }
                if (SystemEnvironment.timer.id() == this.threadId) {
                    SystemEnvironment.timer.SDMSresume();
                    this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203191018", "Timer Thread resumed"));
                }
            }
        } else {
            int n;
            object = this.env.getMe().getThreadGroup();
            threadArray = new SDMSThread[((ThreadGroup)object).activeCount()];
            int n2 = ((ThreadGroup)object).enumerate(threadArray);
            for (n = 0; n < n2 && !(threadArray[n] instanceof ListenThread); ++n) {
            }
            if (n >= n2) {
                return;
            }
            SystemEnvironment.setTraceLevel(this.traceLevel);
            switch (this.traceLevel) {
                case 0: {
                    ((ListenThread)threadArray[n]).trace_off();
                    SDMSException.debugOff();
                    this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203191018", "Server Trace disabled"));
                    break;
                }
                case 1: {
                    SDMSException.debugOff();
                    this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203191017", "Server Trace shows warnings"));
                    break;
                }
                case 2: {
                    SDMSException.debugOff();
                    this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203191019", "Server Trace shows messages"));
                    break;
                }
                default: {
                    SDMSException.debugOn();
                    this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203191020", "Server Trace shows everything"));
                }
            }
        }
    }
}

