/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.ConnectionEnvironment;
import de.independit.scheduler.server.ListenThread;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.UserConnection;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputRenderer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserEquivTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.SDMSThread;

public class AlterSession
extends Node {
    public static final String __version = "@(#) $Id: AlterSession.java,v 2.6.2.1 2013/03/14 10:24:23 ronald Exp $";
    private static final Long zero = new Long(0L);
    private Integer sid;
    private String userName;
    private String baseUser;
    private boolean trc;
    private WithHash withs;
    boolean resetUser = false;

    public AlterSession(Integer n, WithHash withHash) {
        this.sid = n;
        this.withs = withHash;
        this.userName = null;
        this.baseUser = null;
        this.cmdtype = 7;
        this.txMode = 1;
        this.auditFlag = false;
    }

    public AlterSession(String string, WithHash withHash) {
        this.sid = null;
        this.withs = withHash;
        this.userName = string;
        this.baseUser = null;
        this.cmdtype = 1;
        this.txMode = 1;
        this.auditFlag = false;
    }

    public AlterSession(String string, String string2, WithHash withHash) {
        this.sid = null;
        this.withs = withHash;
        this.userName = string;
        this.baseUser = string2;
        this.cmdtype = 1;
        this.txMode = 1;
        this.auditFlag = false;
    }

    public AlterSession() {
        this.sid = null;
        this.userName = null;
        this.resetUser = true;
        this.withs = null;
        this.cmdtype = 1;
        this.txMode = 1;
        this.auditFlag = false;
    }

    private boolean setUser(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSUser sDMSUser;
        SDMSUser sDMSUser2;
        block12: {
            sDMSUser2 = null;
            sDMSUser = null;
            try {
                sDMSUser2 = SDMSUserTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.userName), zero));
                if (!sDMSUser2.getIsEnabled(systemEnvironment).booleanValue()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03707161120", "User disabled"));
                }
                if (this.baseUser == null) break block12;
                try {
                    sDMSUser = SDMSUserTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.baseUser), zero));
                }
                catch (NotFoundException notFoundException) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03707161122", "Base User not found"));
                }
                if (!sDMSUser.getIsEnabled(systemEnvironment).booleanValue()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03708010942", "User disabled"));
                }
            }
            catch (NotFoundException notFoundException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03707161121", "User not found"));
            }
        }
        if (this.userName.equals(this.baseUser) || this.baseUser == null) {
            sDMSUser = sDMSUser2;
            this.baseUser = this.userName;
        }
        boolean bl = systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId);
        boolean bl2 = false;
        Long l = new Long(systemEnvironment.cEnv.uid());
        Long l2 = sDMSUser.getId(systemEnvironment);
        Long l3 = sDMSUser2.getId(systemEnvironment);
        if (SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(SDMSObject.adminGId, l2))) {
            bl2 = true;
        }
        if (!(l2.equals(l3) || SDMSUserEquivTable.idx_uId_altUId.containsKey(systemEnvironment, new SDMSKey(l2, l3)) || bl2)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03708011016", "Insufficient privileges"));
        }
        if (!bl && !l2.equals(l)) {
            if (!l2.equals(l3)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03707071405", "Insufficient privileges"));
            }
            if (!SDMSUserEquivTable.idx_uId_altUId.containsKey(systemEnvironment, new SDMSKey(l, l3))) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03708011035", "Insufficient privileges"));
            }
        }
        systemEnvironment.cEnv.setConnectedUser(systemEnvironment, l3, SDMSMemberTable.idx_uId.getVector(systemEnvironment, l3));
        return true;
    }

    private boolean resetUser(SystemEnvironment systemEnvironment) {
        return systemEnvironment.cEnv.resetConnectedUser();
    }

    private void alterSession(SystemEnvironment systemEnvironment) {
        ThreadGroup threadGroup = this.env.getMe().getThreadGroup();
        Thread[] threadArray = new SDMSThread[threadGroup.activeCount()];
        int n = threadGroup.enumerate(threadArray);
        if (this.sid == null) {
            this.sid = new Integer(this.env.id());
        }
        int n2 = this.sid;
        for (int i = 0; i < n; ++i) {
            ConnectionEnvironment connectionEnvironment;
            if (threadArray[i] instanceof ListenThread || (connectionEnvironment = ((UserConnection)threadArray[i]).getEnv()) == null || n2 != ((SDMSThread)threadArray[i]).id()) continue;
            if (this.withs.containsKey("TRACE_LEVEL")) {
                Object v = this.withs.get("TRACE_LEVEL");
                if (v instanceof Boolean) {
                    this.trc = (Boolean)v;
                    if (this.trc) {
                        connectionEnvironment.trace_on();
                    } else {
                        connectionEnvironment.trace_off();
                    }
                } else {
                    connectionEnvironment.setTraceLevel((Integer)v);
                }
            }
            if (this.withs.containsKey("PROTOCOL")) {
                connectionEnvironment.setRenderer((SDMSOutputRenderer)this.withs.get("PROTOCOL"));
            }
            if (this.withs.containsKey("TIMEOUT")) {
                this.env.getMe().setTimeout((Integer)this.withs.get("TIMEOUT"));
            }
            if (!this.withs.containsKey("SESSION")) break;
            connectionEnvironment.setInfo((String)this.withs.get("SESSION"));
            break;
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.userName != null) {
            systemEnvironment.cEnv.resetConnectedUser();
            if (this.setUser(systemEnvironment)) {
                this.alterSession(systemEnvironment);
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203182358", "Session altered"));
            } else {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03707141429", "Session unchanged"));
            }
        } else if (this.resetUser) {
            if (this.resetUser(systemEnvironment)) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203182359", "Session altered"));
            } else {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03707141428", "Session unchanged"));
            }
        } else {
            this.alterSession(systemEnvironment);
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203182357", "Session altered"));
        }
    }
}

