/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import java.util.Vector;

public class CopyNamedResource
extends Node {
    public static final String __version = "@(#) $Id: CopyNamedResource.java,v 2.2.2.1 2013/03/14 10:24:24 ronald Exp $";
    private ObjectURL url;
    private Vector path2;
    private String newName;

    public CopyNamedResource(ObjectURL objectURL, Vector vector) {
        this.url = objectURL;
        this.path2 = vector;
        this.newName = null;
    }

    public CopyNamedResource(ObjectURL objectURL, String string) {
        this.url = objectURL;
        this.path2 = null;
        this.newName = string;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l;
        String string;
        SDMSNamedResource sDMSNamedResource;
        SDMSNamedResource sDMSNamedResource2 = (SDMSNamedResource)this.url.resolve(systemEnvironment);
        Long l2 = sDMSNamedResource2.getParentId(systemEnvironment);
        if (l2 == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03704102150", "The category RESOURCE cannot be copied"));
        }
        if (this.newName == null) {
            try {
                sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, this.path2);
                string = sDMSNamedResource2.getName(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                string = (String)this.path2.remove(this.path2.size() - 1);
                sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, this.path2);
            }
        } else {
            sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l2);
            string = this.newName;
        }
        Long l3 = sDMSNamedResource.getId(systemEnvironment);
        if (sDMSNamedResource.getUsage(systemEnvironment) != 8) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206250010", "Resource cannot be contained within another Resource"));
        }
        if (SDMSNamedResourceTable.idx_parentId_name.containsKey(systemEnvironment, new SDMSKey(l3, (Comparable)((Object)string)))) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03112191239", "A resource or category with name $1 already exists within $2", (Object)string, (Object)sDMSNamedResource.pathString(systemEnvironment)));
        }
        Long l4 = sDMSNamedResource2.getId(systemEnvironment);
        if (l3.equals(l4)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207041859", "A category cannot be copied below itself"));
        }
        while ((l = sDMSNamedResource.getParentId(systemEnvironment)) != null) {
            if (l.equals(l4)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207041902", "A Folder cannot be copied below itself"));
            }
            sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l);
        }
        sDMSNamedResource2.copy(systemEnvironment, l3, string);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203150038", "Named Resource copied"));
    }
}

