/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterDistribution;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolDistConfig;
import de.independit.scheduler.server.repository.SDMSPoolDistConfigTable;
import de.independit.scheduler.server.repository.SDMSPoolDistribution;
import de.independit.scheduler.server.repository.SDMSPoolDistributionTable;
import de.independit.scheduler.server.repository.SDMSPooledResource;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import java.util.HashSet;
import java.util.Vector;

public class CreateDistribution
extends Node {
    public static final String __version = "@(#) $Id: CreateDistribution.java,v 2.2.14.3 2013/03/20 06:42:57 ronald Exp $";
    private final ObjectURL url;
    private final ObjectURL dist_url;
    private final String name;
    private final Vector resList;
    private final boolean replace;
    private static final Integer zero = new Integer(0);

    public CreateDistribution(ObjectURL objectURL, Vector vector, Boolean bl) {
        this.dist_url = objectURL;
        this.url = this.dist_url.master;
        this.name = objectURL.name;
        this.resList = vector;
        this.replace = bl;
    }

    private Long createDistConfig(SystemEnvironment systemEnvironment, WithHash withHash, Long l, Long l2) throws SDMSException {
        Integer n = (Integer)withHash.get("FREEPCT");
        Integer n2 = (Integer)withHash.get("MINPCT");
        Integer n3 = (Integer)withHash.get("MAXPCT");
        Integer n4 = (Integer)withHash.get("NOMINALPCT");
        Boolean bl = (Boolean)withHash.get("MANAGED");
        ObjectURL objectURL = (ObjectURL)withHash.get("RESOURCE");
        if (objectURL == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221151", "No resource specified"));
        }
        SDMSProxy sDMSProxy = objectURL.resolve(systemEnvironment);
        Long l3 = sDMSProxy.getId(systemEnvironment);
        SDMSPooledResource sDMSPooledResource = SDMSPooledResourceTable.idx_pId_rId_getUnique(systemEnvironment, new SDMSKey(l2, l3));
        Long l4 = sDMSPooledResource.getId(systemEnvironment);
        if (n == null) {
            n = sDMSPooledResource.getFreePct(systemEnvironment);
        }
        if (n2 == null) {
            n2 = sDMSPooledResource.getMinPct(systemEnvironment);
        }
        if (n3 == null) {
            n3 = sDMSPooledResource.getMaxPct(systemEnvironment);
        }
        if (n4 == null) {
            n4 = sDMSPooledResource.getNomPct(systemEnvironment);
        }
        if (bl == null) {
            bl = sDMSPooledResource.getIsManaged(systemEnvironment);
        }
        if (!bl.booleanValue()) {
            n = zero;
            n2 = zero;
            n3 = zero;
            n4 = zero;
        }
        if (n2 > n4) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221155", "MINPCT should not be larger than NOMINALPCT"));
        }
        if (n4 > n3) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221156", "NOMINALPCT should not be larger than MAXPCT"));
        }
        if (n3 > 100) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221437", "MAXPCT should not be exceed 100%"));
        }
        SDMSPoolDistConfig sDMSPoolDistConfig = SDMSPoolDistConfigTable.table.create(systemEnvironment, l, l4, bl, n4, n, n2, n3);
        return l4;
    }

    private void checkAndRepairDistribution(SystemEnvironment systemEnvironment, Long l, Long l2, HashSet hashSet) throws SDMSException {
        Vector vector = SDMSPooledResourceTable.idx_pId.getVector(systemEnvironment, l2);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSPooledResource sDMSPooledResource = (SDMSPooledResource)vector.get(i);
            Long l3 = sDMSPooledResource.getId(systemEnvironment);
            if (hashSet.contains(l3)) continue;
            SDMSPoolDistConfigTable.table.create(systemEnvironment, l, l3, Boolean.FALSE, zero, zero, zero, zero);
        }
        Vector vector2 = SDMSPoolDistConfigTable.idx_pldId.getVector(systemEnvironment, l);
        int n = 0;
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSPoolDistConfig sDMSPoolDistConfig = (SDMSPoolDistConfig)vector2.get(i);
            n += sDMSPoolDistConfig.getNomPct(systemEnvironment).intValue();
        }
        if (n > 100) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221246", "The sum of NOMINALPCT should not exceed 100%"));
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        systemEnvironment.checkFeatureAvailability("POOL");
        SDMSPool sDMSPool = (SDMSPool)this.url.resolve(systemEnvironment);
        Long l = sDMSPool.getId(systemEnvironment);
        HashSet<Long> hashSet = new HashSet<Long>();
        if (this.name.toUpperCase().compareTo("DEFAULT") == 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221103", "The name DEFAULT is reserved within the context of distributions"));
        }
        try {
            SDMSPoolDistribution sDMSPoolDistribution = SDMSPoolDistributionTable.table.create(systemEnvironment, this.name, l);
            Long l2 = sDMSPoolDistribution.getId(systemEnvironment);
            for (int i = 0; i < this.resList.size(); ++i) {
                WithHash withHash = (WithHash)this.resList.get(i);
                if (hashSet.add(this.createDistConfig(systemEnvironment, withHash, l2, l))) continue;
                ObjectURL objectURL = (ObjectURL)withHash.get("RESOURCE");
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221203", "The resource $1 in $2 is specified more than once", (Object)objectURL.path, (Object)objectURL.master.path));
            }
            this.checkAndRepairDistribution(systemEnvironment, l2, l, hashSet);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                AlterDistribution alterDistribution = new AlterDistribution(this.dist_url, this.resList, Boolean.FALSE);
                alterDistribution.setEnv(this.env);
                alterDistribution.go(systemEnvironment);
                this.result = alterDistribution.result;
                return;
            }
            throw duplicateKeyException;
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03603201216", "Distribution created"));
    }
}

