/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterExitStatProf;
import de.independit.scheduler.server.parser.EspState;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import java.util.Iterator;
import java.util.Vector;

public class CreateExitStatProf
extends Node {
    public static final String __version = "@(#) $Id: CreateExitStatProf.java,v 2.8.2.1 2013/03/14 10:24:25 ronald Exp $";
    private String name;
    private WithHash items;
    private boolean replace;

    public CreateExitStatProf(String string, WithHash withHash, Boolean bl) {
        this.name = string;
        this.items = withHash;
        this.replace = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object;
        Comparable<Boolean> comparable;
        SDMSExitStateProfile sDMSExitStateProfile;
        boolean bl = false;
        try {
            sDMSExitStateProfile = SDMSExitStateProfileTable.table.create(systemEnvironment, this.name, null, Boolean.TRUE);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                AlterExitStatProf alterExitStatProf = new AlterExitStatProf(new ObjectURL(new Integer(363), this.name), this.items, Boolean.FALSE);
                alterExitStatProf.setEnv(this.env);
                alterExitStatProf.go(systemEnvironment);
                this.result = alterExitStatProf.result;
                return;
            }
            throw duplicateKeyException;
        }
        Long l = sDMSExitStateProfile.getId(systemEnvironment);
        Vector vector = (Vector)this.items.get("STATUS");
        if (vector == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03112171825", "States missing"));
        }
        Iterator iterator = vector.iterator();
        int n = 1;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        while (iterator.hasNext()) {
            Integer n2 = new Integer(n);
            ++n;
            EspState espState = (EspState)iterator.next();
            comparable = Boolean.FALSE;
            object = Boolean.FALSE;
            Boolean bl6 = espState.broken;
            Boolean bl7 = espState.unreachable;
            Boolean bl8 = espState.disabled;
            Boolean bl9 = espState.batchDefault;
            Boolean bl10 = espState.depDefault;
            if (espState.type.equals(new Integer(3))) {
                comparable = Boolean.TRUE;
                bl = true;
            }
            if (espState.type.equals(new Integer(1))) {
                object = Boolean.TRUE;
            }
            if (bl7.booleanValue()) {
                if (bl2) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02205311455", "Only one state can be marked as unreachable state"));
                }
                bl2 = true;
                if (!((Boolean)comparable).booleanValue()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02204301739", "The unreachable state must be defined FINAL"));
                }
            }
            if (bl8.booleanValue()) {
                if (bl3) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02011110820", "Only one state can be marked as disabled state"));
                }
                bl3 = true;
                if (!((Boolean)comparable).booleanValue()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02011110821", "The disabled state must be defined FINAL"));
                }
            }
            if (bl6.booleanValue()) {
                if (bl4) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03504300759", "Only one state can be marked as broken state"));
                }
                bl4 = true;
            }
            if (bl9.booleanValue()) {
                if (bl5) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202141003", "Only one state can be marked as default exit stae for batches and milestones"));
                }
                bl5 = true;
                if (!((Boolean)comparable).booleanValue()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202141008", "The default exit state for batches and milestones must be defined FINAL"));
                }
            }
            if (bl10.booleanValue() && !((Boolean)comparable).booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202141009", "A default exit state for dependencies must be defined FINAL"));
            }
            Long l2 = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, espState.name).getId(systemEnvironment);
            try {
                SDMSExitStateTable.table.create(systemEnvironment, n2, (Boolean)comparable, (Boolean)object, bl7, bl8, bl6, bl9, bl10, l, l2);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03110120948", "Exit state definition $1 specified more than once", (Object)espState.name));
            }
        }
        if (!bl) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202242058", "An exit state profile requires at least one final state"));
        }
        comparable = null;
        object = (String)this.items.get("DEFAULT_MAPPING");
        if (object != null) {
            comparable = SDMSExitStateMappingProfileTable.idx_name_getUnique(systemEnvironment, object).getId(systemEnvironment);
            sDMSExitStateProfile.validateMappingProfile(systemEnvironment, (Long)comparable);
            sDMSExitStateProfile.setDefaultEsmpId(systemEnvironment, (Long)comparable);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204112201", "Exit State Profile created"));
    }
}

