/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcherTable;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchy;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import java.util.Vector;

public class DropInterval
extends Node {
    public static final String __version = "@(#) $Id: DropInterval.java,v 2.3.4.1 2013/03/14 10:24:30 ronald Exp $";
    private final ObjectURL obj;
    private final boolean noerr;

    public DropInterval(ObjectURL objectURL, Boolean bl) {
        this.obj = objectURL;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        block11: {
            try {
                SDMSInterval sDMSInterval = (SDMSInterval)this.obj.resolve(systemEnvironment);
                Long l = this.obj.objId;
                if (SDMSIntervalTable.idx_embeddedIntervalId.containsKey(systemEnvironment, l)) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04209111937", "Interval in use by Interval(s)"));
                }
                if (SDMSScheduleTable.idx_intId.containsKey(systemEnvironment, l)) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04207191907", "Interval in use by Schedule(s)"));
                }
                if (SDMSIntervalHierarchyTable.idx_childId.containsKey(systemEnvironment, l)) {
                    Vector vector = SDMSIntervalHierarchyTable.idx_childId.getVector(systemEnvironment, l);
                    for (int i = 0; i < vector.size(); ++i) {
                        SDMSIntervalHierarchy sDMSIntervalHierarchy = (SDMSIntervalHierarchy)vector.get(i);
                        Long l2 = sDMSIntervalHierarchy.getParentId(systemEnvironment);
                        try {
                            SDMSIntervalTable.getObject(systemEnvironment, l2);
                            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04209112049", "Interval in use by Interval(s)"));
                        }
                        catch (NotFoundException notFoundException) {
                            sDMSIntervalHierarchy.delete(systemEnvironment);
                            continue;
                        }
                    }
                }
                if (SDMSSchedulingHierarchyTable.idx_intId.containsKey(systemEnvironment, l)) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04811061006", "Interval in use by SchedulingHierarchy(s)"));
                }
                if (SDMSIntervalDispatcherTable.idx_selectIntId.containsKey(systemEnvironment, l)) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03910070933", "Interval in use as select interval by Dispatcher(s)"));
                }
                if (SDMSIntervalDispatcherTable.idx_filterIntId.containsKey(systemEnvironment, l)) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03910070934", "Interval in use as filter by Dispatcher(s)"));
                }
                IntervalUtil.killFilter(systemEnvironment, l);
                IntervalUtil.killSelections(systemEnvironment, l);
                IntervalUtil.killDispatcher(systemEnvironment, l);
                sDMSInterval.delete(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                if (this.noerr) break block11;
                throw notFoundException;
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207181908", "Interval dropped"));
    }
}

