/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.FolderLister;
import de.independit.scheduler.server.parser.Formatter;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSFootprint;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class ListFolder
extends Node
implements Formatter {
    public static final String __version = "@(#) $Id: ListFolder.java,v 2.18.2.2 2013/06/18 09:49:32 ronald Exp $";
    Vector path;
    HashSet expandIds;
    HashMap mseCache = new HashMap();
    WithHash with;
    FolderLister fl;
    boolean isCondensed;

    public ListFolder(Vector vector) {
        this.path = vector;
        this.expandIds = new HashSet();
        this.txMode = 1;
        this.auditFlag = false;
    }

    public ListFolder(Vector vector, HashSet hashSet) {
        this.path = vector;
        this.expandIds = hashSet;
        this.txMode = 1;
        this.auditFlag = false;
    }

    public ListFolder(Vector vector, WithHash withHash, Boolean bl) {
        this.path = vector;
        this.expandIds = withHash.containsKey("EXPAND") ? (HashSet)withHash.get("EXPAND") : new HashSet();
        this.with = withHash;
        this.isCondensed = bl;
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public Vector fillHeadInfo() {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("TYPE");
        if (!this.isCondensed) {
            vector.add("RUN_PROGRAM");
            vector.add("RERUN_PROGRAM");
            vector.add("KILL_PROGRAM");
            vector.add("WORKDIR");
            vector.add("LOGFILE");
            vector.add("TRUNC_LOG");
            vector.add("ERRLOGFILE");
            vector.add("TRUNC_ERRLOG");
            vector.add("EXPECTED_RUNTIME");
            vector.add("EXPECTED_FINALTIME");
            vector.add("GET_EXPECTED_RUNTIME");
            vector.add("PRIORITY");
            vector.add("MIN_PRIORITY");
            vector.add("AGING_AMOUNT");
            vector.add("AGING_BASE");
            vector.add("SUBMIT_SUSPENDED");
            vector.add("MASTER_SUBMITTABLE");
            vector.add("SAME_NODE");
            vector.add("GANG_SCHEDULE");
            vector.add("DEPENDENCY_MODE");
            vector.add("ESP_NAME");
            vector.add("ESM_NAME");
            vector.add("ENV_NAME");
            vector.add("FP_NAME");
        }
        vector.add("SUBFOLDERS");
        vector.add("ENTITIES");
        vector.add("HAS_MSE");
        vector.add("PRIVS");
        vector.add("IDPATH");
        vector.add("HIT");
        return vector;
    }

    @Override
    public Vector fillVector(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, HashSet hashSet) throws SDMSException {
        Vector vector = new Vector();
        if (sDMSProxy instanceof SDMSFolder) {
            this.fillFVector(systemEnvironment, (SDMSFolder)sDMSProxy, vector);
        } else {
            this.fillSeVector(systemEnvironment, (SDMSSchedulingEntity)sDMSProxy, vector);
        }
        return vector;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object;
        if (this.expandIds != null) {
            for (Long l : new HashSet(this.expandIds)) {
                Long l2 = null;
                try {
                    SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l);
                    l2 = sDMSFolder.getParentId(systemEnvironment);
                }
                catch (NotFoundException notFoundException) {
                    try {
                        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
                        l2 = sDMSSchedulingEntity.getFolderId(systemEnvironment);
                    }
                    catch (NotFoundException notFoundException2) {
                        continue;
                    }
                }
                while (l2 != null && !this.expandIds.contains(l2)) {
                    this.expandIds.add(l2);
                    l2 = SDMSFolderTable.getObject(systemEnvironment, l2).getParentId(systemEnvironment);
                }
            }
        }
        this.fl = new FolderLister(this.path, this.expandIds);
        this.fl.setTitle(new SDMSMessage(systemEnvironment, "03201292009", "List of Folders"));
        this.fl.setFormatter(this);
        if (this.with != null && this.with.containsKey("FILTER")) {
            object = this.fl.objFilter.initialize_filter(systemEnvironment, (Vector)this.with.get("FILTER"), 0, true);
            this.fl.useFilter = true;
        }
        object = this.fl.list(systemEnvironment);
        this.result.setOutputContainer((SDMSOutputContainer)object);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201292008", "$1 Object(s) found", (Object)new Integer(((SDMSOutputContainer)object).lines)));
    }

    private Boolean checkMse(SystemEnvironment systemEnvironment, SDMSFolder sDMSFolder, HashMap hashMap) throws SDMSException {
        Object object;
        Long l = sDMSFolder.getId(systemEnvironment);
        Boolean bl = (Boolean)hashMap.get(l);
        if (bl != null) {
            return bl;
        }
        Vector<Constable> vector = new Vector<Constable>();
        vector.add(l);
        vector.add(Boolean.TRUE);
        Vector vector2 = SDMSSchedulingEntityTable.idx_folderId_masterSubmittable.getVector(systemEnvironment, vector);
        Iterator iterator = vector2.iterator();
        while (iterator.hasNext()) {
            object = (SDMSSchedulingEntity)iterator.next();
            if (((SDMSSchedulingEntityProxyGeneric)object).checkPrivileges(systemEnvironment, 0x100000L)) continue;
            iterator.remove();
        }
        if (vector2.size() > 0) {
            hashMap.put(l, Boolean.TRUE);
            return Boolean.TRUE;
        }
        object = SDMSFolderTable.idx_parentId.getVector(systemEnvironment, sDMSFolder.getId(systemEnvironment));
        Iterator iterator2 = ((Vector)object).iterator();
        while (iterator2.hasNext()) {
            SDMSFolder sDMSFolder2 = (SDMSFolder)iterator2.next();
            bl = this.checkMse(systemEnvironment, sDMSFolder2, hashMap);
            if (!bl.booleanValue()) continue;
            hashMap.put(l, Boolean.TRUE);
            return Boolean.TRUE;
        }
        hashMap.put(l, Boolean.FALSE);
        return Boolean.FALSE;
    }

    private void add_empties(Vector vector) {
        String string = "";
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
        vector.add(string);
    }

    private void fillFVector(SystemEnvironment systemEnvironment, SDMSFolder sDMSFolder, Vector vector) throws SDMSException {
        Serializable serializable;
        Long l = sDMSFolder.getId(systemEnvironment);
        vector.add(l);
        vector.add(sDMSFolder.pathVector(systemEnvironment));
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSFolder.getOwnerId(systemEnvironment));
        vector.add(sDMSGroup.getName(systemEnvironment));
        vector.add("FOLDER");
        if (!this.isCondensed) {
            this.add_empties(vector);
            serializable = sDMSFolder.getEnvId(systemEnvironment);
            if (serializable != null) {
                vector.add(SDMSNamedEnvironmentTable.getObject(systemEnvironment, (Long)serializable).getName(systemEnvironment));
            } else {
                vector.add(null);
            }
            vector.add(null);
        }
        serializable = SDMSFolderTable.idx_parentId.getVector(systemEnvironment, l);
        Vector vector2 = SDMSSchedulingEntityTable.idx_folderId.getVector(systemEnvironment, l);
        vector.add(new Integer(((Vector)serializable).size()));
        vector.add(new Integer(vector2.size()));
        vector.add(this.checkMse(systemEnvironment, sDMSFolder, this.mseCache));
        vector.add(sDMSFolder.getPrivileges(systemEnvironment).toString());
        vector.add(sDMSFolder.idPathVector(systemEnvironment));
        if (!this.fl.useFilter) {
            vector.add(Character.valueOf(' '));
        } else if (this.fl.objectsToList.contains(sDMSFolder)) {
            if (sDMSFolder.getId(systemEnvironment).equals(SDMSObject.systemFId)) {
                if (this.fl.checkValid(systemEnvironment, sDMSFolder)) {
                    vector.add(Character.valueOf('Y'));
                } else {
                    vector.add(Character.valueOf('N'));
                }
            } else {
                vector.add(Character.valueOf('Y'));
            }
        } else {
            vector.add(Character.valueOf('N'));
        }
    }

    private void fillSeVector(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, Vector vector) throws SDMSException {
        Long l = sDMSSchedulingEntity.getId(systemEnvironment);
        vector.add(l);
        vector.add(sDMSSchedulingEntity.pathVector(systemEnvironment));
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSSchedulingEntity.getOwnerId(systemEnvironment));
        vector.add(sDMSGroup.getName(systemEnvironment));
        vector.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
        if (!this.isCondensed) {
            vector.add(sDMSSchedulingEntity.getRunProgram(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getRerunProgram(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getKillProgram(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getWorkdir(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getLogfile(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getTruncLog(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getErrlogfile(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getTruncErrlog(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getExpectedRuntime(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getExpectedFinaltime(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getGetExpectedRuntime(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getPriority(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getMinPriority(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getAgingAmount(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getAgingBaseAsString(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getSubmitSuspended(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getMasterSubmittable(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getSameNode(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getGangSchedule(systemEnvironment));
            vector.add(sDMSSchedulingEntity.getDependencyOperationAsString(systemEnvironment));
            Long l2 = sDMSSchedulingEntity.getEspId(systemEnvironment);
            SDMSExitStateProfile sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l2);
            vector.add(sDMSExitStateProfile.getName(systemEnvironment));
            Long l3 = sDMSSchedulingEntity.getEsmpId(systemEnvironment);
            if (l3 != null) {
                SDMSExitStateMappingProfile sDMSExitStateMappingProfile = SDMSExitStateMappingProfileTable.getObject(systemEnvironment, l3);
                vector.add(sDMSExitStateMappingProfile.getName(systemEnvironment));
            } else {
                vector.add("<default>");
            }
            Long l4 = sDMSSchedulingEntity.getNeId(systemEnvironment);
            if (l4 != null) {
                SDMSNamedEnvironment sDMSNamedEnvironment = SDMSNamedEnvironmentTable.getObject(systemEnvironment, l4);
                vector.add(sDMSNamedEnvironment.getName(systemEnvironment));
            } else {
                vector.add("<null>");
            }
            Long l5 = sDMSSchedulingEntity.getFpId(systemEnvironment);
            if (l5 != null) {
                SDMSFootprint sDMSFootprint = SDMSFootprintTable.getObject(systemEnvironment, l5);
                vector.add(sDMSFootprint.getName(systemEnvironment));
            } else {
                vector.add("<null>");
            }
        }
        vector.add(new Integer(0));
        Vector vector2 = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, l);
        Integer n = new Integer(vector2.size());
        vector.add(n);
        vector.add("");
        vector.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment).toString());
        vector.add(sDMSSchedulingEntity.idPathVector(systemEnvironment));
        if (!this.fl.useFilter) {
            vector.add(Character.valueOf(' '));
        } else if (this.fl.objectsToList.contains(sDMSSchedulingEntity)) {
            vector.add(Character.valueOf('Y'));
        } else {
            vector.add(Character.valueOf('N'));
        }
    }
}

