/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.timer.TimerUnit;
import de.independit.scheduler.server.util.DateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class ListInterval
extends Node {
    public static final String __version = "@(#) $Id: ListInterval.java,v 2.8.2.2 2013/06/18 09:49:33 ronald Exp $";
    private static final String empty = "";
    private boolean all;

    public ListInterval(boolean bl) {
        this.txMode = 1;
        this.auditFlag = false;
        this.all = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = null;
        SDMSInterval sDMSInterval = null;
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("STARTTIME");
        vector.add("ENDTIME");
        vector.add("BASE");
        vector.add("DURATION");
        vector.add("SYNCTIME");
        vector.add("INVERSE");
        vector.add("EMBEDDED");
        vector.add("OBJ_TYPE");
        vector.add("OBJ_ID");
        vector.add("PRIVS");
        vector.add("SE_ID");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of Intervals", vector);
        Iterator iterator = SDMSIntervalTable.table.iterator(systemEnvironment);
        while (iterator.hasNext()) {
            sDMSInterval = (SDMSInterval)iterator.next();
            l = sDMSInterval.getObjId(systemEnvironment);
            if (!this.all && l != null) continue;
            Vector<Object> vector2 = new Vector<Object>();
            vector2.add(sDMSInterval.getId(systemEnvironment));
            vector2.add(sDMSInterval.getName(systemEnvironment));
            Long l2 = sDMSInterval.getOwnerId(systemEnvironment);
            SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l2);
            vector2.add(sDMSGroup.getName(systemEnvironment));
            Long l3 = sDMSInterval.getStartTime(systemEnvironment);
            if (l3 == null) {
                vector2.add(empty);
            } else {
                vector2.add(new DateTime(l3, false).toString(null));
            }
            Long l4 = sDMSInterval.getEndTime(systemEnvironment);
            if (l4 == null) {
                vector2.add(empty);
            } else {
                vector2.add(new DateTime(l4, false).toString(null));
            }
            TimerUnit timerUnit = new TimerUnit(sDMSInterval.getBaseIntervalMultiplier(systemEnvironment), sDMSInterval.getBaseInterval(systemEnvironment));
            if (timerUnit.isINF()) {
                vector2.add(empty);
            } else {
                vector2.add(timerUnit.asString());
            }
            TimerUnit timerUnit2 = new TimerUnit(sDMSInterval.getDurationMultiplier(systemEnvironment), sDMSInterval.getDuration(systemEnvironment));
            if (timerUnit2.isINF()) {
                vector2.add(empty);
            } else {
                vector2.add(timerUnit2.asString());
            }
            vector2.add(new DateTime(sDMSInterval.getSyncTime(systemEnvironment), false).toString(null));
            vector2.add(sDMSInterval.getIsInverse(systemEnvironment));
            Long l5 = sDMSInterval.getEmbeddedIntervalId(systemEnvironment);
            if (l5 == null) {
                vector2.add(empty);
            } else {
                SDMSInterval sDMSInterval2 = SDMSIntervalTable.getObject(systemEnvironment, l5);
                vector2.add(sDMSInterval2.getName(systemEnvironment));
            }
            vector2.add(sDMSInterval.getObjTypeAsString(systemEnvironment));
            vector2.add(l);
            vector2.add(sDMSInterval.getPrivileges(systemEnvironment).toString());
            vector2.add(sDMSInterval.getSeId(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207192158", "$1 Interval(s) found", (Object)new Integer(sDMSOutputContainer.lines)));
    }
}

