/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.ConnectionEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.Parser;
import de.independit.scheduler.server.parser.SyntaxError;
import java.io.PrintStream;

public class SDMSParser
extends Parser {
    public static final String __version = "@(#) $Id: SDMSParser.java,v 2.7.2.1 2013/03/14 10:24:47 ronald Exp $";
    PrintStream ostream;
    ConnectionEnvironment env;
    SDMSOutput msgBuffer = new SDMSOutput();
    boolean stmtInError = false;
    String errmsg;
    String[] errexp;

    public SDMSParser(PrintStream printStream, ConnectionEnvironment connectionEnvironment) {
        this.ostream = printStream;
        this.env = connectionEnvironment;
    }

    @Override
    public ConnectionEnvironment getConnectionEnvironment() {
        return this.env;
    }

    @Override
    protected boolean post(Node node) throws FatalException {
        if (this.stmtInError) {
            this.stmtInError = false;
            node = this.createError();
        } else if (node.cmdtype != 7) {
            if (this.env.isUser() && (node.cmdtype & 1) == 0) {
                this.errexp = new String[1];
                this.errexp[0] = "a user command";
                node = this.createError();
            } else if (this.env.isJobServer() && (node.cmdtype & 2) == 0) {
                this.errexp = new String[1];
                this.errexp[0] = "a jobserver command";
                node = this.createError();
            } else if (this.env.isJob() && (node.cmdtype & 4) == 0) {
                this.errexp = new String[1];
                this.errexp[0] = "a job command";
                node = this.createError();
            }
        }
        node.setEnv(this.env);
        this.env.setLast();
        this.env.setState(1);
        this.env.firstToken = null;
        if (node.txMode == 2) {
            this.env.cmdQueue().post(node);
        } else {
            this.env.roCmdQueue().post(node);
        }
        this.env.lock().do_wait();
        this.env.setState(6);
        node.render(this.ostream);
        this.env.setLast();
        this.env.setState(0);
        this.env.actstmt = null;
        return node.result.error == null;
    }

    protected Node createError() throws FatalException {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.errexp != null) {
            for (int i = 0; i < this.errexp.length - 1; ++i) {
                stringBuffer.append(this.errexp[i] + ",\n");
            }
            stringBuffer.append(this.errexp[this.errexp.length - 1]);
        }
        SyntaxError syntaxError = this.errmsg == null || this.errmsg.equals("syntax error") ? new SyntaxError(stringBuffer.toString()) : new SyntaxError(this.errmsg, stringBuffer.toString());
        return syntaxError;
    }

    @Override
    public void yyerror(String string, String[] stringArray) {
        System.out.println(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("\t" + stringArray[i]);
            }
        }
        if (this.stmtInError) {
            return;
        }
        this.stmtInError = true;
        this.env.proto_input("+++++");
        this.errmsg = string;
        this.errexp = stringArray;
    }

    @Override
    protected String[] yyExpecting(int n) {
        String[] stringArray = super.yyExpecting(n);
        if (stringArray.length > 35) {
            stringArray = new String[]{"valid identifier"};
        }
        return stringArray;
    }
}

