/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSObjectComment;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Date;
import java.util.Vector;

public class ShowComment
extends Node {
    public static final String __version = "@(#) $Id: ShowComment.java,v 2.4.14.2 2013/06/18 09:49:35 ronald Exp $";
    private int type;
    private ObjectURL obj;

    public ShowComment(ObjectURL objectURL) {
        this.obj = objectURL;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        Date date = new Date();
        vector.add("ID");
        vector.add("TAG");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        Object var5_4 = null;
        this.obj.resolve(systemEnvironment);
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Comment", vector);
        Vector vector2 = SDMSObjectCommentTable.idx_objectId_getSortedVector(systemEnvironment, this.obj.objId);
        for (int i = 0; i < vector2.size(); ++i) {
            Vector<Object> vector3 = new Vector<Object>();
            SDMSObjectComment sDMSObjectComment = (SDMSObjectComment)vector2.get(i);
            vector3.add(sDMSObjectComment.getId(systemEnvironment));
            vector3.add(sDMSObjectComment.getTag(systemEnvironment));
            vector3.add(sDMSObjectComment.getDescription(systemEnvironment));
            vector3.add(sDMSObjectComment.getInfoTypeAsString(systemEnvironment));
            try {
                vector3.add(SDMSUserTable.getObject(systemEnvironment, sDMSObjectComment.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                vector3.add("unknown");
            }
            date.setTime(sDMSObjectComment.getCreateTs(systemEnvironment));
            vector3.add(systemEnvironment.systemDateFormat.format(date));
            try {
                vector3.add(SDMSUserTable.getObject(systemEnvironment, sDMSObjectComment.getChangerUId(systemEnvironment)).getName(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                vector3.add("unknown");
            }
            date.setTime(sDMSObjectComment.getChangeTs(systemEnvironment));
            vector3.add(systemEnvironment.systemDateFormat.format(date));
            vector3.add(sDMSObjectComment.getPrivileges(systemEnvironment).toString());
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03602161459", "Comment shown"));
    }
}

