/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMember;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserEquiv;
import de.independit.scheduler.server.repository.SDMSUserEquivTable;
import de.independit.scheduler.server.repository.SDMSUserParameter;
import de.independit.scheduler.server.repository.SDMSUserParameterTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;

public class ShowUser
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowUser.java,v 2.9.4.2 2013/06/18 09:49:38 ronald Exp $";
    private static final Long ZERO = new Long(0L);
    private static final String USR = "user";
    private static final String GRP = "group";
    private static final String ESD = "exit state definition";
    private static final String ESP = "exit state profile";
    private static final String ESM = "exit state mapping";
    private static final String EST = "exit state translation";
    private static final String RSD = "resource state definition";
    private static final String RSP = "resource state profile";
    private static final String RSM = "resource state mapping";
    private static final String FPR = "footprint";
    private static final String ENV = "environment";
    private static final String SYS = "system";
    private static final String NP = "nice profile";
    private static final String WT = "watch type";
    private static final String SEL = "select";
    private String name;

    public ShowUser(String string) {
        this.name = string;
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Object var4_3 = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Date date = new Date();
        SDMSUser sDMSUser = this.name == null ? SDMSUserTable.getObject(systemEnvironment, this.env.uid()) : SDMSUserTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.name), new Long(0L)));
        if (sDMSUser.getDeleteVersion(systemEnvironment) > 0L) {
            throw new NotFoundException("User " + (this.name == null ? "" : this.name + " ") + " not found");
        }
        if (!sDMSUser.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411728", "Insufficient privileges"));
        }
        Long l = sDMSUser.getId(systemEnvironment);
        vector.add("ID");
        vector.add("NAME");
        vector.add("IS_ENABLED");
        vector.add("DEFAULT_GROUP");
        vector.add("CONNECTION_TYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("MANAGE_PRIVS");
        vector.add("GROUPS");
        vector.add("EQUIVALENT_USERS");
        vector.add("PARAMETERS");
        vector.add("COMMENTTYPE");
        vector.add("COMMENT");
        vector2.add("TAG");
        vector2.add("COMMENT");
        Vector<Object> vector3 = new Vector<Object>();
        vector3.add(l);
        vector3.add(sDMSUser.getName(systemEnvironment));
        vector3.add(sDMSUser.getIsEnabled(systemEnvironment));
        vector3.add(SDMSGroupTable.getObject(systemEnvironment, sDMSUser.getDefaultGId(systemEnvironment)).getName(systemEnvironment));
        vector3.add(sDMSUser.getConnectionTypeAsString(systemEnvironment));
        try {
            vector3.add(SDMSUserTable.getObject(systemEnvironment, sDMSUser.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector3.add("unknown");
        }
        date.setTime(sDMSUser.getCreateTs(systemEnvironment));
        vector3.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector3.add(SDMSUserTable.getObject(systemEnvironment, sDMSUser.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector3.add("unknown");
        }
        date.setTime(sDMSUser.getChangeTs(systemEnvironment));
        vector3.add(systemEnvironment.systemDateFormat.format(date));
        vector3.add(sDMSUser.getPrivileges(systemEnvironment).toString());
        vector3.add(this.getManageList(systemEnvironment, l));
        vector3.add(this.getGroupList(systemEnvironment, l));
        vector3.add(this.getEquivUserList(systemEnvironment, l));
        vector3.add(ShowUser.getParms(systemEnvironment, l));
        vector3.add(this.getCommentInfoType(systemEnvironment, l));
        vector3.add(this.getCommentContainer(systemEnvironment, l));
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "User", vector, vector3);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03112141435", "User shown"));
    }

    private SDMSOutputContainer getGroupList(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>(2);
        vector.add("ID");
        vector.add("NAME");
        vector.add("PRIVS");
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "GROUPS", vector);
        Vector vector2 = SDMSMemberTable.idx_uId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSMember sDMSMember = (SDMSMember)vector2.get(i);
            SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSMember.getGId(systemEnvironment));
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSGroup.getId(systemEnvironment));
            vector3.add(sDMSGroup.getName(systemEnvironment));
            vector3.add(sDMSGroup.getPrivileges(systemEnvironment).toString());
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer getEquivUserList(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>(2);
        vector.add("TYPE");
        vector.add("EQUIVALENT_USER");
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "EQUIVALENT_USERS", vector);
        Vector vector2 = SDMSUserEquivTable.idx_uId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSUserEquiv sDMSUserEquiv = (SDMSUserEquiv)vector2.get(i);
            Vector<String> vector3 = new Vector<String>();
            vector3.add(sDMSUserEquiv.getAltTypeAsString(systemEnvironment));
            if (sDMSUserEquiv.getAltType(systemEnvironment) == 0) {
                SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, sDMSUserEquiv.getAltUId(systemEnvironment));
                vector3.add(sDMSUser.getName(systemEnvironment));
            } else {
                SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, sDMSUserEquiv.getAltUId(systemEnvironment));
                vector3.add(sDMSScope.pathString(systemEnvironment));
            }
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer getManageList(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>(2);
        vector.add("PRIVS");
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "MANAGE_PRIVS", vector);
        SDMSPrivilege sDMSPrivilege = new SDMSPrivilege();
        Vector<String> vector2 = SDMSMemberTable.idx_uId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSMember sDMSMember = (SDMSMember)vector2.get(i);
            try {
                SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(ZERO, sDMSMember.getGId(systemEnvironment)));
                sDMSPrivilege.addPriv(systemEnvironment, sDMSGrant.getPrivs(systemEnvironment));
                continue;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        long l2 = sDMSPrivilege.toLong();
        if ((0xFFFC00000000L & l2) != 0L) {
            vector2 = new Vector<String>();
            if ((0x400000000L & l2) == 0x400000000L) {
                vector2.add(USR);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x800000000L & l2) == 0x800000000L) {
                vector2.add(GRP);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x1000000000L & l2) == 0x1000000000L) {
                vector2.add(ESD);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x2000000000L & l2) == 0x2000000000L) {
                vector2.add(ESP);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x4000000000L & l2) == 0x4000000000L) {
                vector2.add(ESM);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x8000000000L & l2) == 0x8000000000L) {
                vector2.add(EST);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x10000000000L & l2) == 0x10000000000L) {
                vector2.add(RSD);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x20000000000L & l2) == 0x20000000000L) {
                vector2.add(RSP);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x40000000000L & l2) == 0x40000000000L) {
                vector2.add(RSM);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x80000000000L & l2) == 0x80000000000L) {
                vector2.add(FPR);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x100000000000L & l2) == 0x100000000000L) {
                vector2.add(ENV);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x200000000000L & l2) == 0x200000000000L) {
                vector2.add(SYS);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x800000000000L & l2) == 0x800000000000L) {
                vector2.add(NP);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x1000000000000L & l2) == 0x1000000000000L) {
                vector2.add(WT);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x400000000000L & l2) == 0x400000000000L) {
                vector2.add(SEL);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
            }
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 0));
        return sDMSOutputContainer;
    }

    public static final SDMSOutputContainer getParms(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("VALUE");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector);
        Vector vector2 = SDMSUserParameterTable.idx_uId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSUserParameter sDMSUserParameter = (SDMSUserParameter)vector2.get(i);
            Vector<Object> vector3 = new Vector<Object>();
            Long l2 = sDMSUserParameter.getId(systemEnvironment);
            vector3.add(l2);
            vector3.add(sDMSUserParameter.getName(systemEnvironment));
            vector3.add(sDMSUserParameter.getValue(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }
}

