/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.SDMSWatchType;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameter;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameterTable;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;

public class ShowWt
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowWt.java,v 2.1.4.4 2013/06/18 09:49:39 ronald Exp $";
    ObjectURL url;

    public ShowWt(ObjectURL objectURL) {
        this.txMode = 1;
        this.auditFlag = false;
        this.url = objectURL;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        systemEnvironment.checkFeatureAvailability("OBJECT_MONITOR");
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        SDMSWatchType sDMSWatchType = (SDMSWatchType)this.url.resolve(systemEnvironment);
        if (!sDMSWatchType.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "02108241010", "Insufficient privileges"));
        }
        Long l = sDMSWatchType.getId(systemEnvironment);
        vector.add("ID");
        vector.add("NAME");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("PARAMETERS");
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSWatchType.getName(systemEnvironment));
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSWatchType.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSWatchType.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSWatchType.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSWatchType.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSWatchType.getPrivileges(systemEnvironment).toString());
        Vector<String> vector3 = new Vector<String>();
        vector3.add("ID");
        vector3.add("NAME");
        vector3.add("DEFAULT_VALUE");
        vector3.add("TYPE");
        vector3.add("IS_SUBMIT_PAR");
        vector3.add("PRIVS");
        SDMSOutputContainer sDMSOutputContainer2 = new SDMSOutputContainer(systemEnvironment, null, vector3);
        Vector vector4 = SDMSWatchTypeParameterTable.idx_wtId.getVector(systemEnvironment, l);
        for (SDMSWatchTypeParameter sDMSWatchTypeParameter : vector4) {
            Vector<Object> vector5 = new Vector<Object>();
            vector5.add(sDMSWatchTypeParameter.getId(systemEnvironment));
            vector5.add(sDMSWatchTypeParameter.getName(systemEnvironment));
            String string = sDMSWatchTypeParameter.getDefaultValue(systemEnvironment);
            if (string != null) {
                string = string.substring(1);
            }
            vector5.add(string);
            vector5.add(sDMSWatchTypeParameter.getTypeAsString(systemEnvironment));
            vector5.add(sDMSWatchTypeParameter.getIsSubmitPar(systemEnvironment));
            vector5.add(sDMSWatchTypeParameter.getPrivileges(systemEnvironment).toString());
            sDMSOutputContainer2.addData(systemEnvironment, vector5);
        }
        Collections.sort(sDMSOutputContainer2.dataset, sDMSOutputContainer2.getComparator(systemEnvironment, 1));
        vector2.add(sDMSOutputContainer2);
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "02108241021", "Watch Type"), vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "02108241022", "Watch Type shown"));
    }
}

