/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSCalendar;
import de.independit.scheduler.server.repository.SDMSCalendarGeneric;
import de.independit.scheduler.server.repository.SDMSCalendarTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSCalendarTableGeneric
extends SDMSTable {
    public static final String tableName = "CALENDAR";
    public static SDMSCalendarTable table = null;
    public static final String[] columnNames = new String[]{"ID", "SCEV_ID", "STARTTIME", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_scevId;
    public static SDMSIndex idx_scevId_starttime;

    public SDMSCalendarTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Calendar"));
        }
        table = (SDMSCalendarTable)this;
        table = (SDMSCalendarTable)this;
        this.isVersioned = false;
        idx_scevId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "scevId");
        idx_scevId_starttime = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "scevId_starttime");
    }

    public SDMSCalendar create(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSCalendar sDMSCalendar;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Calendar"));
        }
        this.validate(systemEnvironment, l, l2, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSCalendarGeneric sDMSCalendarGeneric = new SDMSCalendarGeneric(systemEnvironment, l, l2, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSCalendarGeneric.versions, true);
            table.put(systemEnvironment, sDMSCalendarGeneric.id, sDMSCalendarGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSCalendar = (SDMSCalendar)sDMSCalendarGeneric.toProxy(systemEnvironment);
            sDMSCalendar.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSCalendar sDMSCalendar2 = (SDMSCalendar)sDMSCalendarGeneric.toProxy(systemEnvironment);
            sDMSCalendar2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSCalendar)) {
            throw new AccessViolationException(sDMSCalendar.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSCalendar.touchMaster(systemEnvironment);
        return sDMSCalendar;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSCalendar sDMSCalendar) throws SDMSException {
        return sDMSCalendar.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Long l9;
        try {
            l9 = new Long(resultSet.getLong(1));
            l8 = new Long(resultSet.getLong(2));
            l7 = new Long(resultSet.getLong(3));
            l6 = new Long(resultSet.getLong(4));
            l5 = new Long(resultSet.getLong(5));
            l4 = new Long(resultSet.getLong(6));
            l3 = new Long(resultSet.getLong(7));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Calendar: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSCalendarGeneric(l9, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "SCEV_ID" + string2 + ", " + string + "STARTTIME" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_scevId.check(((SDMSCalendarGeneric)sDMSObject).scevId, sDMSObject);
        string = string + "idx_scevId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSCalendarGeneric)sDMSObject).scevId);
        sDMSKey.add(((SDMSCalendarGeneric)sDMSObject).starttime);
        bl = idx_scevId_starttime.check(sDMSKey, sDMSObject);
        string = string + "idx_scevId_starttime: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_scevId.put(systemEnvironment, ((SDMSCalendarGeneric)sDMSObject).scevId, sDMSObject, (1L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSCalendarGeneric)sDMSObject).scevId);
        sDMSKey.add(((SDMSCalendarGeneric)sDMSObject).starttime);
        idx_scevId_starttime.put(systemEnvironment, sDMSKey, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_scevId.remove(systemEnvironment, ((SDMSCalendarGeneric)sDMSObject).scevId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSCalendarGeneric)sDMSObject).scevId);
        sDMSKey.add(((SDMSCalendarGeneric)sDMSObject).starttime);
        idx_scevId_starttime.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSCalendar getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSCalendar)table.get(systemEnvironment, l);
    }

    public static SDMSCalendar getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSCalendar)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSCalendar getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSCalendar)table.get(systemEnvironment, l, l2);
    }

    public static SDMSCalendar idx_scevId_starttime_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSCalendar)idx_scevId_starttime.getUnique(systemEnvironment, object);
    }

    public static SDMSCalendar idx_scevId_starttime_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSCalendar)idx_scevId_starttime.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSCalendar idx_scevId_starttime_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSCalendar)idx_scevId_starttime.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

