/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSExtents;
import de.independit.scheduler.server.repository.SDMSExtentsTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSExtentsGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_oId = 2;
    public static final int nr_smeId = 3;
    public static final int nr_sequence = 4;
    public static final int nr_extent = 5;
    public static final int nr_creatorUId = 6;
    public static final int nr_createTs = 7;
    public static final int nr_changerUId = 8;
    public static final int nr_changeTs = 9;
    public static String tableName = "EXTENTS";
    protected Long oId;
    protected Long smeId;
    protected Integer sequence;
    protected String extent;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSExtentsGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, String string, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSExtentsTableGeneric.table);
        this.oId = l;
        this.smeId = l2;
        this.sequence = n;
        if (string != null && string.length() > 256) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Extents) Length of $1 exceeds maximum length $2", (Object)"extent", (Object)"256"));
        }
        this.extent = string;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public Long getOId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.oId;
    }

    public void setOId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.oId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Extents) Change of system object not allowed"));
            }
            SDMSExtentsGeneric sDMSExtentsGeneric = (SDMSExtentsGeneric)this.change(systemEnvironment);
            sDMSExtentsGeneric.oId = l;
            sDMSExtentsGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSExtentsGeneric.changeTs = systemEnvironment.txTime();
            sDMSExtentsGeneric.versions.table.index(systemEnvironment, sDMSExtentsGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getSmeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.smeId;
    }

    public void setSmeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.smeId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Extents) Change of system object not allowed"));
            }
            SDMSExtentsGeneric sDMSExtentsGeneric = (SDMSExtentsGeneric)this.change(systemEnvironment);
            sDMSExtentsGeneric.smeId = l;
            sDMSExtentsGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSExtentsGeneric.changeTs = systemEnvironment.txTime();
            sDMSExtentsGeneric.versions.table.index(systemEnvironment, sDMSExtentsGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getSequence(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.sequence;
    }

    public void setSequence(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.sequence.equals(n)) {
            return;
        }
        SDMSExtentsGeneric sDMSExtentsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Extents) Change of system object not allowed"));
        }
        if (sDMSExtentsGeneric.versions.o_v == null || sDMSExtentsGeneric.versions.o_v.size() == 0 || sDMSExtentsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExtentsGeneric = (SDMSExtentsGeneric)this.change(systemEnvironment);
        }
        sDMSExtentsGeneric.sequence = n;
        sDMSExtentsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExtentsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExtentsGeneric != this) {
            sDMSExtentsGeneric.versions.table.index(systemEnvironment, sDMSExtentsGeneric, 0L);
        }
    }

    public String getExtent(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.extent;
    }

    public void setExtent(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.extent.equals(string)) {
            return;
        }
        SDMSExtentsGeneric sDMSExtentsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Extents) Change of system object not allowed"));
        }
        if (sDMSExtentsGeneric.versions.o_v == null || sDMSExtentsGeneric.versions.o_v.size() == 0 || sDMSExtentsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExtentsGeneric = (SDMSExtentsGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 256) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Extents) Length of $1 exceeds maximum length $2", (Object)"extent", (Object)"256"));
        }
        sDMSExtentsGeneric.extent = string;
        sDMSExtentsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExtentsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExtentsGeneric != this) {
            sDMSExtentsGeneric.versions.table.index(systemEnvironment, sDMSExtentsGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSExtentsGeneric sDMSExtentsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Extents) Change of system object not allowed"));
        }
        if (sDMSExtentsGeneric.versions.o_v == null || sDMSExtentsGeneric.versions.o_v.size() == 0 || sDMSExtentsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExtentsGeneric = (SDMSExtentsGeneric)this.change(systemEnvironment);
        }
        sDMSExtentsGeneric.creatorUId = l;
        sDMSExtentsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExtentsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExtentsGeneric != this) {
            sDMSExtentsGeneric.versions.table.index(systemEnvironment, sDMSExtentsGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSExtentsGeneric sDMSExtentsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Extents) Change of system object not allowed"));
        }
        if (sDMSExtentsGeneric.versions.o_v == null || sDMSExtentsGeneric.versions.o_v.size() == 0 || sDMSExtentsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExtentsGeneric = (SDMSExtentsGeneric)this.change(systemEnvironment);
        }
        sDMSExtentsGeneric.createTs = l;
        sDMSExtentsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExtentsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExtentsGeneric != this) {
            sDMSExtentsGeneric.versions.table.index(systemEnvironment, sDMSExtentsGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSExtentsGeneric sDMSExtentsGeneric = this;
        if (sDMSExtentsGeneric.versions.o_v == null || sDMSExtentsGeneric.versions.o_v.size() == 0 || sDMSExtentsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExtentsGeneric = (SDMSExtentsGeneric)this.change(systemEnvironment);
        }
        sDMSExtentsGeneric.changerUId = l;
        sDMSExtentsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExtentsGeneric != this) {
            sDMSExtentsGeneric.versions.table.index(systemEnvironment, sDMSExtentsGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSExtentsGeneric sDMSExtentsGeneric = this;
        if (sDMSExtentsGeneric.versions.o_v == null || sDMSExtentsGeneric.versions.o_v.size() == 0 || sDMSExtentsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExtentsGeneric = (SDMSExtentsGeneric)this.change(systemEnvironment);
        }
        sDMSExtentsGeneric.changeTs = l;
        sDMSExtentsGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSExtentsGeneric != this) {
            sDMSExtentsGeneric.versions.table.index(systemEnvironment, sDMSExtentsGeneric, 0L);
        }
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSExtents(this);
    }

    protected SDMSExtentsGeneric(Long l, Long l2, Long l3, Integer n, String string, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.oId = l2;
        this.smeId = l3;
        this.sequence = n;
        this.extent = string;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "EXTENTS" + string3 + " (ID, " + string2 + "O_ID" + string3 + ", " + string2 + "SME_ID" + string3 + ", " + string2 + "SEQUENCE" + string3 + ", " + string2 + "EXTENT" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSExtentsGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "Extents: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.oId);
            preparedStatement.setLong(3, this.smeId);
            preparedStatement.setInt(4, this.sequence);
            preparedStatement.setString(5, this.extent);
            preparedStatement.setLong(6, this.creatorUId);
            preparedStatement.setLong(7, this.createTs);
            preparedStatement.setLong(8, this.changerUId);
            preparedStatement.setLong(9, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "Extents: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "EXTENTS" + string3 + " WHERE ID = ?";
                SDMSExtentsGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "Extents: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "Extents: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "EXTENTS" + string3 + " SET " + string2 + "O_ID" + string3 + " = ? , " + string2 + "SME_ID" + string3 + " = ? , " + string2 + "SEQUENCE" + string3 + " = ? , " + string2 + "EXTENT" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? WHERE ID = ?";
                SDMSExtentsGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "Extents: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.oId);
            preparedStatement.setLong(2, this.smeId);
            preparedStatement.setInt(3, this.sequence);
            preparedStatement.setString(4, this.extent);
            preparedStatement.setLong(5, this.creatorUId);
            preparedStatement.setLong(6, this.createTs);
            preparedStatement.setLong(7, this.changerUId);
            preparedStatement.setLong(8, this.changeTs);
            preparedStatement.setLong(9, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "Extents: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : Extents", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "oId : " + this.oId, 2);
        SDMSThread.doTrace(null, "smeId : " + this.smeId, 2);
        SDMSThread.doTrace(null, "sequence : " + this.sequence, 2);
        SDMSThread.doTrace(null, "extent : " + this.extent, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "oId        : " + this.oId + "\n" + string + "smeId      : " + this.smeId + "\n" + string + "sequence   : " + this.sequence + "\n" + string + "extent     : " + this.extent + "\n" + string + "creatorUId : " + this.creatorUId + "\n" + string + "createTs   : " + this.createTs + "\n" + string + "changerUId : " + this.changerUId + "\n" + string + "changeTs   : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

