/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntry;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntryTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSNiceProfileEntryGeneric
extends SDMSObject
implements Cloneable {
    public static final int NOSUSPEND = 0;
    public static final int SUSPEND = 1;
    public static final int ADMINSUSPEND = 2;
    public static final int nr_id = 1;
    public static final int nr_npId = 2;
    public static final int nr_preference = 3;
    public static final int nr_folderId = 4;
    public static final int nr_isSuspended = 5;
    public static final int nr_renice = 6;
    public static final int nr_isActive = 7;
    public static final int nr_creatorUId = 8;
    public static final int nr_createTs = 9;
    public static final int nr_changerUId = 10;
    public static final int nr_changeTs = 11;
    public static String tableName = "NICE_PROFILE_ENTRY";
    protected Long npId;
    protected Integer preference;
    protected Long folderId;
    protected Integer isSuspended;
    protected Integer renice;
    protected Boolean isActive;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSNiceProfileEntryGeneric(SystemEnvironment systemEnvironment, Long l, Integer n, Long l2, Integer n2, Integer n3, Boolean bl, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSNiceProfileEntryTableGeneric.table);
        this.npId = l;
        this.preference = n;
        this.folderId = l2;
        this.isSuspended = n2;
        this.renice = n3;
        this.isActive = bl;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public Long getNpId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.npId;
    }

    public void setNpId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.npId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NiceProfileEntry) Change of system object not allowed"));
            }
            SDMSNiceProfileEntryGeneric sDMSNiceProfileEntryGeneric = (SDMSNiceProfileEntryGeneric)this.change(systemEnvironment);
            sDMSNiceProfileEntryGeneric.npId = l;
            sDMSNiceProfileEntryGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSNiceProfileEntryGeneric.changeTs = systemEnvironment.txTime();
            sDMSNiceProfileEntryGeneric.versions.table.index(systemEnvironment, sDMSNiceProfileEntryGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getPreference(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.preference;
    }

    public void setPreference(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.preference.equals(n)) {
            return;
        }
        SDMSNiceProfileEntryGeneric sDMSNiceProfileEntryGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NiceProfileEntry) Change of system object not allowed"));
        }
        if (sDMSNiceProfileEntryGeneric.versions.o_v == null || sDMSNiceProfileEntryGeneric.versions.o_v.size() == 0 || sDMSNiceProfileEntryGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNiceProfileEntryGeneric = (SDMSNiceProfileEntryGeneric)this.change(systemEnvironment);
        }
        sDMSNiceProfileEntryGeneric.preference = n;
        sDMSNiceProfileEntryGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSNiceProfileEntryGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNiceProfileEntryGeneric != this) {
            sDMSNiceProfileEntryGeneric.versions.table.index(systemEnvironment, sDMSNiceProfileEntryGeneric, 0L);
        }
    }

    public Long getFolderId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.folderId;
    }

    public void setFolderId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.folderId)) {
            return;
        }
        if (l == null && this.folderId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NiceProfileEntry) Change of system object not allowed"));
            }
            SDMSNiceProfileEntryGeneric sDMSNiceProfileEntryGeneric = (SDMSNiceProfileEntryGeneric)this.change(systemEnvironment);
            sDMSNiceProfileEntryGeneric.folderId = l;
            sDMSNiceProfileEntryGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSNiceProfileEntryGeneric.changeTs = systemEnvironment.txTime();
            sDMSNiceProfileEntryGeneric.versions.table.index(systemEnvironment, sDMSNiceProfileEntryGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getIsSuspended(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isSuspended;
    }

    public String getIsSuspendedAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getIsSuspended(systemEnvironment);
        switch (n) {
            case 0: {
                return "NOSUSPEND";
            }
            case 1: {
                return "SUSPEND";
            }
            case 2: {
                return "ADMINSUSPEND";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown NiceProfileEntry.isSuspended: $1", (Object)this.getIsSuspended(systemEnvironment)));
    }

    public void setIsSuspended(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.isSuspended.equals(n)) {
            return;
        }
        SDMSNiceProfileEntryGeneric sDMSNiceProfileEntryGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NiceProfileEntry) Change of system object not allowed"));
        }
        if (sDMSNiceProfileEntryGeneric.versions.o_v == null || sDMSNiceProfileEntryGeneric.versions.o_v.size() == 0 || sDMSNiceProfileEntryGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNiceProfileEntryGeneric = (SDMSNiceProfileEntryGeneric)this.change(systemEnvironment);
        }
        sDMSNiceProfileEntryGeneric.isSuspended = n;
        sDMSNiceProfileEntryGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSNiceProfileEntryGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNiceProfileEntryGeneric != this) {
            sDMSNiceProfileEntryGeneric.versions.table.index(systemEnvironment, sDMSNiceProfileEntryGeneric, 0L);
        }
    }

    public Integer getRenice(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.renice;
    }

    public void setRenice(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.renice.equals(n)) {
            return;
        }
        SDMSNiceProfileEntryGeneric sDMSNiceProfileEntryGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NiceProfileEntry) Change of system object not allowed"));
        }
        if (sDMSNiceProfileEntryGeneric.versions.o_v == null || sDMSNiceProfileEntryGeneric.versions.o_v.size() == 0 || sDMSNiceProfileEntryGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNiceProfileEntryGeneric = (SDMSNiceProfileEntryGeneric)this.change(systemEnvironment);
        }
        sDMSNiceProfileEntryGeneric.renice = n;
        sDMSNiceProfileEntryGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSNiceProfileEntryGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNiceProfileEntryGeneric != this) {
            sDMSNiceProfileEntryGeneric.versions.table.index(systemEnvironment, sDMSNiceProfileEntryGeneric, 0L);
        }
    }

    public Boolean getIsActive(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isActive;
    }

    public void setIsActive(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isActive.equals(bl)) {
            return;
        }
        SDMSNiceProfileEntryGeneric sDMSNiceProfileEntryGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NiceProfileEntry) Change of system object not allowed"));
        }
        if (sDMSNiceProfileEntryGeneric.versions.o_v == null || sDMSNiceProfileEntryGeneric.versions.o_v.size() == 0 || sDMSNiceProfileEntryGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNiceProfileEntryGeneric = (SDMSNiceProfileEntryGeneric)this.change(systemEnvironment);
        }
        sDMSNiceProfileEntryGeneric.isActive = bl;
        sDMSNiceProfileEntryGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSNiceProfileEntryGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNiceProfileEntryGeneric != this) {
            sDMSNiceProfileEntryGeneric.versions.table.index(systemEnvironment, sDMSNiceProfileEntryGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSNiceProfileEntryGeneric sDMSNiceProfileEntryGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NiceProfileEntry) Change of system object not allowed"));
        }
        if (sDMSNiceProfileEntryGeneric.versions.o_v == null || sDMSNiceProfileEntryGeneric.versions.o_v.size() == 0 || sDMSNiceProfileEntryGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNiceProfileEntryGeneric = (SDMSNiceProfileEntryGeneric)this.change(systemEnvironment);
        }
        sDMSNiceProfileEntryGeneric.creatorUId = l;
        sDMSNiceProfileEntryGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSNiceProfileEntryGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNiceProfileEntryGeneric != this) {
            sDMSNiceProfileEntryGeneric.versions.table.index(systemEnvironment, sDMSNiceProfileEntryGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSNiceProfileEntryGeneric sDMSNiceProfileEntryGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NiceProfileEntry) Change of system object not allowed"));
        }
        if (sDMSNiceProfileEntryGeneric.versions.o_v == null || sDMSNiceProfileEntryGeneric.versions.o_v.size() == 0 || sDMSNiceProfileEntryGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNiceProfileEntryGeneric = (SDMSNiceProfileEntryGeneric)this.change(systemEnvironment);
        }
        sDMSNiceProfileEntryGeneric.createTs = l;
        sDMSNiceProfileEntryGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSNiceProfileEntryGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNiceProfileEntryGeneric != this) {
            sDMSNiceProfileEntryGeneric.versions.table.index(systemEnvironment, sDMSNiceProfileEntryGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSNiceProfileEntryGeneric sDMSNiceProfileEntryGeneric = this;
        if (sDMSNiceProfileEntryGeneric.versions.o_v == null || sDMSNiceProfileEntryGeneric.versions.o_v.size() == 0 || sDMSNiceProfileEntryGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNiceProfileEntryGeneric = (SDMSNiceProfileEntryGeneric)this.change(systemEnvironment);
        }
        sDMSNiceProfileEntryGeneric.changerUId = l;
        sDMSNiceProfileEntryGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNiceProfileEntryGeneric != this) {
            sDMSNiceProfileEntryGeneric.versions.table.index(systemEnvironment, sDMSNiceProfileEntryGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSNiceProfileEntryGeneric sDMSNiceProfileEntryGeneric = this;
        if (sDMSNiceProfileEntryGeneric.versions.o_v == null || sDMSNiceProfileEntryGeneric.versions.o_v.size() == 0 || sDMSNiceProfileEntryGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNiceProfileEntryGeneric = (SDMSNiceProfileEntryGeneric)this.change(systemEnvironment);
        }
        sDMSNiceProfileEntryGeneric.changeTs = l;
        sDMSNiceProfileEntryGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSNiceProfileEntryGeneric != this) {
            sDMSNiceProfileEntryGeneric.versions.table.index(systemEnvironment, sDMSNiceProfileEntryGeneric, 0L);
        }
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSNiceProfileEntry(this);
    }

    protected SDMSNiceProfileEntryGeneric(Long l, Long l2, Integer n, Long l3, Integer n2, Integer n3, Boolean bl, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.npId = l2;
        this.preference = n;
        this.folderId = l3;
        this.isSuspended = n2;
        this.renice = n3;
        this.isActive = bl;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "NICE_PROFILE_ENTRY" + string3 + " (ID, " + string2 + "NP_ID" + string3 + ", " + string2 + "PREFERENCE" + string3 + ", " + string2 + "FOLDER_ID" + string3 + ", " + string2 + "IS_SUSPENDED" + string3 + ", " + string2 + "RENICE" + string3 + ", " + string2 + "IS_ACTIVE" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSNiceProfileEntryGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "NiceProfileEntry: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.npId);
            preparedStatement.setInt(3, this.preference);
            if (this.folderId == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.folderId);
            }
            preparedStatement.setInt(5, this.isSuspended);
            preparedStatement.setInt(6, this.renice);
            preparedStatement.setInt(7, this.isActive != false ? 1 : 0);
            preparedStatement.setLong(8, this.creatorUId);
            preparedStatement.setLong(9, this.createTs);
            preparedStatement.setLong(10, this.changerUId);
            preparedStatement.setLong(11, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "NiceProfileEntry: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "NICE_PROFILE_ENTRY" + string3 + " WHERE ID = ?";
                SDMSNiceProfileEntryGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "NiceProfileEntry: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "NiceProfileEntry: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "NICE_PROFILE_ENTRY" + string3 + " SET " + string2 + "NP_ID" + string3 + " = ? , " + string2 + "PREFERENCE" + string3 + " = ? , " + string2 + "FOLDER_ID" + string3 + " = ? , " + string2 + "IS_SUSPENDED" + string3 + " = ? , " + string2 + "RENICE" + string3 + " = ? , " + string2 + "IS_ACTIVE" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? WHERE ID = ?";
                SDMSNiceProfileEntryGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "NiceProfileEntry: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.npId);
            preparedStatement.setInt(2, this.preference);
            if (this.folderId == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, this.folderId);
            }
            preparedStatement.setInt(4, this.isSuspended);
            preparedStatement.setInt(5, this.renice);
            preparedStatement.setInt(6, this.isActive != false ? 1 : 0);
            preparedStatement.setLong(7, this.creatorUId);
            preparedStatement.setLong(8, this.createTs);
            preparedStatement.setLong(9, this.changerUId);
            preparedStatement.setLong(10, this.changeTs);
            preparedStatement.setLong(11, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "NiceProfileEntry: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    public static boolean checkIsSuspended(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : NiceProfileEntry", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "npId : " + this.npId, 2);
        SDMSThread.doTrace(null, "preference : " + this.preference, 2);
        SDMSThread.doTrace(null, "folderId : " + this.folderId, 2);
        SDMSThread.doTrace(null, "isSuspended : " + this.isSuspended, 2);
        SDMSThread.doTrace(null, "renice : " + this.renice, 2);
        SDMSThread.doTrace(null, "isActive : " + this.isActive, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "npId        : " + this.npId + "\n" + string + "preference  : " + this.preference + "\n" + string + "folderId    : " + this.folderId + "\n" + string + "isSuspended : " + this.isSuspended + "\n" + string + "renice      : " + this.renice + "\n" + string + "isActive    : " + this.isActive + "\n" + string + "creatorUId  : " + this.creatorUId + "\n" + string + "createTs    : " + this.createTs + "\n" + string + "changerUId  : " + this.changerUId + "\n" + string + "changeTs    : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

