/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectInstance;
import de.independit.scheduler.server.repository.SDMSObjectInstanceGeneric;
import de.independit.scheduler.server.repository.SDMSObjectInstanceTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSObjectInstanceTableGeneric
extends SDMSTable {
    public static final String tableName = "OBJECT_INSTANCE";
    public static SDMSObjectInstanceTable table = null;
    public static final String[] columnNames = new String[]{"ID", "UNIQUE_NAME", "OM_ID", "MODIFY_TS", "REMOVE_TS", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_omId;
    public static SDMSIndex idx_omId_uniqueName;

    public SDMSObjectInstanceTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ObjectInstance"));
        }
        table = (SDMSObjectInstanceTable)this;
        table = (SDMSObjectInstanceTable)this;
        this.isVersioned = false;
        idx_omId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "omId");
        idx_omId_uniqueName = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "omId_uniqueName");
    }

    public SDMSObjectInstance create(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3) throws SDMSException {
        SDMSObjectInstance sDMSObjectInstance;
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        Long l6 = systemEnvironment.cEnv.uid();
        Long l7 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ObjectInstance"));
        }
        this.validate(systemEnvironment, string, l, l2, l3, l4, l5, l6, l7);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSObjectInstanceGeneric sDMSObjectInstanceGeneric = new SDMSObjectInstanceGeneric(systemEnvironment, string, l, l2, l3, l4, l5, l6, l7);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSObjectInstanceGeneric.versions, true);
            table.put(systemEnvironment, sDMSObjectInstanceGeneric.id, sDMSObjectInstanceGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSObjectInstance = (SDMSObjectInstance)sDMSObjectInstanceGeneric.toProxy(systemEnvironment);
            sDMSObjectInstance.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSObjectInstance sDMSObjectInstance2 = (SDMSObjectInstance)sDMSObjectInstanceGeneric.toProxy(systemEnvironment);
            sDMSObjectInstance2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSObjectInstance)) {
            throw new AccessViolationException(sDMSObjectInstance.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSObjectInstance.touchMaster(systemEnvironment);
        return sDMSObjectInstance;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSObjectInstance sDMSObjectInstance) throws SDMSException {
        return sDMSObjectInstance.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Long l9;
        String string;
        Long l10;
        try {
            l10 = new Long(resultSet.getLong(1));
            string = resultSet.getString(2);
            l9 = new Long(resultSet.getLong(3));
            l8 = new Long(resultSet.getLong(4));
            if (resultSet.wasNull()) {
                l8 = null;
            }
            l7 = new Long(resultSet.getLong(5));
            if (resultSet.wasNull()) {
                l7 = null;
            }
            l6 = new Long(resultSet.getLong(6));
            l5 = new Long(resultSet.getLong(7));
            l4 = new Long(resultSet.getLong(8));
            l3 = new Long(resultSet.getLong(9));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ObjectInstance: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSObjectInstanceGeneric(l10, string, l9, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "UNIQUE_NAME" + string2 + ", " + string + "OM_ID" + string2 + ", " + string + "MODIFY_TS" + string2 + ", " + string + "REMOVE_TS" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_omId.check(((SDMSObjectInstanceGeneric)sDMSObject).omId, sDMSObject);
        string = string + "idx_omId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSObjectInstanceGeneric)sDMSObject).omId);
        sDMSKey.add((Comparable)((Object)((SDMSObjectInstanceGeneric)sDMSObject).uniqueName));
        bl = idx_omId_uniqueName.check(sDMSKey, sDMSObject);
        string = string + "idx_omId_uniqueName: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_omId.put(systemEnvironment, ((SDMSObjectInstanceGeneric)sDMSObject).omId, sDMSObject, (1L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSObjectInstanceGeneric)sDMSObject).omId);
        sDMSKey.add((Comparable)((Object)((SDMSObjectInstanceGeneric)sDMSObject).uniqueName));
        idx_omId_uniqueName.put(systemEnvironment, sDMSKey, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_omId.remove(systemEnvironment, ((SDMSObjectInstanceGeneric)sDMSObject).omId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSObjectInstanceGeneric)sDMSObject).omId);
        sDMSKey.add((Comparable)((Object)((SDMSObjectInstanceGeneric)sDMSObject).uniqueName));
        idx_omId_uniqueName.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSObjectInstance getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSObjectInstance)table.get(systemEnvironment, l);
    }

    public static SDMSObjectInstance getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSObjectInstance)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSObjectInstance getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSObjectInstance)table.get(systemEnvironment, l, l2);
    }

    public static SDMSObjectInstance idx_omId_uniqueName_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSObjectInstance)idx_omId_uniqueName.getUnique(systemEnvironment, object);
    }

    public static SDMSObjectInstance idx_omId_uniqueName_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSObjectInstance)idx_omId_uniqueName.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSObjectInstance idx_omId_uniqueName_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSObjectInstance)idx_omId_uniqueName.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

