/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.Server;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSCalendarTable;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionTable;
import de.independit.scheduler.server.repository.SDMSDependencyInstanceTable;
import de.independit.scheduler.server.repository.SDMSDependencyStateTable;
import de.independit.scheduler.server.repository.SDMSEntityVariableTable;
import de.independit.scheduler.server.repository.SDMSEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSEventParameterTable;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateMappingGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfileGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationTable;
import de.independit.scheduler.server.repository.SDMSExtentsTable;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSHierarchyInstanceTable;
import de.independit.scheduler.server.repository.SDMSIgnoredDependencyTable;
import de.independit.scheduler.server.repository.SDMSInstanceValueTable;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcherTable;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTable;
import de.independit.scheduler.server.repository.SDMSIntervalSelectionTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKillJobTable;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntryTable;
import de.independit.scheduler.server.repository.SDMSNiceProfileTable;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSObjectEventTable;
import de.independit.scheduler.server.repository.SDMSObjectInstanceTable;
import de.independit.scheduler.server.repository.SDMSObjectMonitorParameterTable;
import de.independit.scheduler.server.repository.SDMSObjectMonitorTable;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSPersistentValueTable;
import de.independit.scheduler.server.repository.SDMSPoolDistConfigTable;
import de.independit.scheduler.server.repository.SDMSPoolDistributionTable;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingTable;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplateTable;
import de.independit.scheduler.server.repository.SDMSResourceVariableTable;
import de.independit.scheduler.server.repository.SDMSRunnableQueueTable;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import de.independit.scheduler.server.repository.SDMSScopeConfigEnvMappingTable;
import de.independit.scheduler.server.repository.SDMSScopeConfigTable;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSmeCounterTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityStatsTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSTemplateVariableTable;
import de.independit.scheduler.server.repository.SDMSTriggerParameterTable;
import de.independit.scheduler.server.repository.SDMSTriggerQueueTable;
import de.independit.scheduler.server.repository.SDMSTriggerStateTable;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.repository.SDMSUserEquivTable;
import de.independit.scheduler.server.repository.SDMSUserExtentsTable;
import de.independit.scheduler.server.repository.SDMSUserParameterTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.SDMSVersionedExtentsTable;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameterTable;
import de.independit.scheduler.server.repository.SDMSWatchTypeTable;
import de.independit.scheduler.server.repository.SDMSnpJobFootprintTable;
import de.independit.scheduler.server.repository.SDMSnpSrvrSRFootprintTable;
import de.independit.scheduler.server.repository.TableLoader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class SDMSRepository {
    public static final String __version = "@(#) $Id: SDMSRepository.java,v 2.16.4.5 2013/03/22 14:48:03 ronald Exp $";
    private HashMap tables;
    private Iterator tableIterator = null;
    private SDMSException loaderException = null;
    private Integer lockObject = new Integer(0);
    private long lowestActiveVersion = Long.MAX_VALUE;
    private static int tableCount = 0;
    private static SDMSProxy[] freeProxies = null;

    public SDMSRepository(SystemEnvironment systemEnvironment) throws SDMSException {
        SystemEnvironment.repository = this;
        systemEnvironment.dbConnection = Server.connectToDB(systemEnvironment);
        this.fillSme2Load(systemEnvironment);
        systemEnvironment.lowestActiveVersion = this.lowestActiveVersion;
        this.initMap(systemEnvironment);
        this.loadTables(systemEnvironment);
        try {
            systemEnvironment.dbConnection.close();
        }
        catch (SQLException sQLException) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181535", "SQL Error : $1", (Object)sQLException.getMessage()));
        }
    }

    private void fillSme2Load(SystemEnvironment systemEnvironment) throws SDMSException {
        long l = this.getLowestActiveDate(systemEnvironment);
        long l2 = this.getHistoryDate(systemEnvironment);
        int n = 0;
        long l3 = 0L;
        try {
            String string = systemEnvironment.dbConnection.getMetaData().getDriverName();
            boolean bl = string.startsWith("PostgreSQL");
            String string2 = SystemEnvironment.SQUOTE;
            String string3 = SystemEnvironment.EQUOTE;
            Statement statement = systemEnvironment.dbConnection.createStatement();
            statement.executeUpdate("DELETE FROM SME2LOAD");
            systemEnvironment.dbConnection.commit();
            PreparedStatement preparedStatement = systemEnvironment.dbConnection.prepareStatement("INSERT INTO SME2LOAD VALUES ( ? )");
            Statement statement2 = systemEnvironment.dbConnection.createStatement();
            ResultSet resultSet = statement2.executeQuery("SELECT ID, " + string2 + "SE_ID" + string3 + ", " + string2 + "SE_VERSION" + string3 + ", " + string2 + "STATE" + string3 + ", " + string2 + "FINAL_TS" + string3 + ", " + string2 + "SUBMIT_TS" + string3 + "  FROM SUBMITTED_ENTITY WHERE ID = MASTER_ID   AND (" + string2 + "STATE" + string3 + " NOT IN (" + 10 + "," + 12 + ") OR       FINAL_TS >= " + (bl ? "\t   CAST ('" + l + "' AS DECIMAL)" : "\t   " + l) + ") ORDER BY SE_ID, SUBMIT_TS DESC");
            int n2 = 0;
            while (resultSet.next()) {
                long l4;
                long l5;
                boolean bl2;
                block11: {
                    long l6;
                    block13: {
                        block12: {
                            block10: {
                                bl2 = false;
                                l5 = resultSet.getLong(1);
                                long l7 = resultSet.getLong(2);
                                l4 = resultSet.getLong(3);
                                int n3 = resultSet.getInt(4);
                                l6 = resultSet.getLong(5);
                                if (l7 != l3) {
                                    n = 0;
                                    l3 = l7;
                                }
                                ++n;
                                if (n3 == 10 || n3 == 12) break block10;
                                bl2 = true;
                                break block11;
                            }
                            if (n > SystemEnvironment.minHistoryCount) break block12;
                            bl2 = true;
                            break block11;
                        }
                        if (n <= SystemEnvironment.maxHistoryCount) break block13;
                        if (SystemEnvironment.maxHistoryCount != 0) break block11;
                    }
                    if (l6 >= l2) {
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                if (l4 < this.lowestActiveVersion) {
                    this.lowestActiveVersion = l4;
                }
                preparedStatement.setLong(1, l5);
                preparedStatement.addBatch();
                if (++n2 != 1000) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
                n2 = 0;
            }
            if (n2 != 0) {
                preparedStatement.executeBatch();
            }
            statement2.close();
            preparedStatement.close();
            systemEnvironment.dbConnection.commit();
            Statement statement3 = systemEnvironment.dbConnection.createStatement();
            statement3.executeUpdate("INSERT INTO SME2LOAD SELECT S.ID FROM SUBMITTED_ENTITY S, SME2LOAD M  WHERE M.ID = S.MASTER_ID    AND S.ID != S.MASTER_ID");
            systemEnvironment.dbConnection.commit();
        }
        catch (SQLException sQLException) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03401131304", "SQL Error : $1", (Object)sQLException.getMessage()));
        }
    }

    private long getLowestActiveDate(SystemEnvironment systemEnvironment) {
        Date date = new Date();
        long l = SystemEnvironment.minHistoryCount == 0 ? SystemEnvironment.preserveTime : SystemEnvironment.maxPreserveTime;
        return date.getTime() - l;
    }

    private long getHistoryDate(SystemEnvironment systemEnvironment) {
        Date date = new Date();
        return date.getTime() - SystemEnvironment.preserveTime;
    }

    public SDMSTable getTableByName(String string) throws SDMSException {
        return (SDMSTable)this.tables.get(string);
    }

    private void initMap(SystemEnvironment systemEnvironment) throws SDMSException {
        this.tables = new HashMap();
        this.tables.put("AUDIT_TRAIL", new SDMSAuditTrailTable(systemEnvironment));
        this.tables.put("CALENDAR", new SDMSCalendarTable(systemEnvironment));
        this.tables.put("DEPENDENCY_DEFINITION", new SDMSDependencyDefinitionTable(systemEnvironment));
        this.tables.put("DEPENDENCY_INSTANCE", new SDMSDependencyInstanceTable(systemEnvironment));
        this.tables.put("DEPENDENCY_STATE", new SDMSDependencyStateTable(systemEnvironment));
        this.tables.put("ENTITY_VARIABLE", new SDMSEntityVariableTable(systemEnvironment));
        this.tables.put("ENVIRONMENT", new SDMSEnvironmentTable(systemEnvironment));
        this.tables.put("EVENT_PARAMETER", new SDMSEventParameterTable(systemEnvironment));
        this.tables.put("EVENT", new SDMSEventTable(systemEnvironment));
        this.tables.put("EXIT_STATE_DEFINITION", new SDMSExitStateDefinitionTable(systemEnvironment));
        this.tables.put(SDMSExitStateGeneric.tableName, new SDMSExitStateTable(systemEnvironment));
        this.tables.put(SDMSExitStateMappingGeneric.tableName, new SDMSExitStateMappingTable(systemEnvironment));
        this.tables.put(SDMSExitStateMappingProfileGeneric.tableName, new SDMSExitStateMappingProfileTable(systemEnvironment));
        this.tables.put(SDMSExitStateProfileGeneric.tableName, new SDMSExitStateProfileTable(systemEnvironment));
        this.tables.put("EXIT_STATE_TRANSLATION", new SDMSExitStateTranslationTable(systemEnvironment));
        this.tables.put("EXIT_STATE_TRANS_PROFILE", new SDMSExitStateTranslationProfileTable(systemEnvironment));
        this.tables.put("EXTENTS", new SDMSExtentsTable(systemEnvironment));
        this.tables.put("FOLDER", new SDMSFolderTable(systemEnvironment));
        this.tables.put("FOOTPRINT", new SDMSFootprintTable(systemEnvironment));
        this.tables.put("GRANTS", new SDMSGrantTable(systemEnvironment));
        this.tables.put("GROUPS", new SDMSGroupTable(systemEnvironment));
        this.tables.put("HIERARCHY_INSTANCE", new SDMSHierarchyInstanceTable(systemEnvironment));
        this.tables.put("IGNORED_DEPENDENCY", new SDMSIgnoredDependencyTable(systemEnvironment));
        this.tables.put("INSTANCE_VALUE", new SDMSInstanceValueTable(systemEnvironment));
        this.tables.put("INTERVAL_DISPATCHER", new SDMSIntervalDispatcherTable(systemEnvironment));
        this.tables.put("INTERVAL_HIERARCHY", new SDMSIntervalHierarchyTable(systemEnvironment));
        this.tables.put("INTERVAL_SELECTION", new SDMSIntervalSelectionTable(systemEnvironment));
        this.tables.put("INTERVALL", new SDMSIntervalTable(systemEnvironment));
        this.tables.put("KILL_JOB", new SDMSKillJobTable(systemEnvironment));
        this.tables.put("NAMED_ENVIRONMENT", new SDMSNamedEnvironmentTable(systemEnvironment));
        this.tables.put("NAMED_RESOURCE", new SDMSNamedResourceTable(systemEnvironment));
        this.tables.put("NICE_PROFILE", new SDMSNiceProfileTable(systemEnvironment));
        this.tables.put("NICE_PROFILE_ENTRY", new SDMSNiceProfileEntryTable(systemEnvironment));
        this.tables.put("MEMBER", new SDMSMemberTable(systemEnvironment));
        this.tables.put("OBJECT_COMMENT", new SDMSObjectCommentTable(systemEnvironment));
        this.tables.put("OBJECT_EVENT", new SDMSObjectEventTable(systemEnvironment));
        this.tables.put("OBJECT_INSTANCE", new SDMSObjectInstanceTable(systemEnvironment));
        this.tables.put("OBJECT_MONITOR", new SDMSObjectMonitorTable(systemEnvironment));
        this.tables.put("OBJECT_MONITOR_PARAMETER", new SDMSObjectMonitorParameterTable(systemEnvironment));
        this.tables.put("PARAMETER_DEFINITION", new SDMSParameterDefinitionTable(systemEnvironment));
        this.tables.put("PERSISTENT_VALUE", new SDMSPersistentValueTable(systemEnvironment));
        this.tables.put("POOL", new SDMSPoolTable(systemEnvironment));
        this.tables.put("POOL_DIST_CONFIG", new SDMSPoolDistConfigTable(systemEnvironment));
        this.tables.put("POOL_DISTRIBUTION", new SDMSPoolDistributionTable(systemEnvironment));
        this.tables.put("POOLED_RESOURCE", new SDMSPooledResourceTable(systemEnvironment));
        this.tables.put("RESOURCE_ALLOCATION", new SDMSResourceAllocationTable(systemEnvironment));
        this.tables.put("RESOURCE_REQ_STATES", new SDMSResourceReqStatesTable(systemEnvironment));
        this.tables.put("RESOURCE_REQUIREMENT", new SDMSResourceRequirementTable(systemEnvironment));
        this.tables.put("RESOURCE_STATE_DEFINITION", new SDMSResourceStateDefinitionTable(systemEnvironment));
        this.tables.put("RESOURCE_STATE_MAPPING", new SDMSResourceStateMappingTable(systemEnvironment));
        this.tables.put("RESOURCE_STATE_MAP_PROF", new SDMSResourceStateMappingProfileTable(systemEnvironment));
        this.tables.put("RESOURCE_STATE_PROFILE", new SDMSResourceStateProfileTable(systemEnvironment));
        this.tables.put("RESOURCE_STATE", new SDMSResourceStateTable(systemEnvironment));
        this.tables.put("RESOURCE_VARIABLE", new SDMSResourceVariableTable(systemEnvironment));
        this.tables.put("RESSOURCE", new SDMSResourceTable(systemEnvironment));
        this.tables.put("RESOURCE_TEMPLATE", new SDMSResourceTemplateTable(systemEnvironment));
        this.tables.put("RUNNABLE_QUEUE", new SDMSRunnableQueueTable(systemEnvironment));
        this.tables.put("SCHEDULED_EVENT", new SDMSScheduledEventTable(systemEnvironment));
        this.tables.put("SCHEDULE", new SDMSScheduleTable(systemEnvironment));
        this.tables.put("SCHEDULING_ENTITY", new SDMSSchedulingEntityTable(systemEnvironment));
        this.tables.put("SCHEDULING_HIERARCHY", new SDMSSchedulingHierarchyTable(systemEnvironment));
        this.tables.put("SCOPE", new SDMSScopeTable(systemEnvironment));
        this.tables.put("SCOPE_CONFIG", new SDMSScopeConfigTable(systemEnvironment));
        this.tables.put("SCOPE_CONFIG_ENVMAPPING", new SDMSScopeConfigEnvMappingTable(systemEnvironment));
        this.tables.put("SME_COUNTER", new SDMSSmeCounterTable(systemEnvironment));
        this.tables.put("SUBMITTED_ENTITY", new SDMSSubmittedEntityTable(systemEnvironment));
        this.tables.put("SUBMITTED_ENTITY_STATS", new SDMSSubmittedEntityStatsTable(systemEnvironment));
        this.tables.put("TEMPLATE_VARIABLE", new SDMSTemplateVariableTable(systemEnvironment));
        this.tables.put("TRIGGER_DEFINITION", new SDMSTriggerTable(systemEnvironment));
        this.tables.put("TRIGGER_PARAMETER", new SDMSTriggerParameterTable(systemEnvironment));
        this.tables.put("TRIGGER_QUEUE", new SDMSTriggerQueueTable(systemEnvironment));
        this.tables.put("TRIGGER_STATE", new SDMSTriggerStateTable(systemEnvironment));
        this.tables.put("USERS", new SDMSUserTable(systemEnvironment));
        this.tables.put("USER_EQUIV", new SDMSUserEquivTable(systemEnvironment));
        this.tables.put("USER_EXTENTS", new SDMSUserExtentsTable(systemEnvironment));
        this.tables.put("USER_PARAMETER", new SDMSUserParameterTable(systemEnvironment));
        this.tables.put("VERSIONED_EXTENTS", new SDMSVersionedExtentsTable(systemEnvironment));
        this.tables.put("WATCH_TYPE", new SDMSWatchTypeTable(systemEnvironment));
        this.tables.put("WATCH_TYPE_PARAMETER", new SDMSWatchTypeParameterTable(systemEnvironment));
        this.tables.put("NP_JOB_FOOTPRINT", new SDMSnpJobFootprintTable(systemEnvironment));
        this.tables.put("NPSRVR_SR_FOOTPRINT", new SDMSnpSrvrSRFootprintTable(systemEnvironment));
        freeProxies = new SDMSProxy[tableCount];
    }

    private void loadTables(SystemEnvironment systemEnvironment) throws SDMSException {
        int n;
        int n2 = SystemEnvironment.maxWriter;
        SystemEnvironment.maxWriter = 1;
        this.tableIterator = this.tables.values().iterator();
        TableLoader[] tableLoaderArray = new TableLoader[SystemEnvironment.dbLoaders];
        for (n = 0; n < SystemEnvironment.dbLoaders; ++n) {
            tableLoaderArray[n] = new TableLoader(n, systemEnvironment);
        }
        for (n = 0; n < SystemEnvironment.dbLoaders; ++n) {
            tableLoaderArray[n].start();
        }
        for (n = 0; n < SystemEnvironment.dbLoaders; ++n) {
            try {
                tableLoaderArray[n].join();
            }
            catch (InterruptedException interruptedException) {
                --n;
                continue;
            }
            tableLoaderArray[n] = null;
        }
        SystemEnvironment.maxWriter = n2;
        if (this.loaderException != null) {
            throw this.loaderException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SDMSTable getNextTable() {
        Integer n = this.lockObject;
        synchronized (n) {
            if (this.tableIterator.hasNext()) {
                return (SDMSTable)this.tableIterator.next();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notify(SDMSException sDMSException) {
        Integer n = this.lockObject;
        synchronized (n) {
            this.loaderException = sDMSException;
        }
    }

    public Iterator getTableIterator(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.tables.values().iterator();
    }

    public SDMSTable getTable(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSTable sDMSTable = (SDMSTable)this.tables.get(string);
        if (sDMSTable == null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110231115", "Table $1 not found", (Object)string));
        }
        return sDMSTable;
    }

    public SDMSTable userGetTable(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSTable sDMSTable = (SDMSTable)this.tables.get(string);
        if (sDMSTable == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202011519", "Table $1 not found", (Object)string));
        }
        return sDMSTable;
    }

    public static int getTableIndex() {
        return ++tableCount - 1;
    }

    public static int getTableCount() {
        return tableCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SDMSProxy getProxy(int n) {
        SDMSProxy[] sDMSProxyArray = freeProxies;
        synchronized (freeProxies) {
            if (freeProxies[n] != null) {
                SDMSProxy sDMSProxy = freeProxies[n];
                SDMSRepository.freeProxies[n] = sDMSProxy.next;
                sDMSProxy.next = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return sDMSProxy;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseProxies(int n, SDMSProxy sDMSProxy, SDMSProxy sDMSProxy2) {
        SDMSProxy[] sDMSProxyArray = freeProxies;
        synchronized (freeProxies) {
            SDMSProxy sDMSProxy3 = freeProxies[n];
            SDMSRepository.freeProxies[n] = sDMSProxy;
            sDMSProxy2.next = sDMSProxy3;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void releaseProxies(SDMSProxy[] sDMSProxyArray) {
        for (int i = 0; i < tableCount; ++i) {
            SDMSProxy sDMSProxy = sDMSProxyArray[i];
            SDMSProxy sDMSProxy2 = null;
            while (sDMSProxy != null && sDMSProxy.fixed) {
                sDMSProxyArray[i] = sDMSProxy.next;
                sDMSProxy.next = null;
                sDMSProxy = sDMSProxyArray[i];
            }
            if (sDMSProxy == null) continue;
            while (true) {
                if (sDMSProxy.fixed) {
                    sDMSProxy2.next = sDMSProxy.next;
                    sDMSProxy.next = null;
                } else {
                    sDMSProxy.cleanupProxy();
                    sDMSProxy2 = sDMSProxy;
                }
                if (sDMSProxy2.next == null) break;
                sDMSProxy = sDMSProxy2.next;
            }
            SDMSRepository.releaseProxies(i, sDMSProxyArray[i], sDMSProxy);
        }
    }
}

