/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSResourceTemplate;
import de.independit.scheduler.server.repository.SDMSResourceTemplateGeneric;
import de.independit.scheduler.server.repository.SDMSResourceTemplateTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSResourceTemplateTableGeneric
extends SDMSTable {
    public static final String tableName = "RESOURCE_TEMPLATE";
    public static SDMSResourceTemplateTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NR_ID", "SE_ID", "OWNER_ID", "RSD_ID", "REQUESTABLE_AMOUNT", "AMOUNT", "IS_ONLINE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_nrId;
    public static SDMSIndex idx_seId;
    public static SDMSIndex idx_ownerId;
    public static SDMSIndex idx_rsdId;
    public static SDMSIndex idx_nrId_seId;

    public SDMSResourceTemplateTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ResourceTemplate"));
        }
        table = (SDMSResourceTemplateTable)this;
        table = (SDMSResourceTemplateTable)this;
        this.isVersioned = true;
        idx_nrId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "nrId");
        idx_seId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "seId");
        idx_ownerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "ownerId");
        idx_rsdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "rsdId");
        idx_nrId_seId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "nrId_seId");
    }

    public SDMSResourceTemplate create(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Integer n, Integer n2, Boolean bl) throws SDMSException {
        SDMSResourceTemplate sDMSResourceTemplate;
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        Long l7 = systemEnvironment.cEnv.uid();
        Long l8 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ResourceTemplate"));
        }
        this.validate(systemEnvironment, l, l2, l3, l4, n, n2, bl, l5, l6, l7, l8);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSResourceTemplateGeneric sDMSResourceTemplateGeneric = new SDMSResourceTemplateGeneric(systemEnvironment, l, l2, l3, l4, n, n2, bl, l5, l6, l7, l8);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSResourceTemplateGeneric.versions, true);
            table.put(systemEnvironment, sDMSResourceTemplateGeneric.id, sDMSResourceTemplateGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSResourceTemplate = (SDMSResourceTemplate)sDMSResourceTemplateGeneric.toProxy(systemEnvironment);
            sDMSResourceTemplate.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSResourceTemplate sDMSResourceTemplate2 = (SDMSResourceTemplate)sDMSResourceTemplateGeneric.toProxy(systemEnvironment);
            sDMSResourceTemplate2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSResourceTemplate)) {
            throw new AccessViolationException(sDMSResourceTemplate.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSResourceTemplate;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Integer n, Integer n2, Boolean bl, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Boolean bl;
        Integer n;
        Integer n2;
        Long l7;
        Long l8;
        Long l9;
        Long l10;
        Long l11;
        try {
            l11 = new Long(resultSet.getLong(1));
            l10 = new Long(resultSet.getLong(2));
            l9 = new Long(resultSet.getLong(3));
            l8 = new Long(resultSet.getLong(4));
            l7 = new Long(resultSet.getLong(5));
            if (resultSet.wasNull()) {
                l7 = null;
            }
            n2 = new Integer(resultSet.getInt(6));
            if (resultSet.wasNull()) {
                n2 = null;
            }
            n = new Integer(resultSet.getInt(7));
            if (resultSet.wasNull()) {
                n = null;
            }
            bl = new Boolean(resultSet.getInt(8) != 0);
            l6 = new Long(resultSet.getLong(9));
            l5 = new Long(resultSet.getLong(10));
            l4 = new Long(resultSet.getLong(11));
            l3 = new Long(resultSet.getLong(12));
            l2 = resultSet.getLong(13);
            l = resultSet.getLong(14);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ResourceTemplate: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSResourceTemplateGeneric(l11, l10, l9, l8, l7, n2, n, bl, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NR_ID" + string2 + ", " + string + "SE_ID" + string2 + ", " + string + "OWNER_ID" + string2 + ", " + string + "RSD_ID" + string2 + ", " + string + "REQUESTABLE_AMOUNT" + string2 + ", " + string + "AMOUNT" + string2 + ", " + string + "IS_ONLINE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO  FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion) + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_nrId.check(((SDMSResourceTemplateGeneric)sDMSObject).nrId, sDMSObject);
        string = string + "idx_nrId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_seId.check(((SDMSResourceTemplateGeneric)sDMSObject).seId, sDMSObject);
        string = string + "idx_seId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_ownerId.check(((SDMSResourceTemplateGeneric)sDMSObject).ownerId, sDMSObject);
        string = string + "idx_ownerId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_rsdId.check(((SDMSResourceTemplateGeneric)sDMSObject).rsdId, sDMSObject);
        string = string + "idx_rsdId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceTemplateGeneric)sDMSObject).nrId);
        sDMSKey.add(((SDMSResourceTemplateGeneric)sDMSObject).seId);
        bl = idx_nrId_seId.check(sDMSKey, sDMSObject);
        string = string + "idx_nrId_seId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_nrId.put(systemEnvironment, ((SDMSResourceTemplateGeneric)sDMSObject).nrId, sDMSObject, (1L & l) != 0L);
        idx_seId.put(systemEnvironment, ((SDMSResourceTemplateGeneric)sDMSObject).seId, sDMSObject, (2L & l) != 0L);
        idx_ownerId.put(systemEnvironment, ((SDMSResourceTemplateGeneric)sDMSObject).ownerId, sDMSObject, (4L & l) != 0L);
        idx_rsdId.put(systemEnvironment, ((SDMSResourceTemplateGeneric)sDMSObject).rsdId, sDMSObject, (8L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceTemplateGeneric)sDMSObject).nrId);
        sDMSKey.add(((SDMSResourceTemplateGeneric)sDMSObject).seId);
        idx_nrId_seId.put(systemEnvironment, sDMSKey, sDMSObject, (0x10L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_nrId.remove(systemEnvironment, ((SDMSResourceTemplateGeneric)sDMSObject).nrId, sDMSObject);
        idx_seId.remove(systemEnvironment, ((SDMSResourceTemplateGeneric)sDMSObject).seId, sDMSObject);
        idx_ownerId.remove(systemEnvironment, ((SDMSResourceTemplateGeneric)sDMSObject).ownerId, sDMSObject);
        idx_rsdId.remove(systemEnvironment, ((SDMSResourceTemplateGeneric)sDMSObject).rsdId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceTemplateGeneric)sDMSObject).nrId);
        sDMSKey.add(((SDMSResourceTemplateGeneric)sDMSObject).seId);
        idx_nrId_seId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSResourceTemplate getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceTemplate)table.get(systemEnvironment, l);
    }

    public static SDMSResourceTemplate getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceTemplate)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSResourceTemplate getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSResourceTemplate)table.get(systemEnvironment, l, l2);
    }

    public static SDMSResourceTemplate idx_nrId_seId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceTemplate)idx_nrId_seId.getUnique(systemEnvironment, object);
    }

    public static SDMSResourceTemplate idx_nrId_seId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceTemplate)idx_nrId_seId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSResourceTemplate idx_nrId_seId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSResourceTemplate)idx_nrId_seId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

