/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.ConnectionEnvironment;
import de.independit.scheduler.server.ListenThread;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.UserConnection;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ScopeConfig;
import de.independit.scheduler.server.parser.ScopeParameter;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSOwnedObject;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolDistConfig;
import de.independit.scheduler.server.repository.SDMSPoolDistConfigTable;
import de.independit.scheduler.server.repository.SDMSPoolDistribution;
import de.independit.scheduler.server.repository.SDMSPoolDistributionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSPoolDistributionTable;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSPooledResource;
import de.independit.scheduler.server.repository.SDMSPooledResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSRunnableQueueTable;
import de.independit.scheduler.server.repository.SDMSScopeProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserEquiv;
import de.independit.scheduler.server.repository.SDMSUserEquivTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.ScopeVariableResolver;
import de.independit.scheduler.server.repository.VariableResolver;
import de.independit.scheduler.server.util.SDMSFilter;
import de.independit.scheduler.server.util.SDMSThread;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class SDMSScope
extends SDMSScopeProxyGeneric
implements SDMSOwnedObject {
    public static final String __version = "@(#) $Id: SDMSScope.java,v 2.27.2.4 2013/03/19 17:16:52 ronald Exp $";
    private static final VariableResolver SVR = new ScopeVariableResolver();
    private static final Long lzero = new Long(0L);
    private static final Integer zero = new Integer(0);
    private static final Float fzero = new Float(0.0f);

    protected SDMSScope(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    public SDMSScope copy(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap<Long, Vector> hashMap3 = new HashMap<Long, Vector>();
        SDMSScope sDMSScope = this.internalCopy(systemEnvironment, l, string, hashMap, hashMap2);
        for (Long l2 : hashMap2.keySet()) {
            Serializable serializable;
            SDMSProxy sDMSProxy;
            Comparable<Long> comparable;
            Long l3 = (Long)hashMap2.get(l2);
            Vector vector = SDMSPooledResourceTable.idx_pId.getVector(systemEnvironment, l3);
            for (int i = 0; i < vector.size(); ++i) {
                SDMSProxy sDMSProxy2;
                SDMSPooledResource sDMSPooledResource = (SDMSPooledResource)vector.get(i);
                comparable = (Long)hashMap.get(sDMSPooledResource.getRId(systemEnvironment));
                if (comparable == null) continue;
                sDMSProxy = SDMSPooledResourceTable.table.create(systemEnvironment, l2, (Long)comparable, sDMSPooledResource.getIsPool(systemEnvironment), sDMSPooledResource.getIsManaged(systemEnvironment), sDMSPooledResource.getNomPct(systemEnvironment), sDMSPooledResource.getFreePct(systemEnvironment), sDMSPooledResource.getMinPct(systemEnvironment), sDMSPooledResource.getMaxPct(systemEnvironment), sDMSPooledResource.getActIsManaged(systemEnvironment), sDMSPooledResource.getActNomPct(systemEnvironment), sDMSPooledResource.getActFreePct(systemEnvironment), sDMSPooledResource.getActMinPct(systemEnvironment), sDMSPooledResource.getActMaxPct(systemEnvironment), sDMSPooledResource.getTargetAmount(systemEnvironment));
                serializable = sDMSProxy.getId(systemEnvironment);
                hashMap3.put(sDMSPooledResource.getId(systemEnvironment), (Vector)serializable);
                if (!((SDMSPooledResourceProxyGeneric)sDMSProxy).getActIsManaged(systemEnvironment).booleanValue()) continue;
                if (((SDMSPooledResourceProxyGeneric)sDMSProxy).getIsPool(systemEnvironment).booleanValue()) {
                    sDMSProxy2 = SDMSPoolTable.getObject(systemEnvironment, ((SDMSPooledResourceProxyGeneric)sDMSProxy).getRId(systemEnvironment));
                    ((SDMSPool)sDMSProxy2).setManagerId(systemEnvironment, (Long)serializable);
                    continue;
                }
                sDMSProxy2 = SDMSResourceTable.getObject(systemEnvironment, ((SDMSPooledResourceProxyGeneric)sDMSProxy).getRId(systemEnvironment));
                ((SDMSResource)sDMSProxy2).setManagerId(systemEnvironment, (Long)serializable);
            }
            Vector vector2 = SDMSPoolDistributionTable.idx_pId.getVector(systemEnvironment, l3);
            for (int i = 0; i < vector2.size(); ++i) {
                comparable = (SDMSPoolDistribution)vector2.get(i);
                sDMSProxy = SDMSPoolDistributionTable.table.create(systemEnvironment, ((SDMSPoolDistributionProxyGeneric)comparable).getName(systemEnvironment), l2);
                serializable = SDMSPoolDistConfigTable.idx_pldId.getVector(systemEnvironment, ((SDMSProxy)comparable).getId(systemEnvironment));
                for (int j = 0; j < serializable.size(); ++j) {
                    SDMSPoolDistConfig sDMSPoolDistConfig = (SDMSPoolDistConfig)serializable.get(j);
                    Long l4 = (Long)hashMap3.get(sDMSPoolDistConfig.getPrId(systemEnvironment));
                    if (l4 == null) continue;
                    SDMSPoolDistConfigTable.table.create(systemEnvironment, sDMSProxy.getId(systemEnvironment), l4, sDMSPoolDistConfig.getIsManaged(systemEnvironment), sDMSPoolDistConfig.getNomPct(systemEnvironment), sDMSPoolDistConfig.getFreePct(systemEnvironment), sDMSPoolDistConfig.getMinPct(systemEnvironment), sDMSPoolDistConfig.getMaxPct(systemEnvironment));
                }
            }
        }
        return sDMSScope;
    }

    private SDMSScope internalCopy(SystemEnvironment systemEnvironment, Long l, String string, HashMap hashMap, HashMap hashMap2) throws SDMSException {
        Object object;
        Object object2;
        Object object32;
        Long l2 = this.getId(systemEnvironment);
        SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid());
        Long l3 = sDMSUser.getDefaultGId(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "03402291216"));
        }
        Integer n = this.getType(systemEnvironment);
        SDMSScope sDMSScope = n.equals(new Integer(1)) ? SDMSScopeTable.table.create(systemEnvironment, string, l3, l, this.getType(systemEnvironment), null, null, null, null, null, null, null, null, new Integer(0), null, null, null, null, this.getInheritPrivs(systemEnvironment)) : SDMSScopeTable.table.create(systemEnvironment, string, l3, l, this.getType(systemEnvironment), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, this.getIsEnabled(systemEnvironment), Boolean.FALSE, new Integer(1), this.getPasswd(systemEnvironment), this.getSalt(systemEnvironment), this.getMethod(systemEnvironment), null, this.getNode(systemEnvironment), null, null, this.getInheritPrivs(systemEnvironment));
        Long l4 = sDMSScope.getId(systemEnvironment);
        Vector vector = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, l2);
        for (Object object32 : vector) {
            ((SDMSScope)object32).internalCopy(systemEnvironment, l4, ((SDMSScopeProxyGeneric)object32).getName(systemEnvironment), hashMap, hashMap2);
        }
        object32 = SDMSResourceTable.idx_scopeId.getVector(systemEnvironment, l2);
        Iterator iterator = ((Vector)object32).iterator();
        while (iterator.hasNext()) {
            object2 = (SDMSResource)iterator.next();
            object = SDMSResourceTable.table.create(systemEnvironment, ((SDMSResourceProxyGeneric)object2).getNrId(systemEnvironment), l4, null, l3, null, null, null, ((SDMSResource)object2).getRsdId(systemEnvironment), null, ((SDMSResource)object2).getDefinedAmount(systemEnvironment), ((SDMSResource)object2).getRequestableAmount(systemEnvironment), ((SDMSResource)object2).getDefinedAmount(systemEnvironment), ((SDMSResource)object2).getDefinedAmount(systemEnvironment), ((SDMSResource)object2).getIsOnline(systemEnvironment), ((SDMSResource)object2).getFactor(systemEnvironment), ((SDMSResource)object2).getTraceInterval(systemEnvironment), ((SDMSResource)object2).getTraceBase(systemEnvironment), ((SDMSResource)object2).getTraceBaseMultiplier(systemEnvironment), fzero, fzero, fzero, fzero, lzero, lzero);
            hashMap.put(((SDMSProxy)object2).getId(systemEnvironment), ((SDMSProxy)object).getId(systemEnvironment));
        }
        object2 = SDMSPoolTable.idx_scopeId.getVector(systemEnvironment, l2);
        object = ((Vector)object2).iterator();
        while (object.hasNext()) {
            SDMSPool sDMSPool = (SDMSPool)object.next();
            SDMSPool sDMSPool2 = SDMSPoolTable.table.create(systemEnvironment, sDMSPool.getNrId(systemEnvironment), l4, l3, null, null, sDMSPool.getDefinedAmount(systemEnvironment), sDMSPool.getDefinedAmount(systemEnvironment), sDMSPool.getDefinedAmount(systemEnvironment), zero, sDMSPool.getEvaluationCycle(systemEnvironment), sDMSPool.getNextEvaluationTime(systemEnvironment), null, sDMSPool.getTraceInterval(systemEnvironment), sDMSPool.getTraceBase(systemEnvironment), sDMSPool.getTraceBaseMultiplier(systemEnvironment), fzero, fzero, fzero, fzero, lzero, lzero);
            hashMap.put(sDMSPool.getId(systemEnvironment), sDMSPool2.getId(systemEnvironment));
            hashMap2.put(sDMSPool2.getId(systemEnvironment), sDMSPool.getId(systemEnvironment));
        }
        ScopeConfig.copy(systemEnvironment, l2, l4);
        ScopeParameter.copy(systemEnvironment, l2, l4);
        if (n.equals(new Integer(2))) {
            SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSScope, 1);
        }
        return sDMSScope;
    }

    private UserConnection getConnection(SystemEnvironment systemEnvironment) throws SDMSException {
        ThreadGroup threadGroup = SystemEnvironment.utg;
        Thread[] threadArray = new SDMSThread[threadGroup.activeCount()];
        int n = threadGroup.enumerate(threadArray);
        for (int i = 0; i < n; ++i) {
            ConnectionEnvironment connectionEnvironment;
            UserConnection userConnection;
            if (threadArray[i] instanceof ListenThread || systemEnvironment.cEnv.getMe().equals(threadArray[i]) || !(userConnection = (UserConnection)threadArray[i]).iAmAlive() || (connectionEnvironment = userConnection.getEnv()) == null || connectionEnvironment.uid() == null || !connectionEnvironment.uid().equals(this.getId(systemEnvironment))) continue;
            return userConnection;
        }
        return null;
    }

    public boolean isConnected(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.getType(systemEnvironment) == 2) {
            return this.getConnection(systemEnvironment) != null;
        }
        return false;
    }

    public int getConnectionId(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.getType(systemEnvironment) == 2) {
            UserConnection userConnection = this.getConnection(systemEnvironment);
            if (userConnection != null) {
                return userConnection.id();
            }
            return -1;
        }
        return -1;
    }

    public long getIdle(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.getType(systemEnvironment) == 2) {
            UserConnection userConnection = this.getConnection(systemEnvironment);
            if (userConnection != null) {
                ConnectionEnvironment connectionEnvironment = userConnection.getEnv();
                return connectionEnvironment.idle();
            }
            Long l = this.getLastActive(systemEnvironment);
            if (l == null) {
                return systemEnvironment.cEnv.last() / 1000L;
            }
            return (systemEnvironment.cEnv.last() - l + 500L) / 1000L;
        }
        return 0L;
    }

    @Override
    public void setIsRegistered(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl.equals(this.getIsRegistered(systemEnvironment))) {
            return;
        }
        super.setIsRegistered(systemEnvironment, bl);
        SystemEnvironment.sched.notifyChange(systemEnvironment, this, bl != false ? 4 : 5);
    }

    @Override
    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l.equals(this.getOwnerId(systemEnvironment))) {
            return;
        }
        super.setOwnerId(systemEnvironment, l);
        SystemEnvironment.sched.notifyChange(systemEnvironment, this, 2);
    }

    public boolean hasActiveJobs(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSSubmittedEntityTable.idx_scopeId.getVector(systemEnvironment, (Object)l, new SDMSFilter(){

            @Override
            public boolean isValid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
                SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)sDMSProxy;
                int n = sDMSSubmittedEntity.getState(systemEnvironment);
                return n != 12 && n != 10 && n != 15;
            }
        }, 2);
        if (vector.size() > 0) {
            return true;
        }
        return SDMSRunnableQueueTable.idx_scopeId.containsKey(systemEnvironment, l);
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.delete(systemEnvironment, false);
    }

    public void delete(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        if (bl) {
            Vector vector = new Vector();
            this.gatherPools(systemEnvironment, vector);
            for (int i = 0; i < vector.size(); ++i) {
                SDMSPool sDMSPool = (SDMSPool)vector.get(i);
                sDMSPool.delete(systemEnvironment);
            }
        }
        this.myDelete(systemEnvironment, bl);
    }

    public void myDelete(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        Vector vector;
        Long l = this.getId(systemEnvironment);
        if (bl) {
            int n;
            Vector vector2 = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, l);
            for (n = 0; n < vector2.size(); ++n) {
                ((SDMSScope)vector2.get(n)).myDelete(systemEnvironment, bl);
            }
            vector = SDMSResourceTable.idx_scopeId.getVector(systemEnvironment, l);
            for (n = 0; n < vector.size(); ++n) {
                SDMSResource sDMSResource = (SDMSResource)vector.get(n);
                sDMSResource.delete(systemEnvironment);
            }
        }
        if ((vector = SDMSResourceTable.idx_scopeId.getVector(systemEnvironment, l)).size() != 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603181720", "Scope not empty (contains resources)"));
        }
        vector = SDMSPoolTable.idx_scopeId.getVector(systemEnvironment, l);
        if (vector.size() != 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603181721", "Scope not empty (contains pools)"));
        }
        vector = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, l);
        if (vector.size() != 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201301041", "Scope not empty (contains subscopes)"));
        }
        vector = SDMSSubmittedEntityTable.idx_scopeId.getVector(systemEnvironment, l);
        if (vector.size() != 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202231053", "Scope $1 contains Jobs", (Object)this.pathString(systemEnvironment)));
        }
        if (this.isConnected(systemEnvironment)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03209162133", "Server still connected"));
        }
        ScopeConfig.kill(systemEnvironment, this);
        ScopeParameter.kill(systemEnvironment, this.getId(systemEnvironment));
        if (this.getType(systemEnvironment) == 2) {
            vector = SDMSUserEquivTable.idx_altUId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector.size(); ++i) {
                SDMSUserEquiv sDMSUserEquiv = (SDMSUserEquiv)vector.get(i);
                sDMSUserEquiv.delete(systemEnvironment);
            }
            SystemEnvironment.sched.notifyChange(systemEnvironment, this, 3);
        }
        super.delete(systemEnvironment);
    }

    private void gatherPools(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector2 = SDMSPoolTable.idx_scopeId.getVector(systemEnvironment, l);
        vector.addAll(vector2);
        Vector vector3 = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector3.size(); ++i) {
            SDMSScope sDMSScope = (SDMSScope)vector3.get(i);
            sDMSScope.gatherPools(systemEnvironment, vector);
        }
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        return SVR.getVariableValue(systemEnvironment, (SDMSProxy)this, string, -1L);
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string, long l) throws SDMSException {
        return SVR.getVariableValue(systemEnvironment, (SDMSProxy)this, string, l);
    }

    @Override
    public long addImplicitPrivs(long l) {
        if (((l = super.addImplicitPrivs(l)) & 0x100L) != 0L) {
            l |= 8L;
        }
        return l;
    }

    public boolean canExecute(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        SDMSPrivilege sDMSPrivilege = null;
        HashSet<Long> hashSet = new HashSet<Long>();
        Long l = sDMSSubmittedEntity.getOwnerId(systemEnvironment);
        hashSet.add(l);
        hashSet.add(SDMSObject.publicGId);
        systemEnvironment.cEnv.pushGid(systemEnvironment, hashSet);
        try {
            sDMSPrivilege = new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x100000000L, true, null));
        }
        finally {
            systemEnvironment.cEnv.popGid(systemEnvironment);
        }
        return sDMSPrivilege.can(0x100000000L);
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.pathString(systemEnvironment);
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.getType(systemEnvironment) == 1) {
            return "scope " + this.getURLName(systemEnvironment);
        }
        return "jobserver " + this.getURLName(systemEnvironment);
    }

    @Override
    public String getSubtypeName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getTypeAsString(systemEnvironment);
    }

    public void notify(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.getType(systemEnvironment) == 2) {
            int n;
            InetAddress inetAddress;
            Object object;
            String string = ScopeConfig.getItem(systemEnvironment, this, "NOTIFYPORT");
            if (string == null) {
                return;
            }
            UserConnection userConnection = this.getConnection(systemEnvironment);
            if (userConnection == null) {
                object = ScopeConfig.getItem(systemEnvironment, this, "HTTPHOST");
                if (object == null || ((String)object).equals("")) {
                    return;
                }
                try {
                    inetAddress = InetAddress.getByName((String)object);
                }
                catch (Exception exception) {
                    return;
                }
            } else {
                object = userConnection.getEnv();
                inetAddress = ((ConnectionEnvironment)object).getAddress();
            }
            if (inetAddress == null) {
                return;
            }
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            byte[] byArray = this.getId(systemEnvironment).toString().getBytes();
            try {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, 0, byArray.length, inetAddress, n);
                if (SystemEnvironment.notifySocket == null) {
                    SystemEnvironment.notifySocket = new DatagramSocket();
                }
                SystemEnvironment.notifySocket.send(datagramPacket);
            }
            catch (Exception exception) {
                System.out.println("Something went wrong : " + exception.toString());
            }
        } else {
            Vector vector = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, this.getId(systemEnvironment));
            for (int i = 0; i < vector.size(); ++i) {
                SDMSScope sDMSScope = (SDMSScope)vector.get(i);
                sDMSScope.notify(systemEnvironment);
            }
        }
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        long l2 = super.getPrivileges(systemEnvironment, l, bl, vector);
        if (systemEnvironment.cEnv.isUser() && this.getParentId(systemEnvironment) == null) {
            l2 |= 0x10000000L;
        }
        return l2 & l;
    }
}

