/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.timer;

public class TimerUnit {
    public static final String __version = "@(#) $Id: TimerUnit.java,v 2.1.2.1 2013/03/14 10:25:28 ronald Exp $";
    public static final int YEAR = 5;
    public static final int MONTH = 4;
    public static final int DAY = 2;
    public static final int HOUR = 1;
    public static final int MINUTE = 0;
    public static final int WEEK = 3;
    public static final int[][] STANDARD_LENGTH = new int[][]{{1}, {60, 1}, {1440, 24, 1}, {10080, 168, 7, 1}, {43200, 720, 30, 5, 1}, {525600, 8760, 365, 52, 12, 1}};
    private boolean isINF;
    private int mult;
    private int unit;

    public final boolean isINF() {
        return this.isINF;
    }

    public final int mult() {
        if (this.isINF) {
            throw new IllegalStateException("(04304041915) TimerUnit is INF");
        }
        return this.mult;
    }

    public final int unit() {
        if (this.isINF) {
            throw new IllegalStateException("(04304041916) TimerUnit is INF");
        }
        return this.unit;
    }

    public TimerUnit(Integer n, Integer n2) {
        this.set(n, n2);
    }

    public TimerUnit(int n, int n2) {
        this.set(n, n2);
    }

    public TimerUnit(TimerUnit timerUnit) {
        this.set(timerUnit);
    }

    public final void set(Integer n, Integer n2) {
        boolean bl = this.isINF = n == null || n2 == null;
        if (this.isINF) {
            this.mult = 0;
            this.unit = -1;
        } else {
            this.set((int)n, (int)n2);
        }
    }

    public final void set(int n, int n2) {
        if (n2 != 5 && n2 != 4 && n2 != 2 && n2 != 1 && n2 != 0 && n2 != 3) {
            throw new IllegalArgumentException("(04304041917) invalid unit: " + n2);
        }
        this.isINF = false;
        this.mult = n;
        this.unit = n2;
    }

    public final void set(TimerUnit timerUnit) {
        this.isINF = timerUnit.isINF;
        this.mult = timerUnit.mult;
        this.unit = timerUnit.unit;
    }

    public final int compareTo(TimerUnit timerUnit) {
        if (this.isINF) {
            return timerUnit.isINF ? 0 : 1;
        }
        if (timerUnit.isINF) {
            return -1;
        }
        if (this.unit == timerUnit.unit) {
            return this.mult - timerUnit.mult;
        }
        long l = this.mult * STANDARD_LENGTH[this.unit][0];
        long l2 = timerUnit.mult * STANDARD_LENGTH[timerUnit.unit][0];
        long l3 = l - l2;
        return l3 < 0L ? -1 : (l3 > 0L ? 1 : 0);
    }

    public final String toString() {
        if (this.isINF) {
            return "INF";
        }
        switch (this.unit) {
            case 5: {
                return this.mult + "Y";
            }
            case 4: {
                return this.mult + "M";
            }
            case 2: {
                return this.mult + "D";
            }
            case 1: {
                return this.mult + "h";
            }
            case 0: {
                return this.mult + "m";
            }
            case 3: {
                return this.mult + "W";
            }
        }
        return this.mult + "?(" + this.unit + ")";
    }

    public final String asString() {
        if (this.isINF) {
            return "INF";
        }
        String string = this.mult == 1 ? "" : "S";
        switch (this.unit) {
            case 5: {
                return this.mult + " YEAR" + string;
            }
            case 4: {
                return this.mult + " MONTH" + string;
            }
            case 2: {
                return this.mult + " DAY" + string;
            }
            case 1: {
                return this.mult + " HOUR" + string;
            }
            case 0: {
                return this.mult + " MINUTE" + string;
            }
            case 3: {
                return this.mult + " WEEK" + string;
            }
        }
        return this.mult + " ???(" + this.unit + ")";
    }
}

