/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.tools;

import de.independit.scheduler.SDMSApp.App;
import de.independit.scheduler.SDMSApp.RetryException;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputUtil;

class get_variable
extends App {
    public static final String __version = "@(#) $Id: get_variable.java,v 2.3.6.1 2013/03/14 10:25:31 ronald Exp $";
    public static final String JID = "JID";
    public static final String NAME = "NAME";
    public static final String MODE = "MODE";

    get_variable() {
    }

    @Override
    public void addOptions() {
        this.addOption("j", "jid", null, JID, null, "jobid", true, "Id of job to get variable from");
        this.addOption("n", "name", null, NAME, null, "variablename", true, "Name of variable to get");
        this.addOption("m", "mode", null, MODE, null, "mode", false, "Override retrieve mode (strict, warn or liberal)");
    }

    @Override
    public String getName() {
        return "get_variable";
    }

    @Override
    public boolean canRetry() {
        return true;
    }

    @Override
    public boolean validateOptions() {
        String string;
        if (this.options.isSet(MODE) && !(string = this.options.getValue(MODE)).equals("strict") && !string.equals("warn") && !string.equals("liberal")) {
            if (!this.silent) {
                System.err.println("Invalid mode option");
            }
            return false;
        }
        return true;
    }

    @Override
    public int go() throws RetryException {
        String string = "GET PARAMETER ";
        if (this.options.isSet("USER")) {
            string = string + "OF " + this.options.getValue(JID);
        }
        string = string + " '" + this.options.getValue(NAME) + "'";
        if (this.options.isSet(MODE)) {
            string = string + " " + this.options.getValue(MODE).toUpperCase();
        }
        SDMSOutput sDMSOutput = this.execute(string);
        if (sDMSOutput.error != null) {
            this.printError(sDMSOutput.error);
            return 1;
        }
        System.out.println(SDMSOutputUtil.getFromRecord(sDMSOutput, "VALUE"));
        return 0;
    }

    public static void main(String[] stringArray) {
        System.exit(new get_variable().run(stringArray));
    }
}

