-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE INTERVAL_SELECTION (
    ID                             bigint NOT NULL
    , INT_ID                         bigint          NOT NULL
    , VALUE                          integer             NULL
    , PERIOD_FROM                    bigint              NULL
    , PERIOD_TO                      bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_INTERVAL_SELECTION
ON INTERVAL_SELECTION(ID);
CREATE VIEW SCI_INTERVAL_SELECTION AS
SELECT 
    ID 
    , INT_ID                         AS INT_ID
    , VALUE                          AS VALUE
    , PERIOD_FROM                    AS PERIOD_FROM
    , PERIOD_TO                      AS PERIOD_TO
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM INTERVAL_SELECTION;
