-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE KILL_JOB (
    ID                             bigint NOT NULL
    , SE_ID                          bigint          NOT NULL
    , SE_VERSION                     bigint          NOT NULL
    , SME_ID                         bigint          NOT NULL
    , SCOPE_ID                       bigint          NOT NULL
    , STATE                          integer         NOT NULL
    , EXIT_CODE                      integer             NULL
    , COMMANDLINE                    varchar(512)        NULL
    , LOGFILE                        varchar(512)        NULL
    , ERRLOGFILE                     varchar(512)        NULL
    , PID                            varchar(32)         NULL
    , EXTPID                         varchar(32)         NULL
    , ERROR_MSG                      varchar(256)        NULL
    , RUNNABLE_TS                    bigint              NULL
    , START_TS                       bigint              NULL
    , FINSH_TS                       bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_KILL_JOB
ON KILL_JOB(ID);
CREATE VIEW SCI_KILL_JOB AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , SE_VERSION                     AS SE_VERSION
    , SME_ID                         AS SME_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (STATE, 4, 'RUNNABLE', 5, 'STARTING', 6, 'STARTED', 7, 'RUNNING', 11, 'FINISHED', 13, 'BROKEN_ACTIVE', 14, 'BROKEN_FINISHED', 15, 'ERROR') AS STATE
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , PID                            AS PID
    , EXTPID                         AS EXTPID
    , ERROR_MSG                      AS ERROR_MSG
    , timestamp('1970-01-01-00.00.00') + int(mod(RUNNABLE_TS, 1125899906842624)/1000) seconds AS RUNNABLE_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(START_TS, 1125899906842624)/1000) seconds AS START_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(FINSH_TS, 1125899906842624)/1000) seconds AS FINSH_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM KILL_JOB;
CREATE TABLE ARC_KILL_JOB (
    ID                             bigint NOT NULL
    , SE_ID                          bigint           NULL
    , SE_VERSION                     bigint           NULL
    , SME_ID                         bigint           NULL
    , SCOPE_ID                       bigint           NULL
    , STATE                          integer          NULL
    , EXIT_CODE                      integer          NULL
    , COMMANDLINE                    varchar(512)     NULL
    , LOGFILE                        varchar(512)     NULL
    , ERRLOGFILE                     varchar(512)     NULL
    , PID                            varchar(32)      NULL
    , EXTPID                         varchar(32)      NULL
    , ERROR_MSG                      varchar(256)     NULL
    , RUNNABLE_TS                    bigint           NULL
    , START_TS                       bigint           NULL
    , FINSH_TS                       bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
