-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESSOURCE (
    ID                             bigint NOT NULL
    , NR_ID                          bigint          NOT NULL
    , SCOPE_ID                       bigint              NULL
    , MASTER_ID                      bigint              NULL
    , OWNER_ID                       bigint          NOT NULL
    , LINK_ID                        bigint              NULL
    , MANAGER_ID                     bigint              NULL
    , TAG                            varchar(64)         NULL
    , RSD_ID                         bigint              NULL
    , RSD_TIME                       bigint              NULL
    , DEFINED_AMOUNT                 integer             NULL
    , REQUESTABLE_AMOUNT             integer             NULL
    , AMOUNT                         integer             NULL
    , FREE_AMOUNT                    integer             NULL
    , IS_ONLINE                      integer             NULL
    , FACTOR                         float               NULL
    , TRACE_INTERVAL                 integer             NULL
    , TRACE_BASE                     integer             NULL
    , TRACE_BASE_MULTIPLIER          integer         NOT NULL
    , TD0_AVG                        float           NOT NULL
    , TD1_AVG                        float           NOT NULL
    , TD2_AVG                        float           NOT NULL
    , LW_AVG                         float           NOT NULL
    , LAST_EVAL                      bigint          NOT NULL
    , LAST_WRITE                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_RESSOURCE
ON RESSOURCE(ID);
CREATE VIEW SCI_RESSOURCE AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SCOPE_ID                       AS SCOPE_ID
    , MASTER_ID                      AS MASTER_ID
    , OWNER_ID                       AS OWNER_ID
    , LINK_ID                        AS LINK_ID
    , MANAGER_ID                     AS MANAGER_ID
    , TAG                            AS TAG
    , RSD_ID                         AS RSD_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(RSD_TIME, 1125899906842624)/1000) seconds AS RSD_TIME
    , DEFINED_AMOUNT                 AS DEFINED_AMOUNT
    , REQUESTABLE_AMOUNT             AS REQUESTABLE_AMOUNT
    , AMOUNT                         AS AMOUNT
    , FREE_AMOUNT                    AS FREE_AMOUNT
    , DECODE (IS_ONLINE, 1, 'TRUE', 0, 'FALSE') AS IS_ONLINE
    , FACTOR                         AS FACTOR
    , TRACE_INTERVAL                 AS TRACE_INTERVAL
    , TRACE_BASE                     AS TRACE_BASE
    , TRACE_BASE_MULTIPLIER          AS TRACE_BASE_MULTIPLIER
    , TD0_AVG                        AS TD0_AVG
    , TD1_AVG                        AS TD1_AVG
    , TD2_AVG                        AS TD2_AVG
    , LW_AVG                         AS LW_AVG
    , timestamp('1970-01-01-00.00.00') + int(mod(LAST_EVAL, 1125899906842624)/1000) seconds AS LAST_EVAL
    , timestamp('1970-01-01-00.00.00') + int(mod(LAST_WRITE, 1125899906842624)/1000) seconds AS LAST_WRITE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESSOURCE;
