-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE DEPENDENCY_DEFINITION (
    ID                             bigint NOT NULL
    , SE_DEPENDENT_ID                bigint          NOT NULL
    , SE_REQUIRED_ID                 bigint          NOT NULL
    , NAME                           lvarchar(64)        NULL
    , UNRESOLVED_HANDLING            int8            NOT NULL
    , DMODE                          int8            NOT NULL
    , STATE_SELECTION                int8            NOT NULL
    , CONDITION                      lvarchar(1024)      NULL
    , RESOLVE_MODE                   int8            NOT NULL
    , EXPIRED_AMOUNT                 int8                NULL
    , EXPIRED_BASE                   int8                NULL
    , SELECT_CONDITION               lvarchar(1024)      NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_DEPENDENCY_DEFINITION
ON DEPENDENCY_DEFINITION(ID);
CREATE VIEW SCI_C_DEPENDENCY_DEFINITION (ID,SE_DEPENDENT_ID,SE_REQUIRED_ID,NAME,UNRESOLVED_HANDLING,DMODE,STATE_SELECTION,CONDITION,RESOLVE_MODE,EXPIRED_AMOUNT,EXPIRED_BASE,SELECT_CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SE_DEPENDENT_ID                AS SE_DEPENDENT_ID
    , SE_REQUIRED_ID                 AS SE_REQUIRED_ID
    , NAME                           AS NAME
    , DECODE (UNRESOLVED_HANDLING, 1, 'IGNORE', 2, 'ERROR', 3, 'SUSPEND', 4, 'DEFER', 5, 'DEFER_IGNORE') AS UNRESOLVED_HANDLING
    , DECODE (DMODE, 1, 'ALL_FINAL', 2, 'JOB_FINAL') AS DMODE
    , DECODE (STATE_SELECTION, 0, 'FINAL', 1, 'ALL_REACHABLE', 2, 'UNREACHABLE', 3, 'DEFAULT') AS STATE_SELECTION
    , CONDITION                      AS CONDITION
    , DECODE (RESOLVE_MODE, 0, 'INTERNAL', 1, 'EXTERNAL', 2, 'BOTH') AS RESOLVE_MODE
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , SELECT_CONDITION               AS SELECT_CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM DEPENDENCY_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_DEPENDENCY_DEFINITION (ID,SE_DEPENDENT_ID,SE_REQUIRED_ID,NAME,UNRESOLVED_HANDLING,DMODE,STATE_SELECTION,CONDITION,RESOLVE_MODE,EXPIRED_AMOUNT,EXPIRED_BASE,SELECT_CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , SE_DEPENDENT_ID                AS SE_DEPENDENT_ID
    , SE_REQUIRED_ID                 AS SE_REQUIRED_ID
    , NAME                           AS NAME
    , DECODE (UNRESOLVED_HANDLING, 1, 'IGNORE', 2, 'ERROR', 3, 'SUSPEND', 4, 'DEFER', 5, 'DEFER_IGNORE') AS UNRESOLVED_HANDLING
    , DECODE (DMODE, 1, 'ALL_FINAL', 2, 'JOB_FINAL') AS DMODE
    , DECODE (STATE_SELECTION, 0, 'FINAL', 1, 'ALL_REACHABLE', 2, 'UNREACHABLE', 3, 'DEFAULT') AS STATE_SELECTION
    , CONDITION                      AS CONDITION
    , DECODE (RESOLVE_MODE, 0, 'INTERNAL', 1, 'EXTERNAL', 2, 'BOTH') AS RESOLVE_MODE
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , SELECT_CONDITION               AS SELECT_CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM DEPENDENCY_DEFINITION;
