-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SME_COUNTER (
    ID                             bigint NOT NULL
    , JAHR                           int8            NOT NULL
    , MONAT                          int8            NOT NULL
    , TAG                            int8            NOT NULL
    , ANZAHL                         int8            NOT NULL
    , CHECKSUM                       bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SME_COUNTER
ON SME_COUNTER(ID);
CREATE VIEW SCI_SME_COUNTER (ID,JAHR,MONAT,TAG,ANZAHL,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , JAHR                           AS JAHR
    , MONAT                          AS MONAT
    , TAG                            AS TAG
    , ANZAHL                         AS ANZAHL
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SME_COUNTER;
