-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE USER_PARAMETER (
    ID                             bigint NOT NULL
    , U_ID                           bigint          NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , VALUE                          lvarchar(256)       NULL
    , IS_LONG                        integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_USER_PARAMETER
ON USER_PARAMETER(ID);
CREATE VIEW SCI_USER_PARAMETER (ID,U_ID,NAME,VALUE,IS_LONG,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , U_ID                           AS U_ID
    , NAME                           AS NAME
    , VALUE                          AS VALUE
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM USER_PARAMETER;
