-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [EXIT_STATE_TRANSLATION] (
    [ID]                           decimal (38) NOT NULL
    , [ESTP_ID]                      decimal (38)    NOT NULL
    , [FROM_ESD_ID]                  decimal (38)    NOT NULL
    , [TO_ESD_ID]                    decimal (38)    NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
    , [VALID_FROM]                 decimal (38) NOT NULL
    , [VALID_TO]                   decimal (38) NOT NULL
);
go
CREATE INDEX PK_EXIT_STATE_TRANSLATION
ON [EXIT_STATE_TRANSLATION]([ID]);
go
CREATE VIEW SCI_C_EXIT_STATE_TRANSLATION AS
SELECT 
    ID 
    , [ESTP_ID]                      AS [ESTP_ID]
    , [FROM_ESD_ID]                  AS [FROM_ESD_ID]
    , [TO_ESD_ID]                    AS [TO_ESD_ID]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [EXIT_STATE_TRANSLATION]
 WHERE VALID_TO = 9223372036854775807;
go
CREATE VIEW SCI_V_EXIT_STATE_TRANSLATION AS
SELECT 
    ID 
    , [ESTP_ID]                      AS [ESTP_ID]
    , [FROM_ESD_ID]                  AS [FROM_ESD_ID]
    , [TO_ESD_ID]                    AS [TO_ESD_ID]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
    , VALID_FROM
    , VALID_TO
  FROM [EXIT_STATE_TRANSLATION];
go
