-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [KILL_JOB] (
    [ID]                           decimal (38) NOT NULL
    , [SE_ID]                        decimal (38)    NOT NULL
    , [SE_VERSION]                   decimal (38)    NOT NULL
    , [SME_ID]                       decimal (38)    NOT NULL
    , [SCOPE_ID]                     decimal (38)    NOT NULL
    , [STATE]                        integer         NOT NULL
    , [EXIT_CODE]                    integer             NULL
    , [COMMANDLINE]                  varchar(512)        NULL
    , [LOGFILE]                      varchar(512)        NULL
    , [ERRLOGFILE]                   varchar(512)        NULL
    , [PID]                          varchar(32)         NULL
    , [EXTPID]                       varchar(32)         NULL
    , [ERROR_MSG]                    varchar(256)        NULL
    , [RUNNABLE_TS]                  decimal (38)        NULL
    , [START_TS]                     decimal (38)        NULL
    , [FINSH_TS]                     decimal (38)        NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_KILL_JOB
ON [KILL_JOB]([ID]);
go
CREATE VIEW SCI_KILL_JOB AS
SELECT 
    ID 
    , [SE_ID]                        AS [SE_ID]
    , [SE_VERSION]                   AS [SE_VERSION]
    , [SME_ID]                       AS [SME_ID]
    , [SCOPE_ID]                     AS [SCOPE_ID]
    , CASE [STATE] WHEN 4 THEN 'RUNNABLE' WHEN 5 THEN 'STARTING' WHEN 6 THEN 'STARTED' WHEN 7 THEN 'RUNNING' WHEN 11 THEN 'FINISHED' WHEN 13 THEN 'BROKEN_ACTIVE' WHEN 14 THEN 'BROKEN_FINISHED' WHEN 15 THEN 'ERROR' END AS [STATE]
    , [EXIT_CODE]                    AS [EXIT_CODE]
    , [COMMANDLINE]                  AS [COMMANDLINE]
    , [LOGFILE]                      AS [LOGFILE]
    , [ERRLOGFILE]                   AS [ERRLOGFILE]
    , [PID]                          AS [PID]
    , [EXTPID]                       AS [EXTPID]
    , [ERROR_MSG]                    AS [ERROR_MSG]
    , dateadd(ss, round(([RUNNABLE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [RUNNABLE_TS]
    , dateadd(ss, round(([START_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [START_TS]
    , dateadd(ss, round(([FINSH_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [FINSH_TS]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [KILL_JOB];
go
CREATE TABLE ARC_KILL_JOB (
    ID                             decimal (38) NOT NULL
    , [SE_ID]                        decimal (38)     NULL
    , [SE_VERSION]                   decimal (38)     NULL
    , [SME_ID]                       decimal (38)     NULL
    , [SCOPE_ID]                     decimal (38)     NULL
    , [STATE]                        integer          NULL
    , [EXIT_CODE]                    integer          NULL
    , [COMMANDLINE]                  varchar(512)     NULL
    , [LOGFILE]                      varchar(512)     NULL
    , [ERRLOGFILE]                   varchar(512)     NULL
    , [PID]                          varchar(32)      NULL
    , [EXTPID]                       varchar(32)      NULL
    , [ERROR_MSG]                    varchar(256)     NULL
    , [RUNNABLE_TS]                  decimal (38)     NULL
    , [START_TS]                     decimal (38)     NULL
    , [FINSH_TS]                     decimal (38)     NULL
    , [CREATOR_U_ID]                 decimal (38)     NULL
    , [CREATE_TS]                    decimal (38)     NULL
    , [CHANGER_U_ID]                 decimal (38)     NULL
    , [CHANGE_TS]                    decimal (38)     NULL
);
go
