-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [USER_PARAMETER] (
    [ID]                           decimal (38) NOT NULL
    , [U_ID]                         decimal (38)    NOT NULL
    , [NAME]                         varchar(64)     NOT NULL
    , [VALUE]                        varchar(256)        NULL
    , [IS_LONG]                      integer         NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_USER_PARAMETER
ON [USER_PARAMETER]([ID]);
go
CREATE VIEW SCI_USER_PARAMETER AS
SELECT 
    ID 
    , [U_ID]                         AS [U_ID]
    , [NAME]                         AS [NAME]
    , [VALUE]                        AS [VALUE]
    , CASE [IS_LONG] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_LONG]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [USER_PARAMETER];
go
