-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE `INTERVAL_HIERARCHY` (
    `ID`                           decimal(20) NOT NULL
    , `CHILD_ID`                     decimal(20)     NOT NULL
    , `PARENT_ID`                    decimal(20)     NOT NULL
    , `CREATOR_U_ID`                 decimal(20)     NOT NULL
    , `CREATE_TS`                    decimal(20)     NOT NULL
    , `CHANGER_U_ID`                 decimal(20)     NOT NULL
    , `CHANGE_TS`                    decimal(20)     NOT NULL
) ENGINE = INNODB;
CREATE UNIQUE INDEX PK_INTERVAL_HIERARCHY
ON `INTERVAL_HIERARCHY`(`ID`);
CREATE VIEW SCI_INTERVAL_HIERARCHY AS
SELECT 
    ID 
    , `CHILD_ID`                     AS `CHILD_ID`
    , `PARENT_ID`                    AS `PARENT_ID`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
  FROM `INTERVAL_HIERARCHY`;
