-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE `OBJECT_INSTANCE` (
    `ID`                           decimal(20) NOT NULL
    , `UNIQUE_NAME`                  varchar(256)    NOT NULL
    , `OM_ID`                        decimal(20)     NOT NULL
    , `MODIFY_TS`                    decimal(20)         NULL
    , `REMOVE_TS`                    decimal(20)         NULL
    , `CREATOR_U_ID`                 decimal(20)     NOT NULL
    , `CREATE_TS`                    decimal(20)     NOT NULL
    , `CHANGER_U_ID`                 decimal(20)     NOT NULL
    , `CHANGE_TS`                    decimal(20)     NOT NULL
) ENGINE = INNODB;
CREATE UNIQUE INDEX PK_OBJECT_INSTANCE
ON `OBJECT_INSTANCE`(`ID`);
CREATE VIEW SCI_OBJECT_INSTANCE AS
SELECT 
    ID 
    , `UNIQUE_NAME`                  AS `UNIQUE_NAME`
    , `OM_ID`                        AS `OM_ID`
    , from_unixtime((`MODIFY_TS` & ~1125899906842624)/1000) AS `MODIFY_TS`
    , from_unixtime((`REMOVE_TS` & ~1125899906842624)/1000) AS `REMOVE_TS`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
  FROM `OBJECT_INSTANCE`;
