-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE `RESOURCE_STATE_MAPPING` (
    `ID`                           decimal(20) NOT NULL
    , `RSMP_ID`                      decimal(20)     NOT NULL
    , `ESD_ID`                       decimal(20)     NOT NULL
    , `FROM_RSD_ID`                  decimal(20)         NULL
    , `TO_RSD_ID`                    decimal(20)     NOT NULL
    , `CREATOR_U_ID`                 decimal(20)     NOT NULL
    , `CREATE_TS`                    decimal(20)     NOT NULL
    , `CHANGER_U_ID`                 decimal(20)     NOT NULL
    , `CHANGE_TS`                    decimal(20)     NOT NULL
    , `VALID_FROM`                 decimal(20) NOT NULL
    , `VALID_TO`                   decimal(20) NOT NULL
) ENGINE = INNODB;
CREATE INDEX PK_RESOURCE_STATE_MAPPING
ON `RESOURCE_STATE_MAPPING`(`ID`);
CREATE VIEW SCI_C_RESOURCE_STATE_MAPPING AS
SELECT 
    ID 
    , `RSMP_ID`                      AS `RSMP_ID`
    , `ESD_ID`                       AS `ESD_ID`
    , `FROM_RSD_ID`                  AS `FROM_RSD_ID`
    , `TO_RSD_ID`                    AS `TO_RSD_ID`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
  FROM `RESOURCE_STATE_MAPPING`
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_STATE_MAPPING AS
SELECT 
    ID 
    , `RSMP_ID`                      AS `RSMP_ID`
    , `ESD_ID`                       AS `ESD_ID`
    , `FROM_RSD_ID`                  AS `FROM_RSD_ID`
    , `TO_RSD_ID`                    AS `TO_RSD_ID`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
    , VALID_FROM
    , VALID_TO
  FROM `RESOURCE_STATE_MAPPING`;
