-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXIT_STATE (
    ID                             NUMBER (38) NOT NULL
    , PREFERENCE                     NUMBER (38)          NOT NULL
    , IS_FINAL                       NUMBER (1)           NOT NULL
    , IS_RESTARTABLE                 NUMBER (1)           NOT NULL
    , IS_UNREACHABLE                 NUMBER (1)           NOT NULL
    , IS_DISABLED                    NUMBER (1)           NOT NULL
    , IS_BROKEN                      NUMBER (1)           NOT NULL
    , IS_BATCH_DEFAULT               NUMBER (1)           NOT NULL
    , IS_DEPENDENCY_DEFAULT          NUMBER (1)           NOT NULL
    , ESP_ID                         NUMBER (38)          NOT NULL
    , ESD_ID                         NUMBER (38)          NOT NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
    , VALID_FROM                   NUMBER (38) NOT NULL
    , VALID_TO                     NUMBER (38) NOT NULL
    , PRIMARY KEY (ID, VALID_TO)
);
CREATE OR REPLACE VIEW SCI_C_EXIT_STATE AS
SELECT 
    ID 
    , PREFERENCE                     AS PREFERENCE
    , DECODE (IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS IS_FINAL
    , DECODE (IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS IS_RESTARTABLE
    , DECODE (IS_UNREACHABLE, 1, 'TRUE', 0, 'FALSE') AS IS_UNREACHABLE
    , DECODE (IS_DISABLED, 1, 'TRUE', 0, 'FALSE') AS IS_DISABLED
    , DECODE (IS_BROKEN, 1, 'TRUE', 0, 'FALSE') AS IS_BROKEN
    , DECODE (IS_BATCH_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_BATCH_DEFAULT
    , DECODE (IS_DEPENDENCY_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_DEPENDENCY_DEFAULT
    , ESP_ID                         AS ESP_ID
    , ESD_ID                         AS ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM EXIT_STATE
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_EXIT_STATE AS
SELECT 
    ID 
    , PREFERENCE                     AS PREFERENCE
    , DECODE (IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS IS_FINAL
    , DECODE (IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS IS_RESTARTABLE
    , DECODE (IS_UNREACHABLE, 1, 'TRUE', 0, 'FALSE') AS IS_UNREACHABLE
    , DECODE (IS_DISABLED, 1, 'TRUE', 0, 'FALSE') AS IS_DISABLED
    , DECODE (IS_BROKEN, 1, 'TRUE', 0, 'FALSE') AS IS_BROKEN
    , DECODE (IS_BATCH_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_BATCH_DEFAULT
    , DECODE (IS_DEPENDENCY_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_DEPENDENCY_DEFAULT
    , ESP_ID                         AS ESP_ID
    , ESD_ID                         AS ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE;
