-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXIT_STATE_TRANSLATION (
    ID                             decimal(20) NOT NULL
    , ESTP_ID                        decimal(20)     NOT NULL
    , FROM_ESD_ID                    decimal(20)     NOT NULL
    , TO_ESD_ID                      decimal(20)     NOT NULL
    , CREATOR_U_ID                   decimal(20)     NOT NULL
    , CREATE_TS                      decimal(20)     NOT NULL
    , CHANGER_U_ID                   decimal(20)     NOT NULL
    , CHANGE_TS                      decimal(20)     NOT NULL
    , VALID_FROM                   decimal(20) NOT NULL
    , VALID_TO                     decimal(20) NOT NULL
);
CREATE INDEX PK_EXIT_STATE_TRANSLATION
ON EXIT_STATE_TRANSLATION(ID);
CREATE VIEW SCI_C_EXIT_STATE_TRANSLATION AS
SELECT 
    ID 
    , ESTP_ID                        AS ESTP_ID
    , FROM_ESD_ID                    AS FROM_ESD_ID
    , TO_ESD_ID                      AS TO_ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamptz 'epoch' + cast(to_char(mod(CREATE_TS, 1125899906842624)/1000, '999999999999') as interval) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamptz 'epoch' + cast(to_char(mod(CHANGE_TS, 1125899906842624)/1000, '999999999999') as interval) AS CHANGE_TS
  FROM EXIT_STATE_TRANSLATION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_TRANSLATION AS
SELECT 
    ID 
    , ESTP_ID                        AS ESTP_ID
    , FROM_ESD_ID                    AS FROM_ESD_ID
    , TO_ESD_ID                      AS TO_ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamptz 'epoch' + cast(to_char(mod(CREATE_TS, 1125899906842624)/1000, '999999999999') as interval) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamptz 'epoch' + cast(to_char(mod(CHANGE_TS, 1125899906842624)/1000, '999999999999') as interval) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_TRANSLATION;
