-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE POOL_DISTRIBUTION (
    ID                             decimal(20) NOT NULL
    , NAME                           varchar(64)     NOT NULL
    , P_ID                           decimal(20)     NOT NULL
    , CREATOR_U_ID                   decimal(20)     NOT NULL
    , CREATE_TS                      decimal(20)     NOT NULL
    , CHANGER_U_ID                   decimal(20)     NOT NULL
    , CHANGE_TS                      decimal(20)     NOT NULL
);
CREATE UNIQUE INDEX PK_POOL_DISTRIBUTION
ON POOL_DISTRIBUTION(ID);
CREATE VIEW SCI_POOL_DISTRIBUTION AS
SELECT 
    ID 
    , NAME                           AS NAME
    , P_ID                           AS P_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamptz 'epoch' + cast(to_char(mod(CREATE_TS, 1125899906842624)/1000, '999999999999') as interval) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamptz 'epoch' + cast(to_char(mod(CHANGE_TS, 1125899906842624)/1000, '999999999999') as interval) AS CHANGE_TS
  FROM POOL_DISTRIBUTION;
