/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.SDMSDesktop;

import de.independit.scheduler.SDMSDesktop.MiniParse;
import de.independit.scheduler.SDMSDesktop.SDMSDesktop;
import de.independit.scheduler.SDMSDesktop.SDMSDesktopWindow;
import de.independit.scheduler.server.output.SDMSLineRenderer;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class SDMSShellWindow
extends SDMSDesktopWindow {
    public static final String __version = "@(#) $Id: SDMSShellWindow.java,v 2.0.20.1 2013/03/14 10:24:04 ronald Exp $";
    Document outputDocument;
    JScrollPane outputScrollPane;
    JTextPane outputTextPane;
    Document inputDocument;
    JScrollPane inputScrollPane;
    JTextPane inputTextPane;
    public JSplitPane splitPane;

    public SDMSShellWindow(SDMSDesktop sDMSDesktop, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(sDMSDesktop, string, bl, bl2, bl3, bl4);
        this.setBounds(20, 20, 600, 400);
        this.setFrameIcon(new ImageIcon(SDMSDesktop.class.getResource("SDMSShellIconSmall.gif")));
        this.menuItem.setMnemonic('s');
        this.toolBarButton.setIcon(new ImageIcon(SDMSDesktop.class.getResource("SDMSShellIcon.gif")));
        this.doesRefresh = false;
        this.doesDrop = false;
        this.doesCreate = false;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.outputTextPane = new JTextPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }
        };
        this.outputTextPane.setEditable(false);
        this.initStyles(this.outputTextPane);
        this.outputDocument = this.outputTextPane.getDocument();
        this.outputScrollPane = new JScrollPane(this.outputTextPane);
        this.outputScrollPane.setBackground(Color.white);
        this.outputScrollPane.getViewport().setBackground(Color.white);
        this.outputScrollPane.setHorizontalScrollBarPolicy(30);
        this.outputScrollPane.setVerticalScrollBarPolicy(22);
        this.inputTextPane = new JTextPane();
        this.initStyles(this.inputTextPane);
        this.inputDocument = this.inputTextPane.getDocument();
        this.inputScrollPane = new JScrollPane(this.inputTextPane);
        this.splitPane = new JSplitPane(0, this.outputScrollPane, this.inputScrollPane);
        this.splitPane.setDividerLocation(0.1);
        this.getContentPane().add((Component)this.splitPane, "Center");
        JButton jButton = new JButton(new ImageIcon(SDMSDesktop.class.getResource("RunCurrentSmall.gif")));
        jButton.setToolTipText("Run Current Statement");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SDMSShellWindow.this.runCurrent();
            }
        });
        this.toolBar.add(jButton);
        JButton jButton2 = new JButton(new ImageIcon(SDMSDesktop.class.getResource("RunSelectionSmall.gif")));
        jButton2.setToolTipText("Run Selection");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SDMSShellWindow.this.runSelection();
            }
        });
        this.toolBar.add(jButton2);
        JButton jButton3 = new JButton(new ImageIcon(SDMSDesktop.class.getResource("RunAllSmall.gif")));
        jButton3.setToolTipText("Run All");
        jButton3.setFocusable(false);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SDMSShellWindow.this.runAll();
            }
        });
        this.toolBar.add(jButton3);
        JButton jButton4 = new JButton(new ImageIcon(SDMSDesktop.class.getResource("WipeInputIconSmall.gif")));
        jButton4.setToolTipText("Clear Input");
        jButton4.setFocusable(false);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SDMSShellWindow.this.inputDocument.remove(0, SDMSShellWindow.this.inputDocument.getLength());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.toolBar.add(jButton4);
        JButton jButton5 = new JButton(new ImageIcon(SDMSDesktop.class.getResource("WipeOutputIconSmall.gif")));
        jButton5.setToolTipText("Clear Output");
        jButton5.setFocusable(false);
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SDMSShellWindow.this.outputDocument.remove(0, SDMSShellWindow.this.outputDocument.getLength());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.toolBar.add(jButton5);
    }

    private void runAll() {
        this.runCommands(this.inputTextPane.getText());
    }

    private void runSelection() {
        String string = this.inputTextPane.getSelectedText();
        if (string == null) {
            return;
        }
        this.runCommands(string);
    }

    private void runCurrent() {
        String string = this.inputTextPane.getText();
        String string2 = null;
        int n = this.inputTextPane.getCaretPosition();
        if (n > 0) {
            --n;
        }
        MiniParse miniParse = new MiniParse(new StringReader(string));
        try {
            while (miniParse.advance()) {
                if (miniParse.pos() < n) continue;
                string2 = miniParse.value().toString();
                if (string2 != null) {
                    this.runCommands(string2);
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getInputString() {
        String string = "";
        int n = 0;
        try {
            n = this.inputDocument.getEndPosition().getOffset();
            string = this.inputDocument.getText(0, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private void runCommands(String string) {
        if (string == null) {
            return;
        }
        MiniParse miniParse = new MiniParse(new StringReader(string));
        try {
            String string2;
            while (miniParse.advance() && this.runCommand(string2 = miniParse.value().toString())) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean runCommand(String string) {
        SDMSLineRenderer sDMSLineRenderer = new SDMSLineRenderer();
        SDMSOutput sDMSOutput = this.desktop.serverConnection.execute(string);
        if (sDMSOutput.error != null) {
            JOptionPane.showMessageDialog(this, "ERROR: " + sDMSOutput.error.code + "\n TEXT: " + sDMSOutput.error.message, "Error", 0);
            return false;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        try {
            ((SDMSOutputRenderer)sDMSLineRenderer).render(new PrintStream(byteArrayOutputStream), sDMSOutput);
            this.outputDocument.insertString(this.outputDocument.getLength(), byteArrayOutputStream.toString(), this.outputTextPane.getStyle("regular"));
            JScrollBar jScrollBar = this.outputScrollPane.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getMaximum());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return true;
    }

    private void initStyles(JTextPane jTextPane) {
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = jTextPane.addStyle("regular", style);
        StyleConstants.setFontFamily(style, "Courier");
        Style style3 = jTextPane.addStyle("italic", style2);
        StyleConstants.setItalic(style3, true);
        jTextPane.setLogicalStyle(style2);
    }
}

