/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.jobserver;

import de.independit.scheduler.jobserver.Config;
import de.independit.scheduler.jobserver.Descr;
import de.independit.scheduler.jobserver.Environment;
import de.independit.scheduler.jobserver.Feil;
import de.independit.scheduler.jobserver.JobServer;
import de.independit.scheduler.jobserver.TimeoutThread;
import de.independit.scheduler.jobserver.Trace;
import de.independit.scheduler.jobserver.Utils;
import de.independit.scheduler.jobserver.WakeupThread;
import de.independit.scheduler.server.dump.Dump;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.output.SDMSOutputLabel;
import de.independit.scheduler.server.parser.ScopeConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.HashSet;
import java.util.Vector;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;

public class RepoIface {
    public static final int NOP = 0;
    public static final int START_JOB = 1;
    public static final int SHUTDOWN_SERVER = 2;
    public static final int DISPOSE_JOB = 3;
    public static boolean FATAL = true;
    public static boolean NONFATAL = false;
    public static final String JS_ALREADY_CONNECTED = "Server already connected";
    public static final String COMMAND = "COMMAND";
    public static final String CMD_NOP = "NOP";
    public static final String CMD_SHUTDOWN = "SHUTDOWN";
    public static final String CMD_STARTJOB = "STARTJOB";
    public static final String STARTJOB_ID = "ID";
    public static final String STARTJOB_RUN = "RUN";
    public static final String STARTJOB_CMD = "CMD";
    public static final String STARTJOB_ARGS = "ARGS";
    public static final String STARTJOB_DIR = "DIR";
    public static final String STARTJOB_LOG = "LOG";
    public static final String STARTJOB_LOGAPP = "LOGAPP";
    public static final String STARTJOB_ERR = "ERR";
    public static final String STARTJOB_ERRAPP = "ERRAPP";
    public static final String STARTJOB_ENV = "ENV";
    public static final String STARTJOB_JOBENV = "JOBENV";
    public static final String CMD_ALTER = "ALTER";
    public static final String ALTER_CONFIG = "CONFIG";
    public static final String CMD_DISPOSE = "DISPOSE";
    public static final int SO_TIMEOUT = 240000;
    private static final String[] REQUIRED_CONFIG = new String[]{"REPOUSER", "REPOPASS", "DEFAULTWORKDIR", "JOBEXECUTOR", "JOBFILEPREFIX"};
    private static final String[] REPO_HOST_REPO_PORT = new String[]{"REPOHOST", "REPOPORT"};
    private String currentHost;
    private int currentPort;
    private final String mypid = Utils.getMyPid();
    private final Config cfg;
    private static Object sslInitLock = new Object();
    private static String keyFile = null;
    private static String trustFile = null;
    private static String keyFilePw = null;
    private static String trustFilePw = null;
    private static char[] ksPass;
    private static KeyStore ks;
    private static KeyManagerFactory kmf;
    private static SSLContext sc;
    private Socket repoSock = null;
    private PrintStream repoOut = null;
    private ObjectInputStream repoInp = null;
    private boolean request_reconnect = false;
    private Descr jobData;
    private boolean isConnected = false;

    public final synchronized String getHost() {
        return this.currentHost;
    }

    public final synchronized int getPort() {
        return this.currentPort;
    }

    public final boolean isConnected() {
        return this.isConnected;
    }

    private final SDMSOutput sdmsExec(String string) {
        while (true) {
            if (!this.isConnected) {
                this.openConnection();
            }
            Trace.debug("> " + string);
            TimeoutThread timeoutThread = new TimeoutThread(300L);
            try {
                timeoutThread.setExecuting(true);
                timeoutThread.start();
                this.repoOut.print(string);
                if (!this.repoOut.checkError()) {
                    this.repoInp = new ObjectInputStream(this.repoSock.getInputStream());
                    SDMSOutput sDMSOutput = (SDMSOutput)this.repoInp.readObject();
                    Trace.debug("< " + Trace.dump(sDMSOutput));
                    timeoutThread.setExecuting(false);
                    timeoutThread.interrupt();
                    return sDMSOutput;
                }
            }
            catch (IOException iOException) {
                timeoutThread.setExecuting(false);
                timeoutThread.interrupt();
                Trace.error("(04504092058) Error executing command (" + string + "): " + iOException.getMessage() + " (" + iOException.getClass().getName() + ")");
                this.closeConnection();
                this.openConnection();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Utils.abortProgram("(04301271453) Cannot execute command (" + string + "): " + classNotFoundException.getMessage() + " (" + classNotFoundException.getClass().getName() + ")");
            }
            if (!this.repoOut.checkError()) continue;
            timeoutThread.setExecuting(false);
            timeoutThread.interrupt();
            Trace.error("(04504092058) Error executing command (" + string + ")");
            this.closeConnection();
            this.openConnection();
        }
    }

    private final boolean evaluateConfig(SDMSOutputContainer sDMSOutputContainer) {
        Object object;
        String string;
        int n;
        int n2;
        Vector vector;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet hashSet2 = null;
        boolean bl = true;
        this.cfg.remove("NAME_PATTERN_");
        if (sDMSOutputContainer != null) {
            Vector vector2 = sDMSOutputContainer.desc;
            vector = sDMSOutputContainer.dataset;
            n2 = vector2.size();
            for (n = 0; n < n2; ++n) {
                string = ((SDMSOutputLabel)vector2.get((int)n)).name;
                if (ScopeConfig.isInternalEntry(string)) continue;
                object = ((Vector)vector.get(0)).get(n);
                if (string.equals("DYNAMIC")) {
                    hashSet2 = (HashSet)object;
                    continue;
                }
                hashSet.add(string);
                try {
                    if (string.equals("REPOPASS")) continue;
                    Object object2 = this.cfg.put(string, object);
                    if (!Utils.isOneOf(string, REPO_HOST_REPO_PORT) || object.toString().equals(object2.toString())) continue;
                    this.request_reconnect = true;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.notifyError(NONFATAL, "(04305141859) Invalid config entry: " + string + "=" + object + ": " + illegalArgumentException.getMessage());
                    bl = false;
                }
            }
        }
        for (int i = 0; i < REQUIRED_CONFIG.length; ++i) {
            if (hashSet.contains(REQUIRED_CONFIG[i])) continue;
            this.notifyError(NONFATAL, "(04305141920) Missing required config entry: " + REQUIRED_CONFIG[i]);
            bl = false;
        }
        if (bl) {
            Vector vector3 = new Vector(this.cfg.keySet());
            int n3 = vector3.size();
            for (n2 = 0; n2 < n3; ++n2) {
                String string2 = (String)vector3.get(n2);
                if (hashSet.contains(string2) || Utils.isOneOf(string2, REPO_HOST_REPO_PORT) || string2.equals("NAME_PATTERN_")) continue;
                this.cfg.remove(string2);
            }
        }
        if (bl && hashSet2 != null && !hashSet2.isEmpty()) {
            Vector<String> vector4 = new Vector<String>(hashSet2.size());
            vector = new Vector(hashSet2);
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                string = (String)vector.get(n);
                object = (String)Environment.getSystemEnvironment().get(string);
                vector4.add(Dump.quotedString(string) + "=" + Dump.quotedString((String)(object == null ? "" : object)));
            }
            SDMSOutput sDMSOutput = this.sdmsExec("alter jobserver with dynamic parameters = (" + Dump.join(", ", vector4) + ");");
            if (sDMSOutput.error != null) {
                Utils.abortProgram(this, "(04307160007) Unexpected response: (" + sDMSOutput.error.code + ") " + sDMSOutput.error.message);
            }
        }
        WakeupThread wakeupThread = WakeupThread.getInstance(this.cfg);
        wakeupThread.interrupt();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean connect(String string, int n, boolean bl) {
        this.currentHost = string;
        this.currentPort = n;
        String string2 = (String)this.cfg.get("REPOUSER");
        String string3 = (String)this.cfg.get("REPOPASS");
        Object object = sslInitLock;
        synchronized (object) {
            if (bl && trustFile == null) {
                keyFile = (String)this.cfg.get("KEYSTORE");
                trustFile = (String)this.cfg.get("TRUSTSTORE");
                keyFilePw = (String)this.cfg.get("KEYSTOREPASSWORD");
                trustFilePw = (String)this.cfg.get("TRUSTSTOREPASSWORD");
                if (keyFilePw != null && keyFile != null) {
                    System.setProperty("javax.net.ssl.keyStore", keyFile);
                    System.setProperty("javax.net.ssl.keyStorePassword", keyFilePw);
                    ksPass = keyFilePw.toCharArray();
                    try {
                        ks = KeyStore.getInstance("JKS");
                        ks.load(new FileInputStream(keyFile), ksPass);
                    }
                    catch (Exception exception) {
                        Trace.error("Error occured while evaluating SSL KeyStore : " + exception.toString());
                    }
                }
                if (trustFilePw != null && trustFile != null) {
                    System.setProperty("javax.net.ssl.trustStore", trustFile);
                    System.setProperty("javax.net.ssl.trustStorePassword", trustFilePw);
                }
                try {
                    kmf = KeyManagerFactory.getInstance("SunX509");
                    if (ks == null) {
                        kmf.init(null, null);
                    } else {
                        kmf.init(ks, ksPass);
                    }
                    sc = SSLContext.getInstance("SSL");
                    sc.init(kmf.getKeyManagers(), null, null);
                }
                catch (Exception exception) {
                    Trace.error("Error occured while initializing SSL context : " + exception.toString());
                }
            }
        }
        Trace.debug("Trying " + string2 + "@" + this.currentHost + ":" + this.currentPort + (bl ? " (ssl) " : "") + "...");
        this.request_reconnect = false;
        try {
            if (bl) {
                object = sc.getSocketFactory();
                SSLSocket sSLSocket = (SSLSocket)((SocketFactory)object).createSocket(InetAddress.getByName(this.currentHost), this.currentPort);
                sSLSocket.startHandshake();
                this.repoSock = sSLSocket;
            } else {
                this.repoSock = new Socket();
                this.repoSock.setPerformancePreferences(0, 1, 0);
                this.repoSock.setTcpNoDelay(true);
                this.repoSock.connect(new InetSocketAddress(InetAddress.getByName(this.currentHost), this.currentPort));
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.error("(04301271454) " + this.currentHost + ": Host unknown");
            this.isConnected = false;
            return false;
        }
        catch (IOException iOException) {
            Trace.error("(04301271455) " + this.currentHost + ":" + this.currentPort + ": " + iOException.getMessage() + " (" + iOException.getClass().getName() + ")");
            this.isConnected = false;
            return false;
        }
        try {
            this.repoSock.setSoTimeout(240000);
        }
        catch (SocketException socketException) {
            Trace.error("(03407161423) Cannot set Timeout on socket: " + socketException.getMessage() + " (" + socketException.getClass().getName() + ")");
            try {
                this.repoSock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.isConnected = false;
            return false;
        }
        try {
            this.repoOut = new PrintStream(this.repoSock.getOutputStream(), true, "UTF8");
        }
        catch (IOException iOException) {
            Trace.error("(04301271456) Cannot establish socket output stream: " + iOException.getMessage() + " (" + iOException.getClass().getName() + ")");
            this.isConnected = false;
            return false;
        }
        this.isConnected = true;
        object = this.sdmsExec("connect jobserver " + string2 + " identified by '" + Utils.quoted(string3) + "' with protocol = serial, session = '" + JobServer.session_info + "';");
        if (((SDMSOutput)object).error != null) {
            if (((SDMSOutput)object).error.message.equals(JS_ALREADY_CONNECTED)) {
                Utils.abortProgram("(04301271457) Cannot connect: (" + ((SDMSOutput)object).error.code + ") " + ((SDMSOutput)object).error.message);
            }
            Trace.error("(04301271458) Cannot connect: (" + ((SDMSOutput)object).error.code + ") " + ((SDMSOutput)object).error.message);
            this.isConnected = false;
            return false;
        }
        object = this.sdmsExec("register with pid = '" + Utils.quoted(this.mypid) + "';");
        if (((SDMSOutput)object).error != null) {
            Trace.error("(04301271459) Cannot register: (" + ((SDMSOutput)object).error.code + ") " + ((SDMSOutput)object).error.message);
            this.isConnected = false;
            return false;
        }
        return this.evaluateConfig(((SDMSOutput)object).container);
    }

    private final void openConnection() {
        boolean bl = false;
        while (true) {
            Boolean bl2;
            if ((bl2 = (Boolean)this.cfg.get("USE_SSL")) == null) {
                bl2 = Boolean.FALSE;
            }
            if (this.connect((String)this.cfg.get("REPOHOST"), ((Long)this.cfg.get("REPOPORT")).intValue(), bl2) && !this.request_reconnect) break;
            if (!this.request_reconnect) {
                bl = true;
            }
            this.closeConnection();
            if (this.request_reconnect) continue;
            Utils.sleep((Long)this.cfg.get("RECONNECTDELAY"));
        }
        if (bl) {
            Trace.info("(04305151959) Connected!");
        }
    }

    private final void closeConnection() {
        if (this.repoOut != null) {
            this.repoOut.close();
            this.repoOut = null;
        }
        if (this.repoInp != null) {
            try {
                this.repoInp.close();
            }
            catch (IOException iOException) {
                Trace.error("(03004261219) Error closing input stream: " + iOException.getMessage() + " (" + iOException.getClass().getName() + ")");
            }
            this.repoInp = null;
        }
        if (this.repoSock != null) {
            try {
                this.repoSock.close();
            }
            catch (IOException iOException) {
                Trace.error("(04301271500) Error closing socket: " + iOException.getMessage() + " (" + iOException.getClass().getName() + ")");
            }
            this.repoSock = null;
        }
        this.isConnected = false;
    }

    public RepoIface(Config config) {
        this.cfg = config;
        this.openConnection();
    }

    private static final Object getByName(SDMSOutputContainer sDMSOutputContainer, String string) {
        int n = sDMSOutputContainer.indexForName(null, string);
        Vector vector = (Vector)sDMSOutputContainer.dataset.get(0);
        Object e = vector.get(n);
        return e;
    }

    private static final boolean isSameFile(File file, File file2) {
        if (file == null || file2 == null) {
            return false;
        }
        try {
            return file.getCanonicalFile().equals(file2.getCanonicalFile());
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile().equals(file2.getAbsoluteFile());
        }
    }

    private final Descr collectJobData(SDMSOutput sDMSOutput) {
        String string = (String)RepoIface.getByName(sDMSOutput.container, STARTJOB_CMD);
        if (string == null || string.equals("")) {
            Utils.abortProgram(this, "(03310171401) Invalid run command");
        }
        File file = RepoIface.getFile(sDMSOutput, STARTJOB_LOG);
        File file2 = RepoIface.getFile(sDMSOutput, STARTJOB_ERR);
        File file3 = RepoIface.getFile(sDMSOutput, STARTJOB_DIR);
        File file4 = file3 != null ? file3 : (File)this.cfg.get("DEFAULTWORKDIR");
        Object object = RepoIface.getByName(sDMSOutput.container, STARTJOB_ID);
        if (object == null) {
            Utils.abortProgram(this, "(04301271501) No job id received");
        }
        long l = (Long)object;
        object = RepoIface.getByName(sDMSOutput.container, STARTJOB_RUN);
        int n = object == null ? 0 : (Integer)object;
        Vector vector = (Vector)RepoIface.getByName(sDMSOutput.container, STARTJOB_ARGS);
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        boolean bl = false;
        if (file != null) {
            object = RepoIface.getByName(sDMSOutput.container, STARTJOB_LOGAPP);
            bl = object != null ? (Boolean)object : false;
        }
        boolean bl2 = false;
        if (file2 != null) {
            object = RepoIface.getByName(sDMSOutput.container, STARTJOB_ERRAPP);
            bl2 = object != null ? (Boolean)object : false;
        }
        boolean bl3 = RepoIface.isSameFile(file, file2);
        Environment environment = null;
        vector = (Vector)RepoIface.getByName(sDMSOutput.container, STARTJOB_ENV);
        if (vector != null) {
            if (vector.size() % 2 != 0) {
                Utils.abortProgram(this, "(04301271502) Invalid environment received: " + vector);
            }
            environment = new Environment(vector);
        }
        Environment environment2 = null;
        vector = (Vector)RepoIface.getByName(sDMSOutput.container, STARTJOB_JOBENV);
        if (vector != null) {
            if (vector.size() % 2 != 0) {
                Utils.abortProgram(this, "(04301271502) Invalid job environment received: " + vector);
            }
            environment2 = new Environment(vector);
        }
        return new Descr(l, n, string, stringArray, file4, file, bl, file2, bl2, bl3, environment, environment2);
    }

    private static final File getFile(SDMSOutput sDMSOutput, String string) {
        Object object = RepoIface.getByName(sDMSOutput.container, string);
        return object == null ? null : new File((String)object);
    }

    public final synchronized int getNextCmd() {
        while (true) {
            SDMSOutput sDMSOutput = this.sdmsExec("get next job;");
            boolean bl = (Boolean)this.cfg.get("ONLINE_SERVER");
            if (sDMSOutput.error != null) {
                if (!bl) {
                    this.closeConnection();
                }
                return 0;
            }
            String string = (String)RepoIface.getByName(sDMSOutput.container, COMMAND);
            if (string.equals(CMD_NOP)) {
                if (!bl) {
                    this.closeConnection();
                }
                return 0;
            }
            if (string.equals(CMD_STARTJOB)) {
                this.jobData = this.collectJobData(sDMSOutput);
                return 1;
            }
            if (string.equals(CMD_SHUTDOWN)) {
                return 2;
            }
            if (string.equals(CMD_ALTER)) {
                this.evaluateConfig((SDMSOutputContainer)RepoIface.getByName(sDMSOutput.container, ALTER_CONFIG));
                if (!this.request_reconnect) continue;
                this.closeConnection();
                this.openConnection();
                continue;
            }
            this.notifyError(NONFATAL, "(04301271503) Unknown/unexpected command received: " + string);
        }
    }

    public final synchronized Descr getJobData() {
        return this.jobData;
    }

    public final synchronized int reassureJob(Feil feil) {
        String string = "reassure " + feil.getId() + ";";
        SDMSOutput sDMSOutput = this.sdmsExec(string);
        if (sDMSOutput.error != null) {
            if (sDMSOutput.error.code.equals("03110251037")) {
                Trace.error("Server responded with a not found error for job " + feil.getId());
                Trace.error("The issued command was:");
                Trace.error(string);
                if (!feil.emergency_rename()) {
                    // empty if block
                }
            } else {
                Utils.abortProgram(this, "(04301271504) Unexpected response: (" + sDMSOutput.error.code + ") " + sDMSOutput.error.message);
            }
        }
        String string2 = (String)RepoIface.getByName(sDMSOutput.container, COMMAND);
        int n = 0;
        if (string2.equals(CMD_STARTJOB)) {
            this.jobData = this.collectJobData(sDMSOutput);
            n = 1;
        } else if (string2.equals(CMD_DISPOSE)) {
            n = 3;
        } else if (string2.equals(CMD_SHUTDOWN)) {
            n = 2;
        } else {
            Utils.abortProgram(this, "(04301271505) Unknown/unexpected command received: " + string2);
        }
        return n;
    }

    public final synchronized void notifyError(boolean bl, String string) {
        if (bl) {
            Trace.fatal(string);
        } else {
            Trace.error(string);
        }
        SDMSOutput sDMSOutput = this.sdmsExec("alter jobserver with " + (bl ? "" : "non_") + "fatal error_text = '" + Utils.quoted(string) + "';");
        if (sDMSOutput.error != null && !bl) {
            Utils.abortProgram(this, "(04301271506) Unexpected response: (" + sDMSOutput.error.code + ") " + sDMSOutput.error.message);
        }
    }

    public final synchronized void reportState(Feil feil) {
        SDMSOutput sDMSOutput;
        StringBuffer stringBuffer = new StringBuffer();
        String string = feil.getStatus();
        if (string.equals("CHILD_ERROR")) {
            string = "ERROR";
        }
        String string2 = feil.getId();
        String string3 = feil.getRun();
        String string4 = feil.getExecPid();
        String string5 = feil.getExtPid();
        String string6 = feil.getRunningTimestamp();
        if (!(string.equals("STARTED") || string.equals("RUNNING") || feil.getStatus_Tx().equals("RUNNING") || feil.getStatus_Tx().equals("BROKEN_ACTIVE"))) {
            stringBuffer.append("alter job ");
            stringBuffer.append(string2);
            stringBuffer.append(" with status = ");
            stringBuffer.append("RUNNING".toLowerCase());
            if (!string3.equals("")) {
                stringBuffer.append(", run = ");
                stringBuffer.append(string3);
            }
            if (!string4.equals("")) {
                stringBuffer.append(", exec_pid = '");
                stringBuffer.append(Utils.quoted(string4));
                stringBuffer.append("'");
            }
            if (!string5.equals("")) {
                stringBuffer.append(", ext_pid = '");
                stringBuffer.append(Utils.quoted(string5));
                stringBuffer.append("'");
            }
            stringBuffer.append(", timestamp = '");
            stringBuffer.append(Utils.quoted(string6.equals("") ? feil.getStatusTimestamp() : string6));
            stringBuffer.append("';");
            sDMSOutput = this.sdmsExec(stringBuffer.toString());
            if (sDMSOutput.error != null) {
                Utils.abortProgram(this, "(04307141941) Unexpected response: (" + sDMSOutput.error.code + ") " + sDMSOutput.error.message);
            }
            stringBuffer.setLength(0);
        }
        stringBuffer.append("alter job ");
        stringBuffer.append(string2);
        stringBuffer.append(" with status = ");
        stringBuffer.append(string.toLowerCase());
        if (!string3.equals("")) {
            stringBuffer.append(", run = ");
            stringBuffer.append(string3);
        }
        if (string.equals("RUNNING")) {
            if (!string4.equals("")) {
                stringBuffer.append(", exec_pid = '");
                stringBuffer.append(Utils.quoted(string4));
                stringBuffer.append("'");
            }
            if (!string5.equals("")) {
                stringBuffer.append(", ext_pid = '");
                stringBuffer.append(Utils.quoted(string5));
                stringBuffer.append("'");
            }
        } else if (string.equals("FINISHED")) {
            if (!feil.getReturnCode().equals("")) {
                stringBuffer.append(", exit_code = ");
                stringBuffer.append(feil.getReturnCode());
            }
        } else if (string.equals("ERROR") && !feil.getError().equals("")) {
            stringBuffer.append(", error_text = '");
            stringBuffer.append(Utils.quoted(feil.getError()));
            stringBuffer.append("'");
        }
        stringBuffer.append(", timestamp = '");
        stringBuffer.append(Utils.quoted(feil.getStatusTimestamp()));
        stringBuffer.append("';");
        sDMSOutput = this.sdmsExec(stringBuffer.toString());
        if (sDMSOutput.error != null) {
            if (sDMSOutput.error.code.equals("03110251037")) {
                Trace.error("Server responded with a not found error for job " + string2);
                Trace.error("The issued command was:");
                Trace.error(stringBuffer.toString());
                if (!feil.emergency_rename()) {
                    // empty if block
                }
            } else {
                Utils.abortProgram(this, "(04301271507) Unexpected response: (" + sDMSOutput.error.code + ") " + sDMSOutput.error.message);
            }
        }
    }
}

