/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.DoGarbage;
import de.independit.scheduler.server.InternalSession;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSObjectMonitor;
import de.independit.scheduler.server.repository.SDMSObjectMonitorTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.util.SDMSFilter;
import de.independit.scheduler.server.util.SyncFifo;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;

public class GarbageThread
extends InternalSession {
    public static final String __version = "@(#) $Id: GarbageThread.java,v 2.13.2.2 2013/03/19 17:16:44 ronald Exp $";
    public static final String name = "GarbageCollection";
    private final long preserveTime;
    private final long maxPreserveTime;

    public GarbageThread(SystemEnvironment systemEnvironment, SyncFifo syncFifo) throws SDMSException {
        super(name);
        this.NR = 1234322;
        this.initThread(systemEnvironment, syncFifo, this.NR, name, SystemEnvironment.gcWakeupInterval * 60 * 1000);
        this.preserveTime = SystemEnvironment.preserveTime;
        this.maxPreserveTime = SystemEnvironment.maxPreserveTime;
    }

    @Override
    protected Node getNode(int n) {
        if (n == 1) {
            return new DoGarbage(1);
        }
        return new DoGarbage();
    }

    public void collect(final SystemEnvironment systemEnvironment) throws SDMSException {
        long l = System.currentTimeMillis();
        GarbageThread.doTrace(this.cEnv, "Start Garbage Collect (now = " + l + " preserveTime = " + this.preserveTime + ")", 0);
        Vector<SDMSSubmittedEntity> vector = new Vector<SDMSSubmittedEntity>();
        SDMSFilter sDMSFilter = new SDMSFilter(){

            @Override
            public boolean isValid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
                int n;
                SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)sDMSProxy;
                return sDMSSubmittedEntity.getId(systemEnvironment).equals(sDMSSubmittedEntity.getMasterId(systemEnvironment)) && ((n = sDMSSubmittedEntity.getState(systemEnvironment).intValue()) == 12 || n == 10);
            }
        };
        Iterator iterator = SDMSSubmittedEntityTable.table.iterator(systemEnvironment, sDMSFilter, true);
        while (iterator.hasNext()) {
            SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)iterator.next();
            vector.add(sDMSSubmittedEntity);
        }
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                try {
                    long l;
                    SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)object;
                    SDMSSubmittedEntity sDMSSubmittedEntity2 = (SDMSSubmittedEntity)object2;
                    long l2 = sDMSSubmittedEntity.getSeId(systemEnvironment);
                    long l3 = sDMSSubmittedEntity2.getSeId(systemEnvironment);
                    if (l2 != l3) {
                        if (l2 < l3) {
                            return -1;
                        }
                        return 1;
                    }
                    long l4 = sDMSSubmittedEntity.getSubmitTs(systemEnvironment);
                    if (l4 != (l = sDMSSubmittedEntity2.getSubmitTs(systemEnvironment).longValue())) {
                        if (l4 < l) {
                            return 1;
                        }
                        return -1;
                    }
                    return 0;
                }
                catch (SDMSException sDMSException) {
                    return 0;
                }
            }

            public boolean equals(Object object, Object object2) {
                try {
                    long l;
                    SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)object;
                    SDMSSubmittedEntity sDMSSubmittedEntity2 = (SDMSSubmittedEntity)object2;
                    long l2 = sDMSSubmittedEntity.getSeId(systemEnvironment);
                    long l3 = sDMSSubmittedEntity2.getSeId(systemEnvironment);
                    if (l2 != l3) {
                        return false;
                    }
                    long l4 = sDMSSubmittedEntity.getSubmitTs(systemEnvironment);
                    return l4 == (l = sDMSSubmittedEntity2.getSubmitTs(systemEnvironment).longValue());
                }
                catch (SDMSException sDMSException) {
                    return false;
                }
            }
        });
        int n = 0;
        long l2 = 0L;
        long l3 = 0L;
        for (SDMSSubmittedEntity sDMSSubmittedEntity : vector) {
            l2 = sDMSSubmittedEntity.getSeId(systemEnvironment);
            if (l2 != l3) {
                n = 0;
                l3 = l2;
            }
            ++n;
            long l4 = sDMSSubmittedEntity.getFinalTs(systemEnvironment);
            if (l - l4 <= this.maxPreserveTime) {
                if (n <= SystemEnvironment.minHistoryCount) continue;
                if (l - l4 <= this.preserveTime) {
                    if (SystemEnvironment.maxHistoryCount == 0) continue;
                    if (n <= SystemEnvironment.maxHistoryCount) continue;
                }
            }
            sDMSSubmittedEntity.releaseMaster(systemEnvironment);
        }
        long l5 = systemEnvironment.roTxList.first(systemEnvironment);
        long l6 = systemEnvironment.seVersionList.first(systemEnvironment);
        if (l6 > l5) {
            l6 = l5;
        }
        systemEnvironment.vPurgeSet.purge(systemEnvironment, l6);
        iterator = SDMSObjectMonitorTable.table.iterator(systemEnvironment, true);
        while (iterator.hasNext()) {
            SDMSObjectMonitor sDMSObjectMonitor = (SDMSObjectMonitor)iterator.next();
            sDMSObjectMonitor.purgeInstances(systemEnvironment, l);
        }
        GarbageThread.doTrace(this.cEnv, "End Garbage Collect", 0);
    }
}

