/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.ConnectionEnvironment;
import de.independit.scheduler.server.DBCleanupThread;
import de.independit.scheduler.server.ExecuteLock;
import de.independit.scheduler.server.Feature;
import de.independit.scheduler.server.GarbageThread;
import de.independit.scheduler.server.MutableInteger;
import de.independit.scheduler.server.NotifierThread;
import de.independit.scheduler.server.PoolThread;
import de.independit.scheduler.server.RenewTicketThread;
import de.independit.scheduler.server.SchedulingThread;
import de.independit.scheduler.server.Server;
import de.independit.scheduler.server.TimerThread;
import de.independit.scheduler.server.TriggerThread;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSPurgeSet;
import de.independit.scheduler.server.repository.SDMSROTxList;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSSeVersionList;
import de.independit.scheduler.server.repository.SDMSTransaction;
import de.independit.scheduler.server.timer.TimerUnit;
import de.independit.scheduler.server.util.Authenticator;
import de.independit.scheduler.server.util.SDMSThread;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.DatagramSocket;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.TimeZone;
import java.util.Vector;

public class SystemEnvironment
implements Cloneable {
    public String setStateThread = null;
    public static final String S_OPEN = "OPEN";
    public static final String S_BASIC = "BASIC";
    public static final String S_PROFESSIONAL = "PROFESSIONAL";
    public static final String S_ENTERPRISE = "ENTERPRISE";
    public static final String programVersion = "2.9";
    public static String programLevel = null;
    public static final long SYSTEM_OBJECTS_BOUNDARY = 1000L;
    public static final int NORMAL = 0;
    public static final int ADMIN = 1;
    public static final int SHUTDOWN = 2;
    public static final int UPH_ERROR = 0;
    public static final int UPH_BLANK = 1;
    public static final int UPH_ECHO = 2;
    public static final int PSH_ERROR = 0;
    public static final int PSH_IGNORE = 1;
    private static final String NONE = "NONE";
    private static final String ALL = "ALL";
    private static final String S_LANGLEVEL261 = "2.6.1";
    public static final int LANGLEVEL261 = 0;
    private static final String S_LANGLEVEL27 = "2.7";
    public static final int LANGLEVEL27 = 1;
    private static final String S_LANGLEVEL28 = "2.8";
    public static final int LANGLEVEL28 = 2;
    private static final String S_LANGLEVEL29 = "2.9";
    public static final int LANGLEVEL29 = 3;
    private static final String[] LANGLEVELS = new String[]{"2.6.1", "2.7", "2.8", "2.9"};
    private static final int DEFAULT_LANGLEVEL = LANGLEVELS.length - 1;
    public static String SQUOTE = null;
    public static String EQUOTE = null;
    public static boolean isPostgreSQL = false;
    public static SDMSRepository repository;
    public static Properties props;
    public static long startTime;
    public static long cntRwTx;
    public static long cntDl;
    public static long cntWl;
    public static Server server;
    public static SchedulingThread sched;
    public static GarbageThread garb;
    public static TriggerThread tt;
    public static PoolThread pt;
    public static RenewTicketThread ticketThread;
    public static DBCleanupThread dbCleanupThread;
    public static TimerThread timer;
    public static ThreadGroup utg;
    public static ThreadGroup wg;
    public static NotifierThread notifier;
    public Connection dbConnection;
    public int dbConnectionNr;
    public SDMSTransaction tx;
    public ConnectionEnvironment cEnv;
    public SDMSROTxList roTxList;
    public SDMSSeVersionList seVersionList;
    public SDMSPurgeSet nvPurgeSet;
    public SDMSPurgeSet vPurgeSet;
    public static DatagramSocket notifySocket;
    public static String runMode;
    public static int traceLevel;
    public static boolean traceExpressions;
    public static String parameterHandling;
    public static int unresolvedParameterHandling;
    public static int parameterSyntaxHandling;
    public static TimerUnit timerHorizon;
    public static TimerUnit timerRecalc;
    public static String hostname;
    public static int port;
    public static int sslport;
    public static int service_port;
    public static int txRetryCount;
    public static long preserveTime;
    public static long maxPreserveTime;
    public static long dbPreserveTime;
    public static boolean archive;
    public static int minHistoryCount;
    public static int maxHistoryCount;
    public static int maxWorker;
    public static int maxWriter;
    public static int maxConnects;
    public static String exportVariablesString;
    public static String userExportVariablesString;
    public static String jdbcDriver;
    public static String dbUrl;
    public static String dbUser;
    public static String dbPasswd;
    public static String sysPasswd;
    public static int scheduleWakeupInterval;
    public static int notifyDelay;
    public static int priorityDelay;
    public static int priorityLowerBound;
    public static int timerWakeupInterval;
    public static int timerSuspendLimit;
    public static int timerTimeout;
    public static int gcWakeupInterval;
    public static int ttWakeupInterval;
    public static int ptWakeupInterval;
    public static int ptEvalCycle;
    public static int triggerSoftLimit;
    public static int triggerHardLimit;
    public static int dbLoaders;
    public static int sessionTimeout;
    public static String compatLevel;
    public static boolean singleServer;
    public static int maxNumCalEntries;
    public static int defCalHorizon;
    public static boolean fatalIsError;
    public static String selectGroup;
    public static String auditFile;
    public static int auditEntries;
    public static Authenticator auth;
    public static boolean enhancedCmdParsing;
    public static boolean strict_variables;
    public static boolean warn_variables;
    public static Vector exportVariables;
    public static HashSet scopeSysVars;
    public static Vector smeColumns;
    public static Vector atColumns;
    public static Vector diColumns;
    public static Vector evColumns;
    public static Vector exColumns;
    public static Vector hiColumns;
    public static Vector kjColumns;
    public static Vector smesColumns;
    public static boolean includeDomainNames;
    public static boolean autoCreateUsers;
    public static boolean autoCreateGroups;
    public static boolean useAdGroups;
    public static String serverName;
    public static String bicsuitePrefix;
    public static Integer nameCase;
    public static int dumpLangLevel;
    public static HashMap<String, Long> showStackTrace;
    public static String keystore;
    public static String keystorepassword;
    public static String truststore;
    public static String truststorepassword;
    public static boolean clientAuthentication;
    private static boolean got_properties;
    public static final String S_ARCHIVE = "Archive";
    public static final String S_ARCSMECOLS = "ArchiveSMEColumns";
    public static final String S_ARCATCOLS = "ArchiveAuditColumns";
    public static final String S_ARCDICOLS = "ArchiveDependencyColumns";
    public static final String S_ARCEVCOLS = "ArchiveVariableColumns";
    public static final String S_ARCEXCOLS = "ArchiveExtentsColumns";
    public static final String S_ARCHICOLS = "ArchiveHierarchyColumns";
    public static final String S_ARCKJCOLS = "ArchiveKillJobColumns";
    public static final String S_ARCSMESCOLS = "ArchiveStatsColumns";
    public static final String S_AUDITFILE = "AuditFile";
    public static final String S_AUDITENTRIES = "AuditEntries";
    public static final String S_AUTHCLASS = "AuthenticationClass";
    public static final String S_CALHORIZON = "CalendarHorizon";
    public static final String S_CALENTRIES = "CalendarEntries";
    public static final String S_DBLOADER = "DbLoaders";
    public static final String S_DBPASSWD = "DbPasswd";
    public static final String S_DBURL = "DbUrl";
    public static final String S_DBUSER = "DbUser";
    public static final String S_DMPLANGLEVEL = "DumpLangLevel";
    public static final String S_ENHANCEDCMDPARSING = "EnhancedCmdParsing";
    public static final String S_EXPORTVARIABLES = "ExportVariables";
    public static final String S_GCWAKEUP = "GCWakeup";
    public static final String S_HISTORY = "History";
    public static final String S_DBHISTORY = "DbHistory";
    public static final String S_HISTORYLIMIT = "HistoryLimit";
    public static final String S_MINHISTORYCOUNT = "MinHistoryCount";
    public static final String S_MAXHISTORYCOUNT = "MaxHistoryCount";
    public static final String S_NOTIFYDELAY = "NotifyDelay";
    public static final String S_HOSTNAME = "Hostname";
    public static final String S_JDBCDRIVER = "JdbcDriver";
    public static final String S_LEVEL = "CompatibilityLevel";
    public static final String S_PARAMETERHANDLING = "ParameterHandling";
    public static final String S_PARAMETERSYNTAXHANDLING = "ParameterSyntaxHandling";
    public static final String S_PORT = "Port";
    public static final String S_PRIORITYDELAY = "PriorityDelay";
    public static final String S_PRIORITYLB = "PriorityLowerBound";
    public static final String S_PTEVALCYCLE = "PTEvalCycle";
    public static final String S_PTWAKEUP = "PTWakeup";
    public static final String S_RUNMODE = "RunMode";
    public static final String S_SCHEDULEWAKEUP = "ScheduleWakeup";
    public static final String S_SCOPESYSVARS = "ScopeSystemVariables";
    public static final String S_SELECTGROUP = "SelectGroup";
    public static final String S_SERVICEPORT = "ServicePort";
    public static final String S_SESSIONTIMEOUT = "SessionTimeout";
    public static final String S_SHOWSTACKTRACE = "ShowStackTrace";
    public static final String S_SINGLESERVER = "SingleServer";
    public static final String S_SSLPORT = "SSLPort";
    public static final String S_SYSPASSWD = "SysPasswd";
    public static final String S_TIMERHORIZON = "TimerHorizon";
    public static final String S_TIMERRECALC = "TimerRecalc";
    public static final String S_TIMERSUSPENDLIMIT = "TimerSuspendLimit";
    public static final String S_TIMERTIMEOUT = "TimerTimeout";
    public static final String S_TIMERWAKEUP = "TimerWakeup";
    public static final String S_TRACELEVEL = "TraceLevel";
    public static final String S_TRACEEXPRESSIONS = "TraceExpressions";
    public static final String S_TRIGGERSOFTLIMIT = "TriggerSoftLimit";
    public static final String S_TRIGGERHARDLIMIT = "TriggerHardLimit";
    public static final String S_TTWAKEUP = "TTWakeup";
    public static final String S_TXRETRYCOUNT = "TxRetryCount";
    public static final String S_USERTHREADS = "UserThreads";
    public static final String S_USEREXPORTVARIABLES = "UserExportVariables";
    public static final String S_UNRESPARMHANDLING = "UnresolvedParameterHandling";
    public static final String S_WORKERTHREADS = "WorkerThreads";
    public static final String S_WRITERTHREADS = "WriterThreads";
    public static final String S_KEYSTORE = "KeyStore";
    public static final String S_KEYSTOREPASSWORD = "KeyStorePassword";
    public static final String S_KEYSTOREPROVIDER = "KeyStoreProvider";
    public static final String S_KEYSTORETYPE = "KeyStoreType";
    public static final String S_TRUSTSTORE = "TrustStore";
    public static final String S_TRUSTSTOREPASSWORD = "TrustStorePassword";
    public static final String S_TRUSTSTOREPROVIDER = "TrustStoreProvider";
    public static final String S_TRUSTSTORETYPE = "TrustStoreType";
    public static final String S_CLIENTAUTHENTICATION = "ClientAuthentication";
    public static final String S_INCLUDEDOMAINNAMES = "SSOincludeDomainNames";
    public static final String S_AUTOCREATEUSERS = "SSOautoCreateUsers";
    public static final String S_AUTOCREATEGROUPS = "SSOautoCreateGroups";
    public static final String S_USEADGROUPS = "SSOuseADGroups";
    public static final String S_SERVERNAME = "SSOserverName";
    public static final String S_BICSUITEPREFIX = "SSObicsuitePrefix";
    public static final String S_NAMECASE = "SSOnameCase";
    public static final String J_KEYSTORE = "javax.net.ssl.keyStore";
    public static final String J_KEYSTOREPASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String J_KEYSTOREPROVIDER = "javax.net.ssl.keyStoreProvider";
    public static final String J_KEYSTORETYPE = "javax.net.ssl.keyStoreType";
    public static final String J_TRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String J_TRUSTSTOREPASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String J_TRUSTSTOREPROVIDER = "javax.net.ssl.trustStoreProvider";
    public static final String J_TRUSTSTORETYPE = "javax.net.ssl.trustStoreType";
    public static final String S_BASE_SME_ID = "BASE_SME_ID";
    public static final String S_TRIGGER_HASHSET = "TRIGGER_HASH_SET";
    public static final String S_CANCEL_HASHSET = "CANCEL_HASH_SET";
    public static final String S_MASTERTRIGGER_HASHSET = "MASTERTRIGGER_HASHSET";
    public static final String S_ISDEFAULT = "ISDEFAULT";
    public static final String S_RESOURCE_TRACE = "RESOURCETRACE";
    public static final String S_SE_NAMEFILTER_CACHE = "SE_NAMEFILTER_CACHE";
    public static final String S_PARAMETERFILTER_CACHE = "PARAMETERFILTER_CACHE";
    public static final Integer CASE_UPPER;
    public static final Integer CASE_LOWER;
    public static final Integer CASE_MIXED;
    public static final String S_CASE_UPPER = "UPPER";
    public static final String S_CASE_LOWER = "LOWER";
    public static final String S_CASE_MIXED = "MIXED";
    public static final String S_FALSE = "false";
    public static final String S_TRUE = "true";
    public static final String nullString = "<null>";
    public static final String defaultString = "<default>";
    public static final String noneString = "<none>";
    public static final TimeZone systemTimeZone;
    public static final Locale systemLocale;
    public static final SimpleDateFormat staticJSCommDateFormat;
    public static final SimpleDateFormat staticOldJSCommDateFormat;
    public static final SimpleDateFormat staticSystemDateFormat;
    public SimpleDateFormat systemDateFormat = (SimpleDateFormat)staticSystemDateFormat.clone();
    public SimpleDateFormat jsCommDateFormat = (SimpleDateFormat)staticJSCommDateFormat.clone();
    public SimpleDateFormat oldJsCommDateFormat = (SimpleDateFormat)staticOldJSCommDateFormat.clone();
    public static final String S_AUDITTRAIL = "AUDITTRAIL";
    public static final String S_GRANTS = "GRANTS";
    public static final String S_CONDITIONAL_DEPENDENCIES = "CONDITIONAL_DEPENDENCIES";
    public static final String S_MILESTONES = "MILESTONES";
    public static final String S_EXTENDED_TRIGGERS = "EXTENDED_TRIGGERS";
    public static final String S_ASYNC_TRIGGERS = "ASYNC_TRIGGERS";
    public static final String S_FOLDER_ENVIRONMENTS = "FOLDER_ENVIRONMENTS";
    public static final String S_FOLDER_RESOURCES = "FOLDER_RESOURCES";
    public static final String S_SE_RESOURCES = "SE_RESOURCES";
    public static final String S_JOB_LEVEL_AGING_CONTROL = "JOB_LEVEL_AGING_CONTROL";
    public static final String S_RESOURCE_TRIGGER = "RESOURCE_TRIGGER";
    public static final String S_OBJECTMONITOR_TRIGGER = "OBJECTMONITOR_TRIGGER";
    public static final String S_WRITABLE_RESOURCE_PARAMS = "WRITABLE_RESOURCE_PARAMS";
    public static final String S_DUMP_COMMAND = "DUMP_COMMAND";
    public static final String S_EXTENDED_DUMP_COMMAND = "EXTENDED_DUMP_COMMAND";
    public static final String S_RESOURCE_POOLS = "RESOURCE_POOLS";
    public static final String S_RESOURCE_TRACING = "RESOURCE_TRACING";
    public static final String S_EXIT_STATE_TRANSLATION = "EXIT_STATE_TRANSLATION";
    public static final String S_POOL = "POOL";
    public static final String S_OBJECT_MONITOR = "OBJECT_MONITOR";
    public static final String S_NICE_PROFILE = "NICE_PROFILE";
    public static final String S_WARNINGS = "WARNINGS";
    private HashMap featureLevels;
    public static final HashMap<Long, Long> jidsStarting;
    public static final int startingResendDelay = 5000;
    public SDMSThread thread;
    private long lockCp;
    public boolean inExecution = false;
    public long lowestActiveVersion;
    public long lowestActiveDate;
    private MutableInteger connectState;
    private static boolean protectMode;
    private static Random random;
    private static ExecuteLock executeLock;
    static final String OBRACKET = "(";
    static final String CBRACKET = ")";
    static final String COMMA = ",";

    public long getLockCp() {
        return this.lockCp;
    }

    public void initLockCp() {
        this.lockCp = 0L;
    }

    public long newLockCp() {
        long l = this.lockCp++;
        return l;
    }

    public SystemEnvironment(Properties properties, String string) {
        if (programLevel == null) {
            programLevel = string;
        }
        props = properties;
        if (!got_properties) {
            this.setProperties();
        }
        this.roTxList = new SDMSROTxList();
        this.seVersionList = new SDMSSeVersionList();
        this.nvPurgeSet = new SDMSPurgeSet();
        this.vPurgeSet = new SDMSPurgeSet();
        this.connectState = new MutableInteger(0);
        startTime = System.currentTimeMillis();
        this.featureLevels = new HashMap();
        this.featureLevels.put(S_AUDITTRAIL, new Feature(S_PROFESSIONAL, "Auditing of Operator Actions"));
        this.featureLevels.put(S_GRANTS, new Feature(S_PROFESSIONAL, "The GRANT/REVOKE Commands"));
        this.featureLevels.put(S_CONDITIONAL_DEPENDENCIES, new Feature(S_BASIC, "Conditional Dependencies"));
        this.featureLevels.put(S_MILESTONES, new Feature(S_BASIC, "Scheduling Entity Type MILESTONE"));
        this.featureLevels.put(S_EXTENDED_TRIGGERS, new Feature(S_BASIC, "Using Trigger Types other than IMMEDIATE_..., FINISH_CHILD or BEFORE_FINAL"));
        this.featureLevels.put(S_ASYNC_TRIGGERS, new Feature(S_BASIC, "Asynchronous Trigger Types"));
        this.featureLevels.put(S_FOLDER_ENVIRONMENTS, new Feature(S_BASIC, "Use of Folder Environments"));
        this.featureLevels.put(S_FOLDER_RESOURCES, new Feature(S_BASIC, "Use of Folder Resources"));
        this.featureLevels.put(S_SE_RESOURCES, new Feature(S_BASIC, "Use of Job or Batch Resources"));
        this.featureLevels.put(S_JOB_LEVEL_AGING_CONTROL, new Feature(S_PROFESSIONAL, "Job Level Priority Aging Control"));
        this.featureLevels.put(S_RESOURCE_TRIGGER, new Feature(S_BASIC, "Use of Resource Triggers"));
        this.featureLevels.put(S_OBJECTMONITOR_TRIGGER, new Feature(S_PROFESSIONAL, "Use of Object Monitor Triggers"));
        this.featureLevels.put(S_WRITABLE_RESOURCE_PARAMS, new Feature(S_BASIC, "Writing to Resource Parameters"));
        this.featureLevels.put(S_DUMP_COMMAND, new Feature(S_PROFESSIONAL, "The Dump Command"));
        this.featureLevels.put(S_EXTENDED_DUMP_COMMAND, new Feature(S_PROFESSIONAL, "Use of Extended Dump Command Options DEPLOY, MAPPING, HEADER and CLEANUP"));
        this.featureLevels.put(S_RESOURCE_POOLS, new Feature(S_ENTERPRISE, "Use of Resource Pools"));
        this.featureLevels.put(S_RESOURCE_TRACING, new Feature(S_ENTERPRISE, "Resource Tracing"));
        this.featureLevels.put(S_EXIT_STATE_TRANSLATION, new Feature(S_BASIC, "Use of Exit State Translations"));
        this.featureLevels.put(S_POOL, new Feature(S_ENTERPRISE, "Use of Pools and Distributions"));
        this.featureLevels.put(S_OBJECT_MONITOR, new Feature(S_PROFESSIONAL, "Use of Object Monitors"));
        this.featureLevels.put(S_NICE_PROFILE, new Feature(S_ENTERPRISE, "Use of Nice Profiles"));
        this.featureLevels.put(S_WARNINGS, new Feature(S_PROFESSIONAL, "Warnings on Submitted Entities"));
    }

    private void setProperties() {
        this.getSimpleValues();
        this.getAuthClass();
        this.getPropsTraceLevel();
        this.getTraceExpressions();
        this.getShowStackTrace();
        this.getArchive();
        this.getArchiveCols();
        this.getParameterHandling();
        this.getUnresolvedParameterHandling();
        this.getParameterSyntaxHandling();
        this.getTimerHorizon();
        this.getTimerRecalc();
        this.getPort();
        this.getServicePort();
        this.getTxRetryCount();
        this.getHistory();
        this.getDbHistory();
        this.getHistoryLimit();
        this.getMinHistoryCount();
        this.getMaxHistoryCount();
        this.getNotifyDelay();
        this.getWorkerThreads();
        this.getWriterThreads();
        this.getUserThreads();
        this.getExportVariables();
        this.getScopeSysVars();
        this.getScheduleWakeup();
        this.getGCWakeup();
        this.getTTWakeup();
        this.getPTWakeup();
        this.getPoolEvalCycle();
        this.getPriorityDelay();
        this.getPriorityLB();
        this.getSessionTimeout();
        this.getSysPasswd();
        this.getTimerWakeup();
        this.getTimerSuspendLimit();
        this.getTimerTimeout();
        this.getDbLoader();
        this.getCompatLevel();
        this.getSingleServer();
        this.getMaxNumCalEntries();
        this.getCalHorizon();
        this.getTriggerSoftLimit();
        this.getTriggerHardLimit();
        this.getAuditFile();
        this.getSSLproperties();
        if (port == 0 && service_port == 0 && sslport == 0) {
            port = 2506;
        }
        this.getDumpLangLevel();
        this.getSSOconfig();
        got_properties = true;
    }

    private void getSimpleValues() {
        String string;
        runMode = props.getProperty(S_RUNMODE, "Production").toUpperCase();
        props.setProperty(S_RUNMODE, runMode);
        fatalIsError = !runMode.equals("TEST");
        hostname = props.getProperty(S_HOSTNAME, "localhost");
        props.setProperty(S_HOSTNAME, hostname);
        jdbcDriver = props.getProperty(S_JDBCDRIVER);
        dbUrl = props.getProperty(S_DBURL);
        dbUser = props.getProperty(S_DBUSER, "");
        props.setProperty(S_DBUSER, dbUser);
        dbPasswd = props.getProperty(S_DBPASSWD, "");
        props.remove(S_DBPASSWD);
        selectGroup = props.getProperty(S_SELECTGROUP);
        if (selectGroup != null) {
            selectGroup = selectGroup.toUpperCase();
        }
        enhancedCmdParsing = (string = props.getProperty(S_ENHANCEDCMDPARSING, "no").toUpperCase()).equals("YES") || string.equals("TRUE");
    }

    private void getCompatLevel() {
        compatLevel = props.getProperty(S_LEVEL, programLevel);
        if (programLevel.equals(S_OPEN)) {
            compatLevel = S_BASIC;
        }
        if (!compatLevel.equals(programLevel)) {
            if (programLevel.equals(S_PROFESSIONAL) && !compatLevel.equals(S_BASIC)) {
                compatLevel = S_PROFESSIONAL;
            }
            if (programLevel.equals(S_BASIC)) {
                compatLevel = programLevel;
            }
        }
        props.setProperty(S_LEVEL, "" + compatLevel);
    }

    private void getSSLproperties() {
        this.getSSLPort();
        if (sslport != 0) {
            keystore = props.getProperty(S_KEYSTORE);
            if (keystore == null) {
                keystore = System.getProperty(J_KEYSTORE);
            }
            if (keystore == null) {
                sslport = 0;
                return;
            }
            System.setProperty(J_KEYSTORE, keystore);
            props.setProperty(S_KEYSTORE, keystore);
            keystorepassword = props.getProperty(S_KEYSTOREPASSWORD);
            if (keystorepassword == null) {
                keystorepassword = System.getProperty(J_KEYSTOREPASSWORD);
            }
            if (keystorepassword != null) {
                System.setProperty(J_KEYSTOREPASSWORD, keystorepassword);
                props.setProperty(S_KEYSTOREPASSWORD, keystorepassword);
            }
            if ((truststore = props.getProperty(S_TRUSTSTORE)) == null) {
                truststore = System.getProperty(J_TRUSTSTORE);
            }
            if (truststore != null) {
                System.setProperty(J_TRUSTSTORE, truststore);
                props.setProperty(S_TRUSTSTORE, truststore);
            }
            if ((truststorepassword = props.getProperty(S_TRUSTSTOREPASSWORD)) == null) {
                truststorepassword = System.getProperty(J_TRUSTSTOREPASSWORD);
            }
            if (truststorepassword != null) {
                System.setProperty(J_TRUSTSTOREPASSWORD, truststorepassword);
                props.setProperty(S_TRUSTSTOREPASSWORD, truststorepassword);
            }
            String string = props.getProperty(S_CLIENTAUTHENTICATION, S_FALSE).trim();
            clientAuthentication = (string = string.toUpperCase()).equals("TRUE") || string.equals("YES");
        }
    }

    public boolean checkCompatLevel(String string) {
        if (compatLevel.equals(string)) {
            return true;
        }
        if (compatLevel.equals(S_ENTERPRISE)) {
            return true;
        }
        return compatLevel.equals(S_PROFESSIONAL) && string.equals(S_BASIC);
    }

    public void checkFeatureAvailability(String string) throws SDMSException {
        Feature feature = (Feature)this.featureLevels.get(string);
        if (feature == null) {
            throw new CommonErrorException(new SDMSMessage(this, "02803040840", "Availability Check on unknown Feature $1", (Object)string));
        }
        if (!this.checkCompatLevel(feature.requiredLevel)) {
            throw new CommonErrorException(new SDMSMessage(this, "02803040845", "$1 requires Version $2 or higher", (Object)feature.featureText, (Object)feature.requiredLevel));
        }
    }

    public boolean checkFeature(String string) throws SDMSException {
        Feature feature = (Feature)this.featureLevels.get(string);
        if (feature == null) {
            throw new CommonErrorException(new SDMSMessage(this, "02803040840", "Availability Check on unknown Feature $1", (Object)string));
        }
        return this.checkCompatLevel(feature.requiredLevel);
    }

    private void getAuditFile() {
        auditFile = props.getProperty(S_AUDITFILE);
        String string = props.getProperty(S_AUDITENTRIES, "100000");
        auditEntries = this.checkIntProperty(string, S_AUDITENTRIES, 1, 100000, 0, "Invalid Audit Chunk Size : ");
        props.setProperty(S_AUDITENTRIES, "" + auditEntries);
    }

    private void getArchive() {
        String string = props.getProperty(S_ARCHIVE, S_FALSE);
        archive = Boolean.parseBoolean(string.trim());
        props.setProperty(S_ARCHIVE, archive ? S_TRUE : S_FALSE);
    }

    private void getAuthClass() {
        String string = props.getProperty(S_AUTHCLASS, null);
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                auth = (Authenticator)clazz.newInstance();
                SDMSThread.doTrace(null, "Using class " + string + " for Authentication", 0);
            }
            catch (Throwable throwable) {
                SDMSThread.doTrace(null, "Problem loading class " + string + " : " + throwable.toString(), 1);
                props.remove(S_AUTHCLASS);
                auth = null;
            }
        } else {
            SDMSThread.doTrace(null, "Using internal Authentication", 0);
        }
    }

    private void getShowStackTrace() {
        String string = props.getProperty(S_SHOWSTACKTRACE, null);
        showStackTrace = new HashMap();
        if (string == null || string.equals(NONE)) {
            props.setProperty(S_SHOWSTACKTRACE, NONE);
            return;
        }
        try {
            this.parseSSTParameter(string);
        }
        catch (SDMSException sDMSException) {
            props.setProperty(S_SHOWSTACKTRACE, NONE);
            showStackTrace.clear();
        }
    }

    private Vector<String> tokenizeSST(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(cArray[i])) {
                if (!bl) continue;
                bl = false;
                vector.add(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
                continue;
            }
            if (cArray[i] == ',' || cArray[i] == '(' || cArray[i] == ')') {
                if (bl) {
                    bl = false;
                    vector.add(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.length());
                }
                vector.add(new String("" + cArray[i]));
                continue;
            }
            bl = true;
            stringBuffer.append(cArray[i]);
        }
        return vector;
    }

    private void parseSSTParameter(String string) throws SDMSException {
        Vector<String> vector = this.tokenizeSST(string);
        int n = 0;
        while (n < vector.size()) {
            n = this.parseSSTEntry(vector, n);
        }
    }

    private int parseSSTEntry(Vector<String> vector, int n) throws SDMSException {
        int n2 = vector.size();
        String string = vector.get(n);
        if (++n >= n2) {
            SDMSThread.doTrace(null, "Invalid syntax in " + props.getProperty(S_SHOWSTACKTRACE), 1);
            throw new SDMSException();
        }
        String string2 = vector.get(n);
        ++n;
        if (!string2.equals(OBRACKET)) {
            SDMSThread.doTrace(null, "Invalid syntax in " + props.getProperty(S_SHOWSTACKTRACE) + ": missing opening bracket", 1);
            throw new SDMSException();
        }
        string2 = vector.get(n);
        ++n;
        boolean bl = false;
        Long l = showStackTrace.get(string);
        long l2 = l != null ? l : 0L;
        while (n < n2 && !string2.equals(CBRACKET)) {
            String string3 = !string2.startsWith("de.independit") ? "de.independit.scheduler.server.exception." + string2 : string2;
            try {
                Class<?> clazz = Class.forName(string3);
                SDMSException sDMSException = (SDMSException)clazz.newInstance();
                l2 += (long)sDMSException.getExceptionNumber();
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Invalid exception name " + string2 + ": class not found or no subclass of SDMSException (entry ignored)", 1);
            }
            if (n >= n2) {
                SDMSThread.doTrace(null, "Invalid syntax in " + props.getProperty(S_SHOWSTACKTRACE) + ": missing closing bracket", 1);
                throw new SDMSException();
            }
            string2 = vector.get(n);
            ++n;
            if (string2.equals(COMMA)) {
                if (n >= n2) {
                    SDMSThread.doTrace(null, "Invalid syntax in " + props.getProperty(S_SHOWSTACKTRACE) + ": missing name after comma", 1);
                    throw new SDMSException();
                }
                string2 = vector.get(n);
                ++n;
                if (!string2.equals(CBRACKET)) continue;
                SDMSThread.doTrace(null, "Invalid syntax in " + props.getProperty(S_SHOWSTACKTRACE) + ": superfluous comma", 1);
                throw new SDMSException();
            }
            if (string2.equals(CBRACKET)) continue;
            SDMSThread.doTrace(null, "Invalid syntax in " + props.getProperty(S_SHOWSTACKTRACE) + ": missing comma", 1);
            throw new SDMSException();
        }
        if (!string2.equals(CBRACKET)) {
            SDMSThread.doTrace(null, "Invalid syntax in " + props.getProperty(S_SHOWSTACKTRACE) + ": missing closing bracket", 1);
            throw new SDMSException();
        }
        showStackTrace.put(string, new Long(l2));
        return n;
    }

    private void getPropsTraceLevel() {
        String string = props.getProperty(S_TRACELEVEL, "1");
        traceLevel = this.checkIntProperty(string, S_TRACELEVEL, 0, 1, 3, "Invalid trace level : ");
        props.setProperty(S_TRACELEVEL, "" + traceLevel);
    }

    private void getNotifyDelay() {
        String string = props.getProperty(S_NOTIFYDELAY, "1");
        notifyDelay = this.checkIntProperty(string, S_NOTIFYDELAY, 1, 1, 5, "Invalid notify delay: ");
        props.setProperty(S_NOTIFYDELAY, "" + notifyDelay);
    }

    private void getTimerHorizon() {
        String string = props.getProperty(S_TIMERHORIZON, "5");
        int n = this.checkIntProperty(string, S_TIMERHORIZON, 1, 5, 0, "Invalid TimerThread horizon : ");
        timerHorizon = new TimerUnit(n, 5);
        props.setProperty(S_TIMERHORIZON, "" + n);
    }

    private void getTimerRecalc() {
        String string = props.getProperty(S_TIMERRECALC, "5");
        int n = this.checkIntProperty(string, S_TIMERRECALC, 1, 5, 0, "Invalid TimerThread recalc : ");
        timerRecalc = new TimerUnit(n, 2);
        props.setProperty(S_TIMERRECALC, "" + n);
    }

    private void getPort() {
        String string = props.getProperty(S_PORT, "0");
        port = this.checkIntProperty(string, S_PORT, 0, 2506, 0, "Invalid port number : ");
        props.setProperty(S_PORT, "" + port);
    }

    private void getSSLPort() {
        String string = props.getProperty(S_SSLPORT, "0");
        sslport = this.checkIntProperty(string, S_SSLPORT, 0, 2507, 0, "Invalid port number : ");
        props.setProperty(S_SSLPORT, "" + sslport);
    }

    private void getServicePort() {
        String string = props.getProperty(S_SERVICEPORT, "0");
        service_port = this.checkIntProperty(string, S_SERVICEPORT, 0, 2505, 0, "Invalid port number : ");
        props.setProperty(S_SERVICEPORT, "" + service_port);
    }

    private void getSessionTimeout() {
        String string = props.getProperty(S_SESSIONTIMEOUT, "60");
        sessionTimeout = this.checkIntProperty(string, S_SESSIONTIMEOUT, 0, 60, 0, "Invalid timeout value: ");
        props.setProperty(S_SESSIONTIMEOUT, "" + sessionTimeout);
    }

    private void getTxRetryCount() {
        String string = props.getProperty(S_TXRETRYCOUNT, "1");
        txRetryCount = this.checkIntProperty(string, S_TXRETRYCOUNT, 1, 1, 0, "Invalid retry count : ");
        props.setProperty(S_TXRETRYCOUNT, "" + txRetryCount);
    }

    private void getHistory() {
        String string = props.getProperty(S_HISTORY, "14400");
        int n = 60;
        if (runMode.equals("TEST")) {
            n = 5;
        }
        preserveTime = this.checkIntProperty(string, S_HISTORY, n, 14400, 0, "Invalid History : ");
        props.setProperty(S_HISTORY, "" + preserveTime);
        preserveTime *= 60000L;
    }

    private void getDbHistory() {
        String string = props.getProperty(S_DBHISTORY, "0");
        dbPreserveTime = this.checkIntProperty(string, S_DBHISTORY, 0, 0, 0, "Invalid DbHistory : ");
        props.setProperty(S_DBHISTORY, "" + dbPreserveTime);
        dbPreserveTime *= 60000L;
    }

    private void getHistoryLimit() {
        String string = props.getProperty(S_HISTORYLIMIT, "14400");
        int n = (int)preserveTime / 60000;
        if (runMode.equals("TEST")) {
            n = 5;
        }
        maxPreserveTime = this.checkIntProperty(string, S_HISTORYLIMIT, n, 14400, 0, "Invalid HistoryLimit : ");
        props.setProperty(S_HISTORYLIMIT, "" + maxPreserveTime);
        maxPreserveTime *= 60000L;
    }

    private void getMinHistoryCount() {
        String string = props.getProperty(S_MINHISTORYCOUNT, "0");
        minHistoryCount = this.checkIntProperty(string, S_MINHISTORYCOUNT, 0, 0, 0, "Invalid MinHistoryCount : ");
        props.setProperty(S_MINHISTORYCOUNT, "" + minHistoryCount);
    }

    private void getMaxHistoryCount() {
        String string = props.getProperty(S_MAXHISTORYCOUNT, "0");
        maxHistoryCount = string.equals("0") ? 0 : this.checkIntProperty(string, S_MAXHISTORYCOUNT, minHistoryCount, 0, 0, "Invalid MaxHistoryCount : ");
        props.setProperty(S_MAXHISTORYCOUNT, "" + maxHistoryCount);
    }

    private void getCalHorizon() {
        String string = props.getProperty(S_CALHORIZON, "62");
        defCalHorizon = this.checkIntProperty(string, S_CALHORIZON, 0, 62, 0, "Invalid Calendar Horizon : ");
        props.setProperty(S_CALHORIZON, "" + defCalHorizon);
    }

    private void getMaxNumCalEntries() {
        String string = props.getProperty(S_CALENTRIES, "300");
        maxNumCalEntries = this.checkIntProperty(string, S_CALENTRIES, 0, 300, 0, "Invalid Number of Calendar Entries : ");
        props.setProperty(S_CALENTRIES, "" + maxNumCalEntries);
    }

    private void getWorkerThreads() {
        String string = props.getProperty(S_WORKERTHREADS, "2");
        maxWorker = this.checkIntProperty(string, S_WORKERTHREADS, 0, 2, 0, "Invalid number of RO Worker : ");
        props.setProperty(S_WORKERTHREADS, "" + maxWorker);
    }

    private void getWriterThreads() {
        String string = props.getProperty(S_WRITERTHREADS, "1");
        maxWriter = this.checkIntProperty(string, S_WRITERTHREADS, 1, 1, 128, "Invalid number of RW Worker : ");
        props.setProperty(S_WRITERTHREADS, "" + maxWriter);
    }

    private void getUserThreads() {
        String string = props.getProperty(S_USERTHREADS, "10");
        maxConnects = this.checkIntProperty(string, S_USERTHREADS, 3, 10, 0, "Invalid number of Connections : ");
        props.setProperty(S_USERTHREADS, "" + maxConnects);
    }

    private void getScheduleWakeup() {
        String string = props.getProperty(S_SCHEDULEWAKEUP, "30");
        scheduleWakeupInterval = this.checkIntProperty(string, S_SCHEDULEWAKEUP, 1, 30, 0, "Invalid wakeup interval for scheduler : ");
        props.setProperty(S_SCHEDULEWAKEUP, "" + scheduleWakeupInterval);
    }

    private void getGCWakeup() {
        String string = props.getProperty(S_GCWAKEUP, "240");
        gcWakeupInterval = this.checkIntProperty(string, S_GCWAKEUP, 1, 240, 0, "Invalid wakeup interval for garbage collector : ");
        props.setProperty(S_GCWAKEUP, "" + gcWakeupInterval);
    }

    private void getTTWakeup() {
        String string = props.getProperty(S_TTWAKEUP, "30");
        ttWakeupInterval = this.checkIntProperty(string, S_TTWAKEUP, 10, 30, 0, "Invalid wakeup interval for trigger thread : ");
        props.setProperty(S_TTWAKEUP, "" + ttWakeupInterval);
    }

    private void getPTWakeup() {
        String string = props.getProperty(S_PTWAKEUP, "300");
        ptWakeupInterval = this.checkIntProperty(string, S_PTWAKEUP, 30, 300, 0, "Invalid wakeup interval for pool thread : ");
        props.setProperty(S_PTWAKEUP, "" + ptWakeupInterval);
    }

    private void getPoolEvalCycle() {
        String string = props.getProperty(S_PTEVALCYCLE, "900");
        ptEvalCycle = this.checkIntProperty(string, S_PTEVALCYCLE, 60, 900, 0, "Invalid default evaluation cycle for pool thread : ");
        props.setProperty(S_PTEVALCYCLE, "" + ptEvalCycle);
    }

    private void getPriorityDelay() {
        String string = props.getProperty(S_PRIORITYDELAY, "30");
        priorityDelay = this.checkIntProperty(string, S_PRIORITYDELAY, 1, 30, 0, "Invalid priority Delay : ");
        props.setProperty(S_PRIORITYDELAY, "" + priorityDelay);
    }

    private void getPriorityLB() {
        String string = props.getProperty(S_PRIORITYLB, "10");
        priorityLowerBound = this.checkIntProperty(string, S_PRIORITYLB, 0, 10, 20, "Invalid priority Lower Bound : ");
        props.setProperty(S_PRIORITYLB, "" + priorityLowerBound);
    }

    private void getSingleServer() {
        String string = props.getProperty(S_SINGLESERVER, S_FALSE);
        singleServer = Boolean.parseBoolean(string.trim());
        props.setProperty(S_SINGLESERVER, singleServer ? S_TRUE : S_FALSE);
    }

    private void getTraceExpressions() {
        String string = props.getProperty(S_TRACEEXPRESSIONS, S_FALSE);
        traceExpressions = Boolean.parseBoolean(string.trim());
        props.setProperty(S_TRACEEXPRESSIONS, traceExpressions ? S_TRUE : S_FALSE);
    }

    private void getSysPasswd() {
        sysPasswd = props.getProperty(S_SYSPASSWD, "G0H0ME");
        props.remove(S_SYSPASSWD);
    }

    private void getTimerWakeup() {
        String string = props.getProperty(S_TIMERWAKEUP, "30");
        timerWakeupInterval = this.checkIntProperty(string, S_TIMERWAKEUP, 10, 30, 0, "Invalid timer wakeup: ");
        props.setProperty(S_TIMERWAKEUP, "" + timerWakeupInterval);
        timerWakeupInterval *= 1000;
    }

    private void getTimerSuspendLimit() {
        String string = props.getProperty(S_TIMERSUSPENDLIMIT, "15");
        timerSuspendLimit = this.checkIntProperty(string, S_TIMERSUSPENDLIMIT, 1, 15, 0, "Invalid timer suspend: ");
        props.setProperty(S_TIMERSUSPENDLIMIT, "" + timerSuspendLimit);
    }

    private void getTimerTimeout() {
        String string = props.getProperty(S_TIMERTIMEOUT, "10");
        timerTimeout = this.checkIntProperty(string, S_TIMERTIMEOUT, 1, 10, 0, "Invalid timer timeout: ");
        props.setProperty(S_TIMERTIMEOUT, "" + timerTimeout);
    }

    private void getTriggerSoftLimit() {
        String string = props.getProperty(S_TRIGGERSOFTLIMIT, "50");
        triggerSoftLimit = this.checkIntProperty(string, S_TRIGGERSOFTLIMIT, 1, 50, 0, "Invalid trigger soft limit: ");
        props.setProperty(S_TRIGGERSOFTLIMIT, "" + triggerSoftLimit);
    }

    private void getTriggerHardLimit() {
        String string = props.getProperty(S_TRIGGERHARDLIMIT, "100");
        triggerHardLimit = this.checkIntProperty(string, S_TRIGGERHARDLIMIT, triggerSoftLimit, 100, 0, "Invalid trigger hard limit: ");
        props.setProperty(S_TRIGGERHARDLIMIT, "" + triggerHardLimit);
    }

    private void getDbLoader() {
        int n = Runtime.getRuntime().availableProcessors();
        int n2 = Math.min(5, n);
        String string = props.getProperty(S_DBLOADER, "" + n2);
        dbLoaders = this.checkIntProperty(string, S_DBLOADER, 1, n2, 0, "Invalid number of database loaders : ");
        props.setProperty(S_DBLOADER, "" + dbLoaders);
    }

    private void getParameterHandling() {
        String string = props.getProperty(S_PARAMETERHANDLING, "LIBERAL").toUpperCase();
        if (string.startsWith("S")) {
            strict_variables = true;
            warn_variables = false;
            parameterHandling = "STRICT";
        } else if (string.startsWith("W")) {
            strict_variables = false;
            warn_variables = true;
            parameterHandling = "WARN";
        } else {
            strict_variables = false;
            warn_variables = false;
            parameterHandling = "LIBERAL";
        }
        props.setProperty(S_PARAMETERHANDLING, parameterHandling);
    }

    private void getUnresolvedParameterHandling() {
        String string = props.getProperty(S_UNRESPARMHANDLING, "ERROR").toUpperCase();
        unresolvedParameterHandling = string.equals("BLANK") ? 1 : (string.equals("ECHO") ? 2 : 0);
        props.setProperty(S_UNRESPARMHANDLING, string);
    }

    private void getParameterSyntaxHandling() {
        String string = props.getProperty(S_PARAMETERSYNTAXHANDLING, "ERROR").toUpperCase();
        if (string.equals("IGNORE")) {
            parameterSyntaxHandling = 1;
        } else if (string.equals("ERROR")) {
            unresolvedParameterHandling = 0;
        }
        props.setProperty(S_PARAMETERSYNTAXHANDLING, string);
    }

    private Vector convertEntryToVector(String string, String string2) {
        StringReader stringReader = new StringReader(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(35, 35);
        Vector<String> vector = new Vector<String>();
        try {
            int n;
            while ((n = streamTokenizer.nextToken()) != -1) {
                if (n != -3) continue;
                vector.add(streamTokenizer.sval.toUpperCase());
                if (string2 == null) continue;
                SDMSThread.doTrace(null, string2 + streamTokenizer.sval, 0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return vector;
    }

    private void getArchiveCols() {
        String string = props.getProperty(S_ARCSMECOLS, ALL);
        String string2 = props.getProperty(S_ARCATCOLS, ALL);
        String string3 = props.getProperty(S_ARCDICOLS, ALL);
        String string4 = props.getProperty(S_ARCEVCOLS, ALL);
        String string5 = props.getProperty(S_ARCEXCOLS, ALL);
        String string6 = props.getProperty(S_ARCHICOLS, ALL);
        String string7 = props.getProperty(S_ARCKJCOLS, ALL);
        String string8 = props.getProperty(S_ARCSMESCOLS, ALL);
        if (!archive) {
            return;
        }
        smeColumns = string.toUpperCase().equals(NONE) ? null : (string.toUpperCase().equals(ALL) ? new Vector() : this.convertEntryToVector(string, null));
        atColumns = string2.toUpperCase().equals(NONE) ? null : (string2.toUpperCase().equals(ALL) ? new Vector() : this.convertEntryToVector(string2, null));
        diColumns = string3.toUpperCase().equals(NONE) ? null : (string3.toUpperCase().equals(ALL) ? new Vector() : this.convertEntryToVector(string3, null));
        evColumns = string4.toUpperCase().equals(NONE) ? null : (string4.toUpperCase().equals(ALL) ? new Vector() : this.convertEntryToVector(string4, null));
        exColumns = string5.toUpperCase().equals(NONE) ? null : (string5.toUpperCase().equals(ALL) ? new Vector() : this.convertEntryToVector(string5, null));
        hiColumns = string6.toUpperCase().equals(NONE) ? null : (string6.toUpperCase().equals(ALL) ? new Vector() : this.convertEntryToVector(string6, null));
        kjColumns = string7.toUpperCase().equals(NONE) ? null : (string7.toUpperCase().equals(ALL) ? new Vector() : this.convertEntryToVector(string7, null));
        smesColumns = string8.toUpperCase().equals(NONE) ? null : (string8.toUpperCase().equals(ALL) ? new Vector() : this.convertEntryToVector(string8, null));
    }

    private void getExportVariables() {
        exportVariablesString = props.getProperty(S_EXPORTVARIABLES, "ENVIRONMENT,ERRORLOG,EXPFINALTIME,EXPRUNTIME,FINISHTIME,ISRESTARTABLE,JOBID,JOBNAME,JOBSTATE,JOBTAG,KEY,LOGFILE,MASTERID,MERGEDSTATE,PARENTID,PID,RERUNSEQ,RESOURCETIME,RUNNABLETIME,SCOPENAME,SDMSHOST,SDMSPORT,SEID,SEOWNER,STARTTIME,STATE,SUBMITGROUP,SUBMITTER,SUBMITTIME,SYNCTIME,SYSDATE,TRIGGERBASE,TRIGGERBASEID,TRIGGERBASEJOBID,TRIGGERNAME,TRIGGERNEWSTATE,TRIGGERORIGIN,TRIGGERORIGINID,TRIGGERORIGINJOBID,TRIGGEROLDSTATE,TRIGGERREASON,TRIGGERREASONID,TRIGGERREASONJOBID,TRIGGERSEQNO,TRIGGERTYPE,LAST_WARNING,WORKDIR");
        userExportVariablesString = props.getProperty(S_USEREXPORTVARIABLES, "");
        if (userExportVariablesString.length() != 0) {
            exportVariablesString = exportVariablesString + COMMA + userExportVariablesString;
        }
        exportVariables = this.convertEntryToVector(exportVariablesString, "Exporting ");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < exportVariables.size(); ++i) {
            stringBuffer.append(exportVariables.get(i).toString());
            if (i >= exportVariables.size() - 1) continue;
            stringBuffer.append(COMMA);
        }
        props.setProperty(S_EXPORTVARIABLES, stringBuffer.toString());
    }

    private void getScopeSysVars() {
        String string = props.getProperty(S_SCOPESYSVARS, "");
        if (string.length() != 0) {
            scopeSysVars = new HashSet();
            scopeSysVars.addAll(this.convertEntryToVector(string, "Defining Scope System Variables "));
        } else {
            scopeSysVars = new HashSet();
        }
        props.setProperty(S_SCOPESYSVARS, string);
    }

    private void getDumpLangLevel() {
        String string = props.getProperty(S_DMPLANGLEVEL, LANGLEVELS[DEFAULT_LANGLEVEL]);
        for (int i = 0; i < LANGLEVELS.length; ++i) {
            if (!string.equals(LANGLEVELS[i]) && !string.equals("v" + LANGLEVELS[i]) && !string.equals("V" + LANGLEVELS[i])) continue;
            dumpLangLevel = i;
            break;
        }
        props.setProperty(S_DMPLANGLEVEL, LANGLEVELS[dumpLangLevel]);
    }

    private void getSSOconfig() {
        String string = props.getProperty(S_INCLUDEDOMAINNAMES, S_FALSE);
        includeDomainNames = Boolean.parseBoolean(string.trim());
        props.setProperty(S_INCLUDEDOMAINNAMES, includeDomainNames ? S_TRUE : S_FALSE);
        string = props.getProperty(S_AUTOCREATEUSERS, S_FALSE);
        autoCreateUsers = Boolean.parseBoolean(string.trim());
        props.setProperty(S_AUTOCREATEUSERS, autoCreateUsers ? S_TRUE : S_FALSE);
        string = props.getProperty(S_AUTOCREATEGROUPS, S_FALSE);
        autoCreateGroups = Boolean.parseBoolean(string.trim());
        props.setProperty(S_AUTOCREATEGROUPS, autoCreateGroups ? S_TRUE : S_FALSE);
        string = props.getProperty(S_USEADGROUPS, S_FALSE);
        useAdGroups = Boolean.parseBoolean(string.trim());
        props.setProperty(S_USEADGROUPS, useAdGroups ? S_TRUE : S_FALSE);
        serverName = props.getProperty(S_SERVERNAME, "DEFAULT");
        props.setProperty(S_SERVERNAME, serverName);
        bicsuitePrefix = props.getProperty(S_BICSUITEPREFIX, "BICSUITE");
        props.setProperty(S_BICSUITEPREFIX, bicsuitePrefix);
        string = props.getProperty(S_NAMECASE, S_CASE_UPPER).toUpperCase();
        if (string.equals(S_CASE_UPPER)) {
            nameCase = CASE_UPPER;
        } else if (string.equals(S_CASE_LOWER)) {
            nameCase = CASE_LOWER;
        } else if (string.equals(S_CASE_MIXED)) {
            nameCase = CASE_MIXED;
        } else {
            nameCase = CASE_UPPER;
            string = S_CASE_UPPER;
        }
        props.setProperty(S_NAMECASE, string);
    }

    private int checkIntProperty(String string, String string2, int n, int n2, int n3, String string3) {
        int n4;
        try {
            n4 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            n4 = n2;
            SDMSThread.doTrace(null, "Invalid number format in " + props.getProperty(string2), 1);
        }
        if (n4 < n) {
            SDMSThread.doTrace(null, string3 + n4, 1);
            n4 = n;
        }
        if (n3 > n && n4 > n3) {
            SDMSThread.doTrace(null, string3 + n4, 1);
            n4 = n2;
        }
        return n4;
    }

    public static synchronized void incrCntRwTx() {
        ++cntRwTx;
    }

    public static synchronized void incrCntDl() {
        ++cntDl;
    }

    public static synchronized void incrCntWl() {
        ++cntWl;
    }

    public Object clone() throws CloneNotSupportedException {
        SystemEnvironment systemEnvironment = (SystemEnvironment)super.clone();
        systemEnvironment.systemDateFormat = (SimpleDateFormat)this.systemDateFormat.clone();
        systemEnvironment.jsCommDateFormat = (SimpleDateFormat)this.jsCommDateFormat.clone();
        return systemEnvironment;
    }

    public void enableConnect() {
        this.connectState.setValue(this.connectState.getValue() & 2);
    }

    public void disableConnect() {
        this.connectState.setValue(this.connectState.getValue() | 1);
    }

    public void setConnectShutdown() {
        this.connectState.setValue(this.connectState.getValue() | 2);
    }

    public int getConnectState() {
        return this.connectState.getValue();
    }

    public static void setProtectMode() {
        protectMode = true;
    }

    public static void resetProtectMode() {
        protectMode = false;
    }

    public static boolean getProtectMode() {
        return protectMode;
    }

    public Long randomLong() {
        return new Long(Math.abs(random.nextLong()));
    }

    public static synchronized int getTraceLevel() {
        return traceLevel;
    }

    public static synchronized void setTraceLevel(int n) {
        traceLevel = n;
    }

    public static void getSharedLock() {
        executeLock.getSharedLock();
    }

    public static void releaseSharedLock() {
        executeLock.releaseSharedLock();
    }

    public static void getExclusiveLock() {
        executeLock.getExclusiveLock();
    }

    public static void releaseExclusiveLock() {
        executeLock.releaseExclusiveLock();
    }

    public Long txTime() {
        return new Long(this.tx.startTime);
    }

    public static final GregorianCalendar newGregorianCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(systemTimeZone, systemLocale);
        gregorianCalendar.setFirstDayOfWeek(2);
        gregorianCalendar.setMinimalDaysInFirstWeek(4);
        gregorianCalendar.clear();
        return gregorianCalendar;
    }

    static {
        cntRwTx = 0L;
        cntDl = 0L;
        cntWl = 0L;
        got_properties = false;
        CASE_UPPER = 0;
        CASE_LOWER = 1;
        CASE_MIXED = 2;
        systemTimeZone = TimeZone.getTimeZone("GMT");
        systemLocale = new Locale("EN", "GB");
        staticJSCommDateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss Z", systemLocale);
        staticOldJSCommDateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss z", systemLocale);
        staticSystemDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z", systemLocale);
        jidsStarting = new HashMap();
        staticSystemDateFormat.setTimeZone(systemTimeZone);
        try {
            notifySocket = new DatagramSocket();
        }
        catch (Exception exception) {
            notifySocket = null;
        }
        protectMode = false;
        random = new Random();
        executeLock = new ExecuteLock();
    }
}

